/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.handler;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.handler.glfw.InputEventHandler;
import bre2el.fpsreducer.util.Logger;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.glfw.GLFW;

public class WakeupEventHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    private long windowHandle;
    private int maxFPS;
    private long idleStartTime;
    private int currentGameSettingFPS;
    private float currentGameSettingVolume;
    public static boolean reduceFPS = false;
    private boolean stopSound = false;
    private long prevInputEventNanoSec;
    private int prevWindowAttrib = 131073;
    private long prevMovingEventMilliSec;
    private double prevX;
    private double prevY;
    private double prevZ;
    private float prevRotationYaw;
    private float prevRotationPitch;

    public WakeupEventHandler() {
        this.windowHandle = this.mc.field_195558_d.func_198092_i();
        this.maxFPS = (int)GameSettings.Options.FRAMERATE_LIMIT.func_198009_f();
        Logger.debug("FRAMERATE_LIMIT.getValueMax()=", this.maxFPS);
        InputEventHandler.INSTANCE.addCallbacks();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            block21: {
                if (Config.CURRENT.reducingInBackground || Config.CURRENT.suppressSound) {
                    int curWindowAttrib = GLFW.glfwGetWindowAttrib((long)this.windowHandle, (int)131073);
                    if (curWindowAttrib == 0) {
                        if (curWindowAttrib != this.prevWindowAttrib) {
                            Logger.debug("Window has been inactive.");
                            this.prevWindowAttrib = curWindowAttrib;
                            if (this.mc.field_71441_e != null && Config.CURRENT.reducingInBackground) {
                                this.reduceFPS();
                            }
                            if (Config.CURRENT.suppressSound) {
                                this.stopSound();
                            }
                        }
                        if (Config.CURRENT.reducingInBackground) {
                            return;
                        }
                    } else if (curWindowAttrib != this.prevWindowAttrib) {
                        Logger.debug("Window has been active.");
                        this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
                        this.prevWindowAttrib = curWindowAttrib;
                        this.recoverSound();
                    }
                }
                if (this.mc.field_71441_e == null) {
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    return;
                }
                if (!Config.CURRENT.enableFpsReducer) {
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    return;
                }
                long currentInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
                if (currentInputEventNanoSec != this.prevInputEventNanoSec) {
                    this.prevInputEventNanoSec = currentInputEventNanoSec;
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    return;
                }
                try {
                    if (this.mc.field_71439_g.field_71158_b.field_187255_c || this.mc.field_71439_g.field_71158_b.field_187256_d || this.mc.field_71439_g.field_71158_b.field_187258_f || this.mc.field_71439_g.field_71158_b.field_187257_e || this.mc.field_71439_g.field_71158_b.field_78901_c || this.mc.field_71439_g.field_71158_b.field_78899_d) {
                        this.resetWaitingTimer();
                        this.recoverFPS();
                        return;
                    }
                }
                catch (NullPointerException e) {
                    if (!Config.GLOBAL.debugLog) break block21;
                    e.printStackTrace();
                }
            }
            if (!Config.CURRENT.ignoreHoldButton) {
                for (int btn = 0; btn <= 7; ++btn) {
                    int state = GLFW.glfwGetMouseButton((long)this.windowHandle, (int)btn);
                    if (state != 1) continue;
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    break;
                }
            }
            switch (Config.CURRENT.detectMoving) {
                case 1: {
                    if (this.mc.field_71439_g == null || this.mc.field_71439_g.field_70122_E || !this.checkMovingSimply() && !this.checkRotation()) break;
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    return;
                }
                case 2: {
                    if (!this.checkMovingSimply() && !this.checkRotation()) break;
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    return;
                }
            }
            this.checkWaitingTimer();
        }
    }

    private boolean checkMoving() {
        int interval = 1000;
        long curMovingEventMilliSec = System.currentTimeMillis();
        if (curMovingEventMilliSec - this.prevMovingEventMilliSec >= 1000L & this.mc.field_71439_g != null) {
            double mx = this.mc.field_71439_g.field_70165_t - this.prevX;
            double my = this.mc.field_71439_g.field_70163_u - this.prevY;
            double mz = this.mc.field_71439_g.field_70161_v - this.prevZ;
            double movement = mx * mx + my * my + mz * mz;
            Logger.debug("movement:" + Math.sqrt(movement));
            this.prevX = this.mc.field_71439_g.field_70165_t;
            this.prevY = this.mc.field_71439_g.field_70163_u;
            this.prevZ = this.mc.field_71439_g.field_70161_v;
            this.prevMovingEventMilliSec = curMovingEventMilliSec;
            double threshold = 0.9;
            return movement >= threshold * threshold;
        }
        return false;
    }

    private boolean checkMovingSimply() {
        if (this.mc.field_71439_g != null && (this.prevX != this.mc.field_71439_g.field_70165_t || this.prevY != this.mc.field_71439_g.field_70163_u || this.prevZ != this.mc.field_71439_g.field_70161_v)) {
            this.prevX = this.mc.field_71439_g.field_70165_t;
            this.prevY = this.mc.field_71439_g.field_70163_u;
            this.prevZ = this.mc.field_71439_g.field_70161_v;
            return true;
        }
        return false;
    }

    private boolean checkRotation() {
        if (this.mc.field_71439_g != null && (this.prevRotationYaw != this.mc.field_71439_g.field_70177_z || this.prevRotationPitch != this.mc.field_71439_g.field_70125_A)) {
            this.prevRotationYaw = this.mc.field_71439_g.field_70177_z;
            this.prevRotationPitch = this.mc.field_71439_g.field_70125_A;
            return true;
        }
        return false;
    }

    private void resetWaitingTimer() {
        this.idleStartTime = System.currentTimeMillis();
    }

    private void checkWaitingTimer() {
        if (!reduceFPS && System.currentTimeMillis() - this.idleStartTime > (long)(Config.CURRENT.waitingTime * 1000)) {
            this.reduceFPS();
        }
    }

    private void reduceFPS() {
        if (!reduceFPS) {
            this.currentGameSettingFPS = this.mc.field_71474_y.field_74350_i;
            this.mc.field_71474_y.field_74350_i = Config.CURRENT.idleFps;
            reduceFPS = true;
            Logger.debug("Reducing max FPS: ", this.mc.field_71474_y.field_74350_i);
        }
    }

    private void recoverFPS() {
        if (reduceFPS) {
            this.mc.field_71474_y.field_74350_i = this.currentGameSettingFPS;
            reduceFPS = false;
            if (this.mc.field_71474_y.field_74350_i == this.maxFPS) {
                Logger.debug("Recovering max FPS: Unlimited");
            } else {
                Logger.debug("Recovering max FPS: ", this.mc.field_71474_y.field_74350_i);
            }
        }
    }

    private void stopSound() {
        if (!this.stopSound) {
            this.currentGameSettingVolume = this.mc.field_71474_y.func_186711_a(SoundCategory.MASTER);
            float newVolume = this.currentGameSettingVolume * (float)Config.CURRENT.suppressedVolume / 100.0f;
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, newVolume);
            this.stopSound = true;
            Logger.debug("Suppressing master volume: ", (int)(newVolume * 100.0f));
        }
    }

    private void recoverSound() {
        if (this.stopSound) {
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, this.currentGameSettingVolume);
            this.stopSound = false;
            Logger.debug("Recovering master volume: ", (int)(this.currentGameSettingVolume * 100.0f));
        }
    }

    private int getWaitingTimeSecond() {
        return (int)(System.currentTimeMillis() - this.idleStartTime) / 1000;
    }
}

