/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.gui.GuiSlider;
import bre2el.fpsreducer.handler.WakeupEventHandler;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiConfigAdvanced
extends Screen {
    private final int BTN_W = 240;
    private final int BTN_W_SWCFG = 90;
    private final int BTN_H = 20;
    private final int BTN_OFFSET = 120;
    private int baseY;
    private final int GRID_HEIGHT = 24;
    private Screen parentScreen;

    public GuiConfigAdvanced(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("fpsreducer.config.advanced.screen.title", new Object[0]));
        this.parentScreen = parent;
    }

    public void init() {
        this.baseY = this.height / 2 - (GuiPart.BTN_BACK.row + 2) * 24 / 2 - 3;
        this.addButton((Widget)new Button(this.width / 2 - 120, this.baseY + 24 * (GuiPart.BTN_DETECT_MOVING.row + 1), 240, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.detectMoving", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("fpsreducer.config.menu.detectMoving." + Config.CURRENT.detectMoving), (Object[])new Object[0]), button -> {
            ++Config.CURRENT.detectMoving;
            Config.CURRENT.detectMoving = Config.CURRENT.detectMoving > 2 ? 0 : Config.CURRENT.detectMoving;
            button.setMessage(I18n.func_135052_a((String)"fpsreducer.config.menu.detectMoving", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("fpsreducer.config.menu.detectMoving." + Config.CURRENT.detectMoving), (Object[])new Object[0]));
        }));
        this.addButton((Widget)new Button(this.width / 2 - 120, this.baseY + 24 * (GuiPart.BTN_IGNORE_HOLD_BTN.row + 1), 240, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.ignoreHoldButton", (Object[])new Object[0]) + ": " + this.getStringOnOff(Config.CURRENT.ignoreHoldButton), button -> {
            Config.CURRENT.ignoreHoldButton = !Config.CURRENT.ignoreHoldButton;
            button.setMessage(I18n.func_135052_a((String)"fpsreducer.config.menu.ignoreHoldButton", (Object[])new Object[0]) + ": " + this.getStringOnOff(Config.CURRENT.ignoreHoldButton));
        }));
        this.addButton((Widget)new GuiSlider(this.width / 2 - 120, this.baseY + 24 * (GuiPart.SLD_GUISCREEN_FPS.row + 1), 240, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.guiScreenFps", (Object[])new Object[0]) + ": ", "", 10.0, 61.0, Config.CURRENT.guiScreenFps == 0 ? 61.0 : (double)Config.CURRENT.guiScreenFps, false, true, slider -> {
            int val = slider.getValueInt();
            Config.CURRENT.guiScreenFps = val >= 61 ? 0 : val;
            WakeupEventHandler.INSTANCE.forceRecoverFPS("GUI FPS slider changed");
        }, null).addSubstituteText(61.0, I18n.func_135052_a((String)"fpsreducer.config.OFF", (Object[])new Object[0])));
        this.addButton((Widget)new Button(this.width / 2 - 120, this.baseY + 24 * (GuiPart.BTN_BACK.row + 1), 240, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.returnToGame", (Object[])new Object[0]), button -> {
            this.onClose();
            if (this.parentScreen == null) {
                // empty if block
            }
        }));
        Button btn = new Button(this.width - 90, 0, 90, 20, I18n.func_135052_a((String)(Config.isPlayerConfig() ? "fpsreducer.config.playerConfig" : "fpsreducer.config.globalConfig"), (Object[])new Object[0]), null);
        this.addButton((Widget)btn);
        btn.active = false;
        super.init();
    }

    public void onClose() {
        this.minecraft.func_147108_a(this.parentScreen);
        Config.CURRENT.writeToConfigData();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"fpsreducer.config.advanced.screen.title", (Object[])new Object[0]), this.width / 2, this.baseY + 8, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }

    public boolean isPauseScreen() {
        return true;
    }

    private String getStringOnOff(boolean flag) {
        return flag ? I18n.func_135052_a((String)"fpsreducer.config.ON", (Object[])new Object[0]) : I18n.func_135052_a((String)"fpsreducer.config.OFF", (Object[])new Object[0]);
    }

    private static enum GuiPart {
        BTN_DETECT_MOVING(0),
        BTN_IGNORE_HOLD_BTN(1),
        SLD_GUISCREEN_FPS(2),
        BTN_BACK(3),
        BTN_SWITCH_CONFIG(-1);

        public int row;

        private GuiPart(int row) {
            this.row = row;
        }
    }
}

