/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.gui.GuiConfigAdvanced;
import bre2el.fpsreducer.gui.GuiHudPosAdjuster;
import bre2el.fpsreducer.gui.GuiSlider;
import bre2el.fpsreducer.gui.GuiSliderFlexTime;
import bre2el.fpsreducer.gui.Hud;
import bre2el.fpsreducer.handler.WakeupEventHandler;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiConfigScreen
extends Screen {
    Button btnConfigSelection;
    private final int gridHeight = 24;
    private int baseY;
    private final int BTN_W = 240;
    private final int BTN_W_HALF = 118;
    private final int BTN_W_SWCFG = 90;
    private final int BTN_OFFSET = 120;
    Screen parentScreen;

    public GuiConfigScreen(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("fpsreducer.config.screen.title", new Object[0]));
        this.parentScreen = parent;
    }

    public void init() {
        this.baseY = this.height / 2 - (GuiPart.BTN_EXIT.row + 2) * 24 / 2 - 3;
        this.addButton((Widget)new Button(this.width / 2 - 120, this.baseY + 24 * (GuiPart.BTN_ENABLE_FPSREDUCER.row + 1), 240, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.enableFpsReducer", (Object[])new Object[0]) + ": " + this.getStringOnOff(Config.CURRENT.enableFpsReducer), button -> {
            Config.CURRENT.enableFpsReducer = !Config.CURRENT.enableFpsReducer;
            WakeupEventHandler.INSTANCE.forceRecoverFPS("FPS Reducer button clicked");
            button.setMessage(I18n.func_135052_a((String)"fpsreducer.config.menu.enableFpsReducer", (Object[])new Object[0]) + ": " + this.getStringOnOff(Config.CURRENT.enableFpsReducer));
        }));
        GuiSliderFlexTime guiSliderTime = new GuiSliderFlexTime(this.width / 2 - 120, this.baseY + 24 * (GuiPart.SLD_WAIT_TIME.row + 1), 240, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.waitingTime", (Object[])new Object[0]) + ": ", Config.CURRENT.waitingTime, slider -> {
            Config.CURRENT.waitingTime = ((GuiSliderFlexTime)slider).getTimeSec();
        }, null);
        this.addButton((Widget)guiSliderTime);
        GuiSlider guiSliderFps = new GuiSlider(this.width / 2 - 120, this.baseY + 24 * (GuiPart.SLD_IDLE_FPS.row + 1), 240, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.idleFps", (Object[])new Object[0]) + ": ", "", 1.0, 60.0, Config.CURRENT.idleFps, false, true, slider -> {
            Config.CURRENT.idleFps = slider.getValueInt();
        }, null);
        this.addButton((Widget)guiSliderFps);
        this.addButton((Widget)new Button(this.width / 2 - 120, this.baseY + 24 * (GuiPart.BTN_REDUCE_IN_BG.row + 1), 240, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.reducingInBackground", (Object[])new Object[0]) + ": " + this.getStringOnOff(Config.CURRENT.reducingInBackground), button -> {
            Config.CURRENT.reducingInBackground = !Config.CURRENT.reducingInBackground;
            button.setMessage(I18n.func_135052_a((String)"fpsreducer.config.menu.reducingInBackground", (Object[])new Object[0]) + ": " + this.getStringOnOff(Config.CURRENT.reducingInBackground));
        }));
        GuiSlider guiSliderVol = new GuiSlider(this.width / 2 - 120, this.baseY + 24 * (GuiPart.SLD_SOUND_VOL.row + 1), 240, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.suppressSound", (Object[])new Object[0]) + ": ", "%", 0.0, 100.0, Config.CURRENT.suppressSound ? (double)Config.CURRENT.suppressedVolume : 100.0, false, true, slider -> {
            Config.CURRENT.suppressedVolume = slider.getValueInt();
            Config.CURRENT.suppressSound = Config.CURRENT.suppressedVolume != 100;
        }, null);
        guiSliderVol.addSubstituteText(100.0, this.getStringOnOff(false));
        this.addButton((Widget)guiSliderVol);
        this.addButton((Widget)new Button(this.width / 2 - 120, this.baseY + 24 * (GuiPart.BTN_HUD_POS.row + 1), 118, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.hudLayout", (Object[])new Object[0]), button -> {
            GuiHudPosAdjuster guiHudPosAdjuster = new GuiHudPosAdjuster(this);
            this.minecraft.func_147108_a((Screen)guiHudPosAdjuster);
        }));
        GuiSlider guiSliderScale = new GuiSlider(this.width / 2 + 2, this.baseY + 24 * (GuiPart.SLD_HUD_SCALE.row + 1), 118, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.hudScale", (Object[])new Object[0]) + ": ", "", 0.1f, 2.0, Config.CURRENT.hudScale, true, true, slider -> {
            Config.CURRENT.hudScale = (double)((int)(slider.getValue() * 10.0)) / 10.0;
        }, null);
        this.addButton((Widget)guiSliderScale);
        this.addButton((Widget)new Button(this.width / 2 - 120, this.baseY + 24 * (GuiPart.BTN_ADVANCED_CONFIG.row + 1), 118, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.advancedOptions", (Object[])new Object[0]), button -> {
            GuiConfigAdvanced guiConfigAdvanced = new GuiConfigAdvanced(this);
            this.minecraft.func_147108_a((Screen)guiConfigAdvanced);
            Config.CURRENT.writeToConfigData();
        }));
        this.addButton((Widget)new Button(this.width / 2 + 2, this.baseY + 24 * (GuiPart.BTN_EXIT.row + 1), 118, 20, I18n.func_135052_a((String)"fpsreducer.config.menu.returnToGame", (Object[])new Object[0]), button -> {
            this.onClose();
            if (this.parentScreen == null) {
                // empty if block
            }
        }));
        this.btnConfigSelection = new Button(this.width - 90, 0, 90, 20, I18n.func_135052_a((String)(Config.isPlayerConfig() ? "fpsreducer.config.playerConfig" : "fpsreducer.config.globalConfig"), (Object[])new Object[0]), button -> {
            Config.toggleConfig();
            WakeupEventHandler.INSTANCE.forceRecoverFPS("config mode changed");
            button.setMessage(I18n.func_135052_a((String)(Config.isPlayerConfig() ? "fpsreducer.config.playerConfig" : "fpsreducer.config.globalConfig"), (Object[])new Object[0]));
            Hud.getInstance().update();
            this.init(this.minecraft, this.width, this.height);
        });
        this.addButton((Widget)this.btnConfigSelection);
        this.btnConfigSelection.active = Config.GLOBAL.allowPlayerConfig;
        super.init();
    }

    public void onClose() {
        this.minecraft.func_147108_a(this.parentScreen);
        Config.CURRENT.writeToConfigData();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"fpsreducer.config.screen.title", (Object[])new Object[0]), this.width / 2, this.baseY + 8, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }

    public boolean isPauseScreen() {
        return true;
    }

    private String getStringOnOff(boolean flag) {
        return flag ? I18n.func_135052_a((String)"fpsreducer.config.ON", (Object[])new Object[0]) : I18n.func_135052_a((String)"fpsreducer.config.OFF", (Object[])new Object[0]);
    }

    private static enum GuiPart {
        BTN_ENABLE_FPSREDUCER(0),
        SLD_WAIT_TIME(1),
        SLD_IDLE_FPS(2),
        BTN_REDUCE_IN_BG(3),
        SLD_SOUND_VOL(4),
        BTN_HUD_POS(5),
        SLD_HUD_SCALE(5),
        BTN_ADVANCED_CONFIG(6),
        BTN_EXIT(6),
        BTN_SWITCH_CONFIG(-1);

        public int row;

        private GuiPart(int row) {
            this.row = row;
        }
    }
}

