/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.gui.ButtonEx;
import bre2el.fpsreducer.gui.CheckboxButtonEx;
import bre2el.fpsreducer.gui.GuiLabelEx;
import bre2el.fpsreducer.gui.Hud;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiHudPosAdjuster
extends Screen {
    private Minecraft mc = Minecraft.func_71410_x();
    private Screen parentScreen;
    private double clickedPosX;
    private double clickedPosY;
    private boolean dragging;
    private int buttonsPos;
    private static final int BTNPOS_UPPER = 0;
    private static final int BTNPOS_LOWER = 1;
    private final int boxWidth = 11;
    private static final int BTN_HUDINFO = 10;
    private static final int BTN_ALIGN = 11;
    private static final int BTN_RESET = 12;
    private static final int BTN_DONE = 13;
    protected List<GuiLabelEx> labelList = Lists.newArrayList();

    public GuiHudPosAdjuster(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("fpsreducer.config.hudposadjuster.screen.title", new Object[0]));
        this.parentScreen = parent;
    }

    public void init() {
        this.addButton((Widget)new CheckboxButtonEx(0, 0, 11, 11, "", this.isSelected(1), checkbox -> this.actionPerformed((AbstractButton)checkbox, 1)));
        this.addButton((Widget)new CheckboxButtonEx((this.width - 11) / 2, 0, 11, 11, "", this.isSelected(2), checkbox -> this.actionPerformed((AbstractButton)checkbox, 2)));
        this.addButton((Widget)new CheckboxButtonEx(this.width - 11, 0, 11, 11, "", this.isSelected(3), checkbox -> this.actionPerformed((AbstractButton)checkbox, 3)));
        this.addButton((Widget)new CheckboxButtonEx(this.width - 11, (this.height - 11) / 2, 11, 11, "", this.isSelected(4), checkbox -> this.actionPerformed((AbstractButton)checkbox, 4)));
        this.addButton((Widget)new CheckboxButtonEx(this.width - 11, this.height - 11, 11, 11, "", this.isSelected(5), checkbox -> this.actionPerformed((AbstractButton)checkbox, 5)));
        this.addButton((Widget)new CheckboxButtonEx((this.width - 11) / 2, this.height - 11, 11, 11, "", this.isSelected(6), checkbox -> this.actionPerformed((AbstractButton)checkbox, 6)));
        this.addButton((Widget)new CheckboxButtonEx(0, this.height - 11, 11, 11, "", this.isSelected(7), checkbox -> this.actionPerformed((AbstractButton)checkbox, 7)));
        this.addButton((Widget)new CheckboxButtonEx(0, (this.height - 11) / 2, 11, 11, "", this.isSelected(8), checkbox -> this.actionPerformed((AbstractButton)checkbox, 8)));
        this.buttonsPos = this.getButtonsPos();
        this.placeButtons(this.buttonsPos);
        super.init();
    }

    private void reinitGui() {
        this.resize(this.mc, this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p());
    }

    private void placeButtons(int pos) {
        int oy;
        int ox;
        int space = 10;
        int btnWidth = 100;
        int btnHeight = 20;
        int gridWidth = btnWidth + 2;
        int gridHeight = btnHeight + 2;
        int entireWidth = 310;
        int labelWidth = entireWidth - (gridWidth + space);
        switch (pos) {
            default: {
                ox = (this.width - entireWidth) / 2;
                oy = 20;
                break;
            }
            case 1: {
                ox = (this.width - entireWidth) / 2;
                oy = this.height / 2 + 20;
            }
        }
        List desc = this.font.func_78271_c(I18n.func_135052_a((String)"fpsreducer.config.hudPosAdj.description", (Object[])new Object[0]), labelWidth);
        GuiLabelEx guiLabel = new GuiLabelEx(this.font, 20, ox + gridWidth + space, oy + 1, labelWidth, 10, -1);
        for (String line : desc) {
            guiLabel.addLine(line);
        }
        this.labelList.add(guiLabel);
        this.addButton((Widget)new ButtonEx(ox, oy, btnWidth, btnHeight, I18n.func_135052_a((String)("fpsreducer.config.hudPosAdj.hudInfo." + Config.CURRENT.hudInfo), (Object[])new Object[0]), button -> this.actionPerformed((AbstractButton)button, 10)));
        ButtonEx btnAlign = new ButtonEx(ox, oy + gridHeight, btnWidth, btnHeight, I18n.func_135052_a((String)("fpsreducer.config.hudPosAdj.alignment." + Config.CURRENT.curHudPos.alignment), (Object[])new Object[0]), button -> this.actionPerformed((AbstractButton)button, 11));
        btnAlign.active = Config.CURRENT.hudInfo != 0;
        this.addButton((Widget)btnAlign);
        this.addButton((Widget)new ButtonEx(ox, oy + gridHeight * 2, btnWidth, btnHeight, I18n.func_135052_a((String)"fpsreducer.config.hudPosAdj.reset", (Object[])new Object[0]), button -> this.actionPerformed((AbstractButton)button, 12)));
        this.addButton((Widget)new ButtonEx(ox, oy + gridHeight * 3, btnWidth, btnHeight, I18n.func_135052_a((String)"fpsreducer.config.menu.returnToGame", (Object[])new Object[0]), button -> this.actionPerformed((AbstractButton)button, 13)));
    }

    private int getButtonsPos() {
        if (Hud.getInstance().getPosY() > this.height / 2) {
            return 0;
        }
        return 1;
    }

    private boolean isSelected(int pos) {
        return Config.CURRENT.curHudPos.id == pos;
    }

    private void actionPerformed(AbstractButton button, int id) {
        if (id >= 1 && id <= 8) {
            for (Widget checkBox : this.buttons) {
                if (!(checkBox instanceof CheckboxButtonEx)) continue;
                ((CheckboxButtonEx)checkBox).setIsChecked(false);
            }
            ((CheckboxButtonEx)button).setIsChecked(true);
            Config.CURRENT.setHudReferencePos(id);
            Hud.getInstance().updateAlignOffset();
            Config.CURRENT.writeToConfigData();
            this.reinitGui();
        }
        switch (id) {
            case 10: {
                if (Config.CURRENT.hudInfo >= 5) {
                    Config.CURRENT.hudInfo = 0;
                    for (Widget checkBox : this.buttons) {
                        if (!(checkBox instanceof CheckboxButtonEx)) continue;
                        ((CheckboxButtonEx)checkBox).setIsChecked(false);
                    }
                } else {
                    ++Config.CURRENT.hudInfo;
                    Hud.getInstance().updateHudText();
                }
                Config.CURRENT.writeToConfigData();
                this.reinitGui();
                break;
            }
            case 11: {
                Config.CURRENT.curHudPos.alignment = Config.CURRENT.curHudPos.alignment >= 2 ? 0 : ++Config.CURRENT.curHudPos.alignment;
                Hud.getInstance().updateAlignOffset();
                Config.CURRENT.writeToConfigData();
                this.reinitGui();
                break;
            }
            case 12: {
                Config.CURRENT.resetHudOffsetsAndAlignments();
                Hud.getInstance().updateAlignOffset();
                Config.CURRENT.writeToConfigData();
                this.reinitGui();
                break;
            }
            case 13: {
                Config.CURRENT.writeToConfigData();
                this.mc.func_147108_a(this.parentScreen);
                if (this.parentScreen != null) break;
                break;
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int cur_zLevel = this.getBlitOffset();
        this.setBlitOffset(-20);
        this.renderBackground();
        this.setBlitOffset(cur_zLevel);
        Hud.getInstance().updateBoxPosition(this.width, this.height);
        Hud.getInstance().drawLineToHudBox(this.width, this.height);
        super.render(mouseX, mouseY, partialTicks);
        this.renderLabels(mouseX, mouseY);
        Hud.getInstance().drawHudBox(this.width, this.height, mouseX, mouseY, this.dragging);
        if (this.buttonsPos != this.getButtonsPos()) {
            this.reinitGui();
        }
    }

    private void renderLabels(int mouseX, int mouseY) {
        for (int i = 0; i < this.labelList.size(); ++i) {
            this.labelList.get(i).drawLabel(this.mc, mouseX, mouseY);
        }
    }

    private void printBoxOffset(int pos) {
        String hudCoord = "X=" + Hud.getInstance().getBoxPosX() + ", Y=" + Hud.getInstance().getBoxPosY();
        this.font.func_175063_a(hudCoord, 20.0f, 20.0f, -1);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.dragging = Hud.getInstance().isMouseOver();
        this.clickedPosX = mouseX;
        this.clickedPosY = mouseY;
        if (!this.dragging) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        if (this.dragging) {
            Config.CURRENT.curHudPos.offsetX = (int)((double)Config.CURRENT.curHudPos.offsetX + (mouseX - this.clickedPosX));
            Config.CURRENT.curHudPos.offsetY = (int)((double)Config.CURRENT.curHudPos.offsetY + (mouseY - this.clickedPosY));
            Hud.getInstance().setDragOffset(0, 0);
            Config.CURRENT.writeToConfigData();
        }
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int clickedMouseButton, double dx, double dy) {
        if (this.dragging) {
            Hud.getInstance().setDragOffset((int)(mouseX - this.clickedPosX), (int)(mouseY - this.clickedPosY));
        }
        return super.mouseDragged(mouseX, mouseY, clickedMouseButton, dx, dy);
    }

    public void resize(Minecraft mc, int width, int height) {
        this.labelList.clear();
        super.resize(mc, width, height);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.mc.func_147108_a(this.parentScreen);
            if (this.parentScreen == null) {
                // empty if block
            }
        }
        if (!this.dragging) {
            switch (key) {
                case 87: 
                case 265: {
                    --Config.CURRENT.curHudPos.offsetY;
                    break;
                }
                case 83: 
                case 264: {
                    ++Config.CURRENT.curHudPos.offsetY;
                    break;
                }
                case 68: 
                case 262: {
                    ++Config.CURRENT.curHudPos.offsetX;
                    break;
                }
                case 65: 
                case 263: {
                    --Config.CURRENT.curHudPos.offsetX;
                    break;
                }
            }
            Config.CURRENT.writeToConfigData();
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }
}

