/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui;

import bre2el.fpsreducer.gui.GuiSlider;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiSliderFlexTime
extends GuiSlider {
    private static final int MAXVAL;
    private static final int[] minSec;
    private static final int[] maxSec;
    private static final int[] minVal;
    private static final int[] maxVal;

    protected GuiSliderFlexTime(int xIn, int yIn, int widthIn, int heightIn, String prefix, int curSec, GuiSlider.ISlider applyValueHandler, GuiSlider.ISlider releaseHandler) {
        super(xIn, yIn, widthIn, heightIn, prefix, null, 1.0, MAXVAL, GuiSliderFlexTime.time2Val(curSec), false, true, applyValueHandler, releaseHandler);
    }

    @Override
    protected void updateMessage() {
        if (this.showText) {
            int time = this.getTimeSec();
            if (time == 0) {
                this.setMessage(this.prefix + I18n.func_135052_a((String)"fpsreducer.config.OFF", (Object[])new Object[0]));
            } else {
                this.setMessage(String.format("%s%02d:%02d", this.prefix, time / 60, time % 60));
            }
        } else {
            this.setMessage("");
        }
    }

    public int getTimeSec() {
        int val = this.getValueInt();
        return this.val2Time(val);
    }

    private int val2Time(double val) {
        if (val == (double)MAXVAL) {
            return 0;
        }
        int idx = 0;
        for (int i = 0; i < maxVal.length; ++i) {
            if (!(val <= (double)maxVal[i])) continue;
            idx = i;
            break;
        }
        double time = (double)minSec[idx] + (val - (double)minVal[idx]) * ((double)(maxSec[idx] - minSec[idx]) / (double)(maxVal[idx] - minVal[idx]));
        return (int)Math.round(time);
    }

    private static double time2Val(int sec) {
        if (sec == 0) {
            return MAXVAL;
        }
        int idx = 0;
        for (int i = 0; i < maxSec.length; ++i) {
            if (sec > maxSec[i]) continue;
            idx = i;
            break;
        }
        double val = (double)(sec - minSec[idx]) / (double)(maxSec[idx] - minSec[idx]) * (double)(maxVal[idx] - minVal[idx]) + (double)minVal[idx];
        return val;
    }

    static {
        minSec = new int[]{1, 15, 90, 360, 900};
        maxSec = new int[]{10, 60, 300, 600, 3900};
        minVal = new int[]{1, 11, 21, 29, 34};
        int[] nArray = new int[5];
        nArray[0] = 10;
        nArray[1] = 20;
        nArray[2] = 28;
        nArray[3] = 33;
        MAXVAL = 44;
        nArray[4] = 44;
        maxVal = nArray;
    }
}

