/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.handler;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.handler.GuiOpenEventHandler;
import bre2el.fpsreducer.handler.KeyInputEventHandler;
import bre2el.fpsreducer.handler.glfw.InputEventHandler;
import bre2el.fpsreducer.util.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.glfw.GLFW;

public class WakeupEventHandler {
    public static WakeupEventHandler INSTANCE = new WakeupEventHandler();
    private Minecraft mc = Minecraft.func_71410_x();
    private long windowHandle = this.mc.func_228018_at_().func_198092_i();
    private int maxFPS = 260;
    private long idleStartTime;
    private float currentGameSettingVolume;
    private boolean stopSound = false;
    public int fpsMode;
    public static final int MODE_IDLE = 0;
    public static final int MODE_NORMAL = 1;
    public static final int MODE_GUI = 2;
    private long prevInputEventNanoSec;
    private int prevWindowAttrib = 1;
    private long prevMovingEventMilliSec;
    private double prevX;
    private double prevY;
    private double prevZ;
    private float prevRotationYaw;
    private float prevRotationPitch;
    private String prevReason = "";

    public WakeupEventHandler() {
        Logger.debug("MaxFramerate=", this.maxFPS);
        this.fpsMode = 1;
        InputEventHandler.INSTANCE.addCallbacks();
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
        this.makeWindowStatusActive();
        this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
        this.resetWaitingTimer();
        this.recoverFPS("mouse clicked");
    }

    @SubscribeEvent
    public void onMouseScroll(GuiScreenEvent.MouseScrollEvent.Pre event) {
        this.makeWindowStatusActive();
        this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
        this.resetWaitingTimer();
        this.recoverFPS("mouse wheel");
    }

    @SubscribeEvent
    public void onKeyboardKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        this.makeWindowStatusActive();
        this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
        this.resetWaitingTimer();
        this.recoverFPS("key pressed event");
    }

    private void makeWindowStatusActive() {
        if (this.prevWindowAttrib == 0) {
            Logger.debug("Window has been active. (onInputEvent)");
        }
        this.prevWindowAttrib = 1;
        this.recoverSound();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.checkWakeupEvent();
        }
    }

    private void checkWakeupEvent() {
        block21: {
            if (!Config.CURRENT.enableFpsReducer) {
                this.resetWaitingTimer();
                this.recoverNormalFPS("FPS Reducer disabled");
                return;
            }
            if (Config.CURRENT.reducingInBackground || Config.CURRENT.suppressSound) {
                int curWindowAttrib = GLFW.glfwGetWindowAttrib((long)this.windowHandle, (int)131073);
                if (curWindowAttrib == 0) {
                    if (curWindowAttrib != this.prevWindowAttrib) {
                        Logger.debug("Window has been inactive. (onClientTick)");
                        this.prevWindowAttrib = curWindowAttrib;
                        if (Config.CURRENT.suppressSound) {
                            this.stopSound();
                        }
                    }
                    if (Config.CURRENT.reducingInBackground) {
                        this.reduceFPS("Window has been inactive.");
                        return;
                    }
                } else if (curWindowAttrib != this.prevWindowAttrib) {
                    Logger.debug("Window has been active. (onClientTick)");
                    this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
                    this.prevWindowAttrib = curWindowAttrib;
                    this.recoverSound();
                }
            }
            if (this.mc.field_71441_e == null) {
                this.resetWaitingTimer();
                this.recoverFPS("world is null");
                return;
            }
            long currentInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
            if (currentInputEventNanoSec > this.prevInputEventNanoSec) {
                this.prevInputEventNanoSec = currentInputEventNanoSec;
                if (KeyInputEventHandler.forceIdleKeyPressed) {
                    KeyInputEventHandler.forceIdleKeyPressed = false;
                    this.prevInputEventNanoSec += 500000000L;
                    Logger.debug("force idle key skipped...");
                } else {
                    this.resetWaitingTimer();
                    this.recoverFPS("GLFW input event");
                    return;
                }
            }
            try {
                if (this.mc.field_71439_g.field_71158_b.field_187255_c || this.mc.field_71439_g.field_71158_b.field_187256_d || this.mc.field_71439_g.field_71158_b.field_187258_f || this.mc.field_71439_g.field_71158_b.field_187257_e || this.mc.field_71439_g.field_71158_b.field_78901_c || this.mc.field_71439_g.field_71158_b.field_228350_h_) {
                    this.resetWaitingTimer();
                    this.recoverFPS("movement input");
                    return;
                }
            }
            catch (NullPointerException e) {
                if (!Config.GLOBAL.debugLog) break block21;
                e.printStackTrace();
            }
        }
        if (!Config.CURRENT.ignoreHoldButton) {
            for (int btn = 0; btn <= 7; ++btn) {
                int state = GLFW.glfwGetMouseButton((long)this.windowHandle, (int)btn);
                if (state != 1) continue;
                this.resetWaitingTimer();
                this.recoverFPS("keep mouse button pressed");
                break;
            }
        }
        switch (Config.CURRENT.detectMoving) {
            case 1: {
                if (this.mc.field_71439_g == null || this.mc.field_71439_g.field_70122_E || !this.checkMovingSimply() && !this.checkRotation()) break;
                this.resetWaitingTimer();
                this.recoverFPS("detected movement riding/flying");
                return;
            }
            case 2: {
                if (!this.checkMovingSimply() && !this.checkRotation()) break;
                this.resetWaitingTimer();
                this.recoverFPS("detected movement");
                return;
            }
        }
        this.checkWaitingTimer();
    }

    public static void checkWakeup() {
        INSTANCE.checkWakeupEvent();
    }

    private boolean checkMoving() {
        int interval = 1000;
        long curMovingEventMilliSec = System.currentTimeMillis();
        if (curMovingEventMilliSec - this.prevMovingEventMilliSec >= 1000L & this.mc.field_71439_g != null) {
            double posX = this.mc.field_71439_g.func_226277_ct_();
            double posY = this.mc.field_71439_g.func_226278_cu_();
            double posZ = this.mc.field_71439_g.func_226281_cx_();
            double mx = posX - this.prevX;
            double my = posY - this.prevY;
            double mz = posZ - this.prevZ;
            double movement = mx * mx + my * my + mz * mz;
            Logger.debug("movement:" + Math.sqrt(movement));
            this.prevX = posX;
            this.prevY = posY;
            this.prevZ = posZ;
            this.prevMovingEventMilliSec = curMovingEventMilliSec;
            double threshold = 0.9;
            return movement >= threshold * threshold;
        }
        return false;
    }

    private boolean checkMovingSimply() {
        if (this.mc.field_71439_g != null) {
            double posX = this.mc.field_71439_g.func_226277_ct_();
            double posY = this.mc.field_71439_g.func_226278_cu_();
            double posZ = this.mc.field_71439_g.func_226281_cx_();
            if (this.prevX != posX || this.prevY != posY || this.prevZ != posZ) {
                this.prevX = posX;
                this.prevY = posY;
                this.prevZ = posZ;
                return true;
            }
        }
        return false;
    }

    private boolean checkRotation() {
        if (this.mc.field_71439_g != null && (this.prevRotationYaw != this.mc.field_71439_g.field_70177_z || this.prevRotationPitch != this.mc.field_71439_g.field_70125_A)) {
            this.prevRotationYaw = this.mc.field_71439_g.field_70177_z;
            this.prevRotationPitch = this.mc.field_71439_g.field_70125_A;
            return true;
        }
        return false;
    }

    private void resetWaitingTimer() {
        this.idleStartTime = System.currentTimeMillis();
    }

    private void checkWaitingTimer() {
        if (this.fpsMode != 0 && Config.CURRENT.waitingTime != 0 && System.currentTimeMillis() - this.idleStartTime > (long)(Config.CURRENT.waitingTime * 1000)) {
            this.reduceFPS("Waiting time has been expired.");
        }
    }

    private void reduceFPS(String reason) {
        if (this.fpsMode != 0) {
            if (GuiOpenEventHandler.guiOpened && Config.CURRENT.guiScreenFps != 0 && Config.CURRENT.guiScreenFps <= Config.CURRENT.idleFps) {
                this.mc.func_228018_at_().func_216526_a(Config.CURRENT.guiScreenFps);
                this.fpsMode = 2;
            } else {
                this.mc.func_228018_at_().func_216526_a(Config.CURRENT.idleFps);
                this.fpsMode = 0;
            }
            this.loggingReduceFps(reason);
        }
    }

    private void recoverFPS(String reason) {
        if (this.fpsMode != 1) {
            if (GuiOpenEventHandler.guiOpened && Config.CURRENT.guiScreenFps != 0) {
                this.mc.func_228018_at_().func_216526_a(Config.CURRENT.guiScreenFps);
                this.fpsMode = 2;
            } else {
                this.mc.func_228018_at_().func_216526_a(this.mc.field_71474_y.field_74350_i);
                this.fpsMode = 1;
            }
            this.loggingRecoverFps(reason);
        }
    }

    private void recoverNormalFPS(String reason) {
        if (this.fpsMode != 1) {
            this.mc.func_228018_at_().func_216526_a(this.mc.field_71474_y.field_74350_i);
            this.fpsMode = 1;
            this.loggingRecoverFps(reason);
        }
    }

    private void loggingReduceFps(String reason) {
        if (Config.GLOBAL.debugLog && !this.prevReason.equals(reason)) {
            this.prevReason = reason;
            Logger.debug("Reducing max FPS: ", this.mc.func_228018_at_().func_198082_x(), " (reason: ", reason, ")");
        }
    }

    private void loggingRecoverFps(String reason) {
        if (Config.GLOBAL.debugLog && !this.prevReason.equals(reason)) {
            this.prevReason = reason;
            int framerateLimit = this.mc.func_228018_at_().func_198082_x();
            if (framerateLimit == this.maxFPS) {
                Logger.debug("Recovering max FPS: Unlimited (reason: ", reason, ")");
            } else {
                Logger.debug("Recovering max FPS: ", framerateLimit, " (reason: ", reason, ")");
            }
        }
    }

    public void forceReduceFPS(String reason) {
        this.reduceFPS("[force reduce]" + reason);
    }

    public void forceRecoverFPS(String reason) {
        this.fpsMode = 2;
        this.recoverFPS("[force recover] " + reason);
    }

    private void stopSound() {
        if (!this.stopSound) {
            this.currentGameSettingVolume = this.mc.field_71474_y.func_186711_a(SoundCategory.MASTER);
            float newVolume = this.currentGameSettingVolume * (float)Config.CURRENT.suppressedVolume / 100.0f;
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, newVolume);
            this.stopSound = true;
            Logger.debug("Suppressing master volume: ", (int)(newVolume * 100.0f));
        }
    }

    private void recoverSound() {
        if (this.stopSound) {
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, this.currentGameSettingVolume);
            this.stopSound = false;
            Logger.debug("Recovering master volume: ", (int)(this.currentGameSettingVolume * 100.0f));
        }
    }

    private int getWaitingTimeSecond() {
        return (int)(System.currentTimeMillis() - this.idleStartTime) / 1000;
    }
}

