/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer;

import bre.fpsreducer.WakeupEventHandler;
import bre.fpsreducer.config.CommonConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OverlayEventHandler {
    Minecraft mc = Minecraft.func_71410_x();
    FontRenderer fontRenderer;
    int fpsCounter = 0;
    int curFPS = 0;
    long nextUpdateTime = 0L;
    int marginX;
    int marginY;
    int hudColor;
    int hudReductionColor;
    int hudCurrentColor;

    public OverlayEventHandler() {
        this.fontRenderer = this.mc.field_71466_p;
        this.marginX = CommonConfig.globalConfig.hudMarginX;
        this.marginY = CommonConfig.globalConfig.hudMarginY;
        this.hudColor = CommonConfig.globalConfig.hudColorRed << 16 | CommonConfig.globalConfig.hudColorGreen << 8 | CommonConfig.globalConfig.hudColorBlue;
        this.hudReductionColor = CommonConfig.globalConfig.hudReductionColorRed << 16 | CommonConfig.globalConfig.hudReductionColorGreen << 8 | CommonConfig.globalConfig.hudReductionColorBlue;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        if (CommonConfig.globalConfig.hudLocation == 0) {
            return;
        }
        ++this.fpsCounter;
        if (System.currentTimeMillis() >= this.nextUpdateTime) {
            this.curFPS = this.fpsCounter;
            this.fpsCounter = 0;
            this.nextUpdateTime = System.currentTimeMillis() + 1000L;
        }
        if (!this.mc.field_71474_y.field_74330_P) {
            int posY;
            int posX;
            String fpsStr;
            float scale = (float)CommonConfig.globalConfig.hudScale;
            if (WakeupEventHandler.reduceFPS) {
                fpsStr = CommonConfig.globalConfig.hudReductionPreText + this.curFPS;
                this.hudCurrentColor = this.hudReductionColor;
            } else {
                fpsStr = CommonConfig.globalConfig.hudPreText + this.curFPS;
                this.hudCurrentColor = this.hudColor;
            }
            switch (CommonConfig.globalConfig.hudLocation) {
                case 1: {
                    posX = (int)((float)this.marginX / scale);
                    posY = (int)((float)this.marginY / scale);
                    break;
                }
                case 2: {
                    posX = (int)((float)(event.getResolution().func_78326_a() - this.marginX) / scale) - this.fontRenderer.func_78256_a(fpsStr);
                    posY = (int)((float)this.marginY / scale);
                    break;
                }
                case 3: {
                    posX = (int)((float)(event.getResolution().func_78326_a() - this.marginX) / scale) - this.fontRenderer.func_78256_a(fpsStr);
                    posY = (int)((float)(event.getResolution().func_78328_b() - this.marginY) / scale) - 8;
                    break;
                }
                case 4: {
                    posX = (int)((float)this.marginX / scale);
                    posY = (int)((float)(event.getResolution().func_78328_b() - this.marginY) / scale) - 8;
                    break;
                }
                default: {
                    posX = (int)((float)this.marginX / scale);
                    posY = (int)((float)this.marginY / scale);
                }
            }
            if (scale != 1.0f) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
            }
            this.fontRenderer.func_175063_a(fpsStr, (float)posX, (float)posY, this.hudCurrentColor);
            if (scale != 1.0f) {
                GlStateManager.func_179121_F();
            }
        }
    }
}

