/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer;

import bre.fpsreducer.config.CommonConfig;
import bre.fpsreducer.utils.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class WakeupEventHandler {
    private Minecraft mc = Minecraft.func_71410_x();
    private int maxFPS = (int)GameSettings.Options.FRAMERATE_LIMIT.func_148267_f();
    private long idleStartTime;
    private int currentGameSettingFPS;
    private float currentGameSettingVolume;
    public static boolean reduceFPS = false;
    private boolean stopSound = false;
    private long prevMouseEventNanoSec;
    private long prevKeyEventNanoSec;
    private boolean prevWindowStatus = true;

    public WakeupEventHandler() {
        Logger.debug("FRAMERATE_LIMIT.getValueMax()=", this.maxFPS);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            long currentMouseEventNanoSec;
            block18: {
                if (this.mc.field_71441_e == null) {
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    return;
                }
                if (CommonConfig.currentConfig.reducingInBackground || CommonConfig.currentConfig.suppressSound) {
                    boolean curWindowStatus = Display.isActive();
                    if (!curWindowStatus) {
                        if (curWindowStatus != this.prevWindowStatus) {
                            Logger.debug("Window has been inactive.");
                            this.prevWindowStatus = curWindowStatus;
                            if (CommonConfig.currentConfig.reducingInBackground) {
                                this.reduceFPS();
                            }
                            if (CommonConfig.currentConfig.suppressSound) {
                                this.stopSound();
                            }
                        }
                        if (CommonConfig.currentConfig.reducingInBackground) {
                            return;
                        }
                    } else if (curWindowStatus != this.prevWindowStatus) {
                        Logger.debug("Window has been active.");
                        this.prevKeyEventNanoSec = Keyboard.getEventNanoseconds();
                        this.prevMouseEventNanoSec = Mouse.getEventNanoseconds();
                        this.prevWindowStatus = curWindowStatus;
                        this.recoverSound();
                    }
                }
                if (!CommonConfig.currentConfig.enableFpsReducer) {
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    return;
                }
                long currentKeyEventNanoSec = Keyboard.getEventNanoseconds();
                if (currentKeyEventNanoSec != this.prevKeyEventNanoSec) {
                    this.prevKeyEventNanoSec = currentKeyEventNanoSec;
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    return;
                }
                try {
                    if (this.mc.field_71439_g.field_71158_b.field_187255_c || this.mc.field_71439_g.field_71158_b.field_187256_d || this.mc.field_71439_g.field_71158_b.field_187258_f || this.mc.field_71439_g.field_71158_b.field_187257_e || this.mc.field_71439_g.field_71158_b.field_78901_c || this.mc.field_71439_g.field_71158_b.field_78899_d) {
                        this.resetWaitingTimer();
                        this.recoverFPS();
                        return;
                    }
                }
                catch (NullPointerException e) {
                    if (!CommonConfig.globalConfig.debugLog) break block18;
                    e.printStackTrace();
                }
            }
            if ((currentMouseEventNanoSec = Mouse.getEventNanoseconds()) != this.prevMouseEventNanoSec) {
                this.prevMouseEventNanoSec = currentMouseEventNanoSec;
                this.resetWaitingTimer();
                this.recoverFPS();
                return;
            }
            if (!CommonConfig.currentConfig.ignoreHoldButton) {
                for (int bc = 0; bc < Mouse.getButtonCount(); ++bc) {
                    if (!Mouse.isButtonDown((int)bc)) continue;
                    this.resetWaitingTimer();
                    this.recoverFPS();
                    break;
                }
            }
            this.checkWaitingTimer();
        }
    }

    private void resetWaitingTimer() {
        this.idleStartTime = System.currentTimeMillis();
    }

    private void checkWaitingTimer() {
        if (!reduceFPS && System.currentTimeMillis() - this.idleStartTime > (long)(CommonConfig.currentConfig.waitingTime * 1000)) {
            this.reduceFPS();
        }
    }

    private void reduceFPS() {
        if (!reduceFPS) {
            this.currentGameSettingFPS = this.mc.field_71474_y.field_74350_i;
            this.mc.field_71474_y.field_74350_i = CommonConfig.currentConfig.idleFPS;
            reduceFPS = true;
            Logger.debug("Reducing max FPS: ", this.mc.field_71474_y.field_74350_i);
        }
    }

    private void recoverFPS() {
        if (reduceFPS) {
            this.mc.field_71474_y.field_74350_i = this.currentGameSettingFPS;
            reduceFPS = false;
            if (this.mc.field_71474_y.field_74350_i == this.maxFPS) {
                Logger.debug("Recovering max FPS: Unlimited");
            } else {
                Logger.debug("Recovering max FPS: ", this.mc.field_71474_y.field_74350_i);
            }
        }
    }

    private void stopSound() {
        if (!this.stopSound) {
            this.currentGameSettingVolume = this.mc.field_71474_y.func_186711_a(SoundCategory.MASTER);
            float newVolume = this.currentGameSettingVolume * (float)CommonConfig.currentConfig.suppressedVolume / 100.0f;
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, newVolume);
            this.stopSound = true;
            Logger.debug("Suppressing master volume: ", (int)(newVolume * 100.0f));
        }
    }

    private void recoverSound() {
        if (this.stopSound) {
            this.mc.field_71474_y.func_186712_a(SoundCategory.MASTER, this.currentGameSettingVolume);
            this.stopSound = false;
            Logger.debug("Recovering master volume: ", (int)(this.currentGameSettingVolume * 100.0f));
        }
    }

    private int getWaitingTimeSecond() {
        return (int)(System.currentTimeMillis() - this.idleStartTime) / 1000;
    }
}

