/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager;

import baguchan.hunterillager.HunterEntityRegistry;
import baguchan.hunterillager.client.HunterRenderingRegistry;
import baguchan.hunterillager.event.EntityEventHandler;
import baguchan.hunterillager.item.HunterItems;
import baguchan.hunterillager.structure.FeatureRegister;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="hunterillager")
public class HunterIllagerCore {
    public static final String MODID = "hunterillager";
    public static HunterIllagerCore instance;

    public HunterIllagerCore() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::onItemsRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::onEntityRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, this::onFeatureRegistry);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        ForgeRegistries.BIOMES.getValues().stream().forEach(biome -> {
            biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(FeatureRegister.HUNTER_HOUSE, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
            if (biome.func_201856_r() == Biome.Category.FOREST || biome.func_201856_r() == Biome.Category.PLAINS) {
                biome.func_201865_a(FeatureRegister.HUNTER_HOUSE, (IFeatureConfig)IFeatureConfig.field_202429_e);
            }
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        HunterRenderingRegistry.registerRenderers();
    }

    @SubscribeEvent
    public void onItemsRegistry(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        HunterItems.registerItems((IForgeRegistry<Item>)registry);
    }

    @SubscribeEvent
    public void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        HunterEntityRegistry.registerEntity(registry);
    }

    @SubscribeEvent
    public void onFeatureRegistry(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        FeatureRegister.registerStructure(registry);
    }
}

