/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.client.render;

import baguchan.hunterillager.client.model.HunterIllagerModel;
import baguchan.hunterillager.client.render.layer.CrossArmHeldItemLayer;
import baguchan.hunterillager.entity.HunterIllagerEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HunterIllagerRender<T extends HunterIllagerEntity>
extends MobRenderer<T, HunterIllagerModel<T>> {
    private static final ResourceLocation ILLAGER = new ResourceLocation("hunterillager", "textures/entity/hunter_illager/hunter_illager_plain.png");

    public HunterIllagerRender(EntityRendererManager p_i47477_1_) {
        super(p_i47477_1_, new HunterIllagerModel(), 0.5f);
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a(new CrossArmHeldItemLayer(this));
        this.func_177094_a((LayerRenderer)new HeldItemLayer<T, HunterIllagerModel<T>>((IEntityRenderer)this){

            public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                if (entitylivingbaseIn.func_213398_dR()) {
                    super.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        });
    }

    public ResourceLocation getEntityTexture(HunterIllagerEntity entity) {
        if (entity.getHunterType() != null) {
            return new ResourceLocation(entity.getHunterType().getRegistryName().func_110624_b(), "textures/entity/hunter_illager/hunter_illager_" + entity.getHunterType().getRegistryName().func_110623_a() + ".png");
        }
        return ILLAGER;
    }
}

