/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.init;

import baguchan.hunterillager.huntertype.HunterType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="hunterillager", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HunterTypes {
    public static final HunterType PLAIN = new HunterType(new HunterType.Properties());
    public static final HunterType SNOW = new HunterType(new HunterType.Properties());
    private static ForgeRegistry<HunterType> registry;

    @SubscribeEvent
    public static void onNewRegistry(RegistryEvent.NewRegistry event) {
        registry = (ForgeRegistry)new RegistryBuilder().setType(HunterType.class).setName(new ResourceLocation("hunterillager", "hunter_type")).setDefaultKey(new ResourceLocation("hunterillager", "plain")).create();
    }

    @SubscribeEvent
    public static void onRegisterLores(RegistryEvent.Register<HunterType> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new HunterType[]{(HunterType)PLAIN.setRegistryName("plain"), (HunterType)SNOW.setRegistryName("snow")});
    }

    public static ForgeRegistry<HunterType> getRegistry() {
        if (registry == null) {
            throw new IllegalStateException("Registry not yet initialized");
        }
        return registry;
    }

    public static int getId(HunterType biome) {
        return registry.getID((IForgeRegistryEntry)biome);
    }

    public static HunterType byId(int id) {
        return (HunterType)registry.getValue(id);
    }
}

