/*
 * Decompiled with CFR 0.152.
 */
package de.mybukkit.mycommands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.mybukkit.mycommands.helper.HomePoint;
import de.mybukkit.mycommands.helper.MyStyle;
import de.mybukkit.mycommands.helper.Permission;
import de.mybukkit.mycommands.helper.Teleport;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.TranslationTextComponent;

public class CommandHome {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder literal = Commands.func_197057_a((String)"home");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)literal.requires(source -> Permission.hasperm(source, (LiteralArgumentBuilder<CommandSource>)literal))).executes(context -> CommandHome.execut((CommandContext<CommandSource>)context))).then(Commands.func_197056_a((String)"HomeName", (ArgumentType)StringArgumentType.word()).executes(context -> CommandHome.execute((CommandContext<CommandSource>)context)));
        dispatcher.register(literal);
    }

    public static int execute(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String args = StringArgumentType.getString(context, (String)"HomeName").toString();
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        HomePoint home = HomePoint.getHome(player, args);
        if (home != null) {
            Teleport.warp(player, home.location, true);
            player.func_145747_a(new TranslationTextComponent("commands.home.done", new Object[]{home.homename}).func_150255_a(MyStyle.Green));
        } else {
            player.func_145747_a(new TranslationTextComponent("commands.home.wrong", new Object[0]).func_150255_a(MyStyle.Red));
            if (!HomePoint.gethomePoints(player).equals("")) {
                player.func_145747_a(new TranslationTextComponent("commands.home.list", new Object[]{HomePoint.gethomePoints(player)}).func_150255_a(MyStyle.Aqua));
            } else {
                player.func_145747_a(new TranslationTextComponent("commands.home.failure", new Object[0]).func_150255_a(MyStyle.Red));
            }
        }
        return 1;
    }

    public static int execut(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        HomePoint home = HomePoint.getHome(player, "home");
        if (home != null) {
            Teleport.warp(player, home.location, true);
            player.func_145747_a(new TranslationTextComponent("commands.home.done", new Object[]{home.homename}).func_150255_a(MyStyle.Green));
        } else if (!HomePoint.gethomePoints(player).equals("")) {
            player.func_145747_a(new TranslationTextComponent("commands.home.list", new Object[]{HomePoint.gethomePoints(player)}).func_150255_a(MyStyle.Aqua));
        } else {
            player.func_145747_a(new TranslationTextComponent("commands.home.failure", new Object[0]).func_150255_a(MyStyle.Red));
        }
        return 1;
    }
}

