/*
 * Decompiled with CFR 0.152.
 */
package de.mybukkit.mycommands.helper;

import de.mybukkit.mycommands.MyCommands;
import de.mybukkit.mycommands.helper.Location;
import de.mybukkit.mycommands.helper.SaveFile;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class HomePoint {
    public String UUID;
    public Location location;
    public String homename;
    private static SaveFile homesSaveFile = new SaveFile("homes.txt", MyCommands.getWorldDir().toString() + "/mycommands/homes/");
    public static ArrayList<HomePoint> homes = new ArrayList();

    public HomePoint(ServerPlayerEntity player, String name) {
        this.UUID = player.func_110124_au().toString();
        this.homename = name;
        this.location = new Location((PlayerEntity)player);
    }

    public HomePoint(ServerPlayerEntity player, String name, Location location) {
        this.UUID = player.func_110124_au().toString();
        this.homename = name;
        this.location = location;
    }

    public static HomePoint getHome(ServerPlayerEntity player, String name) {
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.func_110124_au().toString().equals(HomePoint.homes.get((int)i).UUID) || !name.equalsIgnoreCase(HomePoint.homes.get((int)i).homename)) continue;
            return homes.get(i);
        }
        return null;
    }

    public static String gethomePoints(ServerPlayerEntity player) {
        String targets = "";
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.func_110124_au().toString().equals(HomePoint.homes.get((int)i).UUID)) continue;
            targets = targets + ", " + HomePoint.homes.get((int)i).homename;
        }
        if (targets.length() > 2) {
            targets = targets.substring(2);
        }
        return targets;
    }

    public static int getHomecounts(ServerPlayerEntity player) {
        int targets = 1;
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.func_110124_au().toString().equals(HomePoint.homes.get((int)i).UUID)) continue;
            ++targets;
        }
        return targets;
    }

    public static void setHome(ServerPlayerEntity player, String name) {
        Location location = new Location(player.func_180425_c().func_177984_a(), player.field_71093_bK.func_186068_a());
        HomePoint target = new HomePoint(player, name, location);
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.func_110124_au().toString().equals(HomePoint.homes.get((int)i).UUID) || !name.equalsIgnoreCase(HomePoint.homes.get((int)i).homename)) continue;
            homes.remove(i);
        }
        homes.add(target);
        HomePoint.saveAll();
    }

    public static void loadAll() {
        homesSaveFile.load();
        homes.clear();
        for (String info : HomePoint.homesSaveFile.data) {
            homes.add(new HomePoint(info));
        }
    }

    public static void saveAll() {
        homesSaveFile.clear();
        for (HomePoint home : homes) {
            HomePoint.homesSaveFile.data.add(home.toString());
        }
        homesSaveFile.save(false);
    }

    public HomePoint(String info) {
        try {
            this.UUID = info.substring(0, info.indexOf(","));
            this.homename = info.substring(info.indexOf(",") + 1, info.indexOf("("));
            String locationInfo = info.substring(info.indexOf("(") + 1, info.indexOf(")"));
            this.location = new Location(locationInfo);
        }
        catch (Exception e) {
            System.err.println("Exception on attemping to rebuild WarpPoint from String.");
            this.UUID = "Error";
            this.homename = "Error";
            this.location = new Location(0, 0, 0, 0);
        }
    }

    public String toString() {
        if (this.location == null) {
            return "";
        }
        return this.UUID + "," + this.homename + "(" + this.location.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof HomePoint) {
            return this.homename.equals(((HomePoint)o).homename);
        }
        return false;
    }

    public int hashCode() {
        return this.homename.hashCode();
    }

    private HomePoint(ServerPlayerEntity player, String name, Object dummy) {
        this.UUID = player.func_110124_au().toString();
        this.homename = name;
    }

    public static boolean delHomePoint(ServerPlayerEntity player, String name) {
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.func_110124_au().toString().equals(HomePoint.homes.get((int)i).UUID) || !name.equalsIgnoreCase(HomePoint.homes.get((int)i).homename)) continue;
            homes.remove(i);
            HomePoint.saveAll();
            return true;
        }
        return false;
    }
}

