/*
 * Decompiled with CFR 0.152.
 */
package de.mybukkit.mycommands.helper;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;

public class Location {
    public int x;
    public int y;
    public int z;
    public double posX;
    public double posY;
    public double posZ;
    public int dimension;

    public Location(BlockPos pos, int dimension) {
        this.init(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dimension);
    }

    public Location(int x, int y, int z, int dimension) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dimension = dimension;
    }

    public Location(double posX, double posY, double posZ, int dimension) {
        this.init(posX, posY, posZ, dimension);
    }

    public Location(PlayerEntity player) {
        this.init(player);
    }

    public Location(PlayerEntity player, String s) {
        this.init(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_71093_bK.func_186068_a());
    }

    public Location(String info) {
        String[] part = info.split("[,]");
        try {
            this.init(Double.parseDouble(part[0]), Double.parseDouble(part[1]), Double.parseDouble(part[2]), Integer.parseInt(part[3]));
        }
        catch (Exception e) {
            System.err.println("Exception on attemping to rebuild Location from String.");
            this.init(0.0, 0.0, 0.0, 0);
        }
    }

    private void init(PlayerEntity player) {
        this.x = Location.round(player.func_226277_ct_());
        this.y = Location.round(player.func_226278_cu_());
        this.z = Location.round(player.func_226281_cx_());
        this.posX = player.func_226277_ct_();
        this.posY = player.func_226278_cu_();
        this.posZ = player.func_226281_cx_();
        this.dimension = player.field_71093_bK.func_186068_a();
    }

    private void init(double posX, double posY, double posZ, int i) {
        this.x = Location.round(posX);
        this.y = Location.round(posY);
        this.z = Location.round(posZ);
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.dimension = i;
    }

    public void setSpawn(PlayerEntity player) {
        player.func_130014_f_().func_175652_B(player.func_180425_c());
    }

    private static int round(double pos) {
        return (int)Math.floor(pos);
    }

    public String toString() {
        return this.posX + "," + this.posY + "," + this.posZ + "," + this.dimension;
    }

    public boolean equals(Object o) {
        if (o instanceof Location) {
            Location location = (Location)o;
            boolean equal = true;
            equal = equal && this.posX == location.posX;
            equal = equal && this.posY == location.posY;
            equal = equal && this.posZ == location.posZ;
            equal = equal && this.dimension == location.dimension;
            return equal;
        }
        return false;
    }

    public BlockPos getPosfrom() {
        BlockPos pos1 = new BlockPos(this.x, this.y, this.z);
        return pos1;
    }
}

