/*
 * Decompiled with CFR 0.152.
 */
package de.mybukit.mycommands.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.mybukit.mycommands.MyCommands;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private String name;
    private File configFile;
    private JsonObject config;
    private Gson gson;

    public Config(String name, Map<String, Object> properties) {
        this(name);
        if (this.configFile.exists()) {
            this.loadConfig();
            return;
        }
        this.write(properties);
    }

    public Config(String name) {
        this.name = name;
        this.configFile = new File(FabricLoader.getInstance().getConfigDirectory() + "/" + name + ".json");
        this.config = new JsonObject();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public void write(Map<String, Object> properties) {
        try (FileWriter writer = new FileWriter(this.configFile);){
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                if (property.getValue() instanceof JsonElement) {
                    this.config.add(property.getKey(), (JsonElement)property.getValue());
                    continue;
                }
                if (property.getValue() instanceof Integer) {
                    this.config.addProperty(property.getKey(), (Number)((Integer)property.getValue()));
                    continue;
                }
                if (property.getValue() instanceof Boolean) {
                    this.config.addProperty(property.getKey(), Boolean.valueOf((Boolean)property.getValue()));
                    continue;
                }
                if (property.getValue() instanceof String) {
                    this.config.addProperty(property.getKey(), (String)property.getValue());
                    continue;
                }
                MyCommands.LOGGER.error("Unable to parse json config property! File: " + this.name + ".json with Property: " + property.getKey());
            }
            this.saveConfig(writer);
        }
        catch (IOException e) {
            MyCommands.LOGGER.fatal("You done borked something with your config", (Throwable)e);
        }
    }

    public void addInt(String key, int value) {
        this.config.addProperty(key, (Number)value);
    }

    public void addBoolean(String key, boolean value) {
        this.config.addProperty(key, Boolean.valueOf(value));
    }

    public void addString(String key, String value) {
        this.config.addProperty(key, value);
    }

    public void addJsonElement(String key, JsonElement value) {
        this.config.add(key, value);
    }

    public int getInt(String key) {
        return this.config.has(key) ? this.config.get(key).getAsInt() : 0;
    }

    public boolean getBoolean(String key) {
        return this.config.has(key) ? this.config.get(key).getAsBoolean() : false;
    }

    public String getString(String key) {
        return this.config.has(key) ? this.config.get(key).getAsString() : "";
    }

    public JsonElement getJsonElement(String key) {
        return this.config.has(key) ? this.config.get(key) : null;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    private void loadConfig() {
        if (!this.configFile.exists()) {
            MyCommands.LOGGER.error("Unable to load config file " + this.name + ".json, File not found!");
            return;
        }
        try {
            MyCommands.LOGGER.info("Loading config file " + this.name + ".json");
            JsonParser parser = new JsonParser();
            this.config = parser.parse((Reader)new FileReader(this.configFile)).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            MyCommands.LOGGER.fatal("You done borked something with your config", (Throwable)e);
        }
    }

    private void saveConfig(FileWriter writer) {
        MyCommands.LOGGER.info("Creating config file " + this.name + ".json");
        this.gson.toJson((JsonElement)this.config, (Appendable)writer);
    }

    public void saveConfig() {
        if (!this.configFile.exists()) {
            try {
                MyCommands.LOGGER.info("Creating config file " + this.name + ".json");
                this.gson.toJson((JsonElement)this.config, (Appendable)new FileWriter(this.configFile));
            }
            catch (IOException e) {
                MyCommands.LOGGER.fatal("You done borked something with your config", (Throwable)e);
            }
        }
    }

    public void saveNewConfig() {
        if (this.configFile.exists()) {
            try {
                this.configFile.delete();
                MyCommands.LOGGER.info("Creating config file " + this.name + ".json");
                this.gson.toJson((JsonElement)this.config, (Appendable)new FileWriter(this.configFile));
            }
            catch (IOException e) {
                MyCommands.LOGGER.fatal("You done borked something with your config", (Throwable)e);
            }
        }
    }
}

