/*
 * Decompiled with CFR 0.152.
 */
package de.mybukit.mycommands.helper;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Jankson jankson = new Jankson.Builder().build();

    static <T> T loadConfig(Class<T> clazz, File configFile, Supplier<T> fallbackConfigConstructor) {
        try {
            if (!configFile.exists()) {
                T instance = clazz.newInstance();
                ConfigManager.saveConfig(instance, configFile);
                return instance;
            }
            try {
                JsonObject jsonNew;
                JsonObject json = jankson.load(configFile);
                Object result = jankson.fromJson(json, clazz);
                JsonElement jsonElementNew = jankson.toJson(clazz.newInstance());
                if (jsonElementNew instanceof JsonObject && json.getDelta(jsonNew = (JsonObject)jsonElementNew).size() >= 0) {
                    ConfigManager.saveConfig(result, configFile);
                }
                return (T)result;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load config File {}: {}", (Object)configFile.getName(), (Object)e);
            }
        }
        catch (SyntaxError syntaxError) {
            LOGGER.warn("Failed to load config File {}: {}", (Object)configFile.getName(), (Object)syntaxError);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.warn("Failed to create new config file for {}: {}", (Object)configFile.getName(), (Object)e);
        }
        LOGGER.warn("Creating placeholder config for {}...", (Object)configFile.getName());
        return fallbackConfigConstructor.get();
    }

    public static void saveConfig(Object object, File configFile) {
        JsonElement json = jankson.toJson(object);
        String result = json.toJson(true, true);
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(configFile, false);
            out.write(result.getBytes());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write to config file {}: {}", (Object)configFile.getName(), (Object)e);
        }
    }
}

