/*
 * Decompiled with CFR 0.152.
 */
package de.mybukit.mycommands.helper;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.mybukit.mycommands.MyCommands;
import de.mybukit.mycommands.helper.DimensionHelper;
import de.mybukit.mycommands.helper.Location;
import de.mybukit.mycommands.helper.PlayerData;
import de.mybukit.mycommands.helper.SaveFile;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class HomePoint {
    public String UUID;
    public Location location;
    public String homename;
    public class_3218 world;
    public static SaveFile homesSaveFile = new SaveFile("homes.txt", MyCommands.getWorldDir().toString() + "/mycommands/homes/");
    public static ArrayList<HomePoint> homes = new ArrayList();

    public HomePoint(class_3222 player, String name) {
        this.UUID = player.method_5667().toString();
        this.homename = name;
        this.location = new Location(player);
    }

    public HomePoint(class_3222 player, String name, Location location) {
        this.UUID = player.method_5667().toString();
        this.homename = name;
        this.location = location;
    }

    public static HomePoint getHome(class_3222 player, String name) {
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.method_5667().toString().equals(HomePoint.homes.get((int)i).UUID) || !name.equalsIgnoreCase(HomePoint.homes.get((int)i).homename)) continue;
            return homes.get(i);
        }
        return null;
    }

    public static List<String> getHomeNames(class_2168 source) {
        class_3222 player = null;
        try {
            player = source.method_9207();
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        ArrayList<String> honames = new ArrayList<String>();
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.method_5667().toString().equals(HomePoint.homes.get((int)i).UUID)) continue;
            honames.add(HomePoint.homes.get((int)i).homename);
        }
        return honames;
    }

    public static String gethomePoints(class_3222 player) {
        String targets = "";
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.method_5667().toString().equals(HomePoint.homes.get((int)i).UUID)) continue;
            targets = targets + ", " + HomePoint.homes.get((int)i).homename;
        }
        if (targets.length() > 2) {
            targets = targets.substring(2);
        }
        return targets;
    }

    public static PlayerData HomeToData(PlayerData pla) {
        class_3222 player = pla.getPlayer();
        for (int i = 0; i < homes.size(); ++i) {
            if (player.method_5667().toString().equals(HomePoint.homes.get((int)i).UUID)) {
                if (pla.homeMap.containsKey(HomePoint.homes.get((int)i).homename)) {
                    return null;
                }
            } else {
                return null;
            }
            pla.homeMap.put(HomePoint.homes.get((int)i).homename, new AbstractMap.SimpleEntry<class_243, class_2960>(new class_243(HomePoint.homes.get((int)i).location.posX, HomePoint.homes.get((int)i).location.posY, HomePoint.homes.get((int)i).location.posZ), DimensionHelper.getid(HomePoint.homes.get((int)i).location.dimension)));
            homes.remove(i);
        }
        HomePoint.saveAll();
        pla.saveconf();
        return pla;
    }

    public static int getHomecounts(class_3222 player) {
        int targets = 1;
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.method_5667().toString().equals(HomePoint.homes.get((int)i).UUID)) continue;
            ++targets;
        }
        return targets;
    }

    public static void setHome(class_3222 player, String name) {
        Location location = new Location(player);
        HomePoint target = new HomePoint(player, name, location);
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.method_5667().toString().equals(HomePoint.homes.get((int)i).UUID) || !name.equalsIgnoreCase(HomePoint.homes.get((int)i).homename)) continue;
            homes.remove(i);
        }
        homes.add(target);
        HomePoint.saveAll();
    }

    public static void loadAll() {
        if (homesSaveFile.exists()) {
            homesSaveFile.load();
            homes.clear();
            for (String info : HomePoint.homesSaveFile.data) {
                homes.add(new HomePoint(info));
            }
        }
    }

    public static void saveAll() {
        if (homesSaveFile.exists()) {
            homesSaveFile.clear();
            for (HomePoint home : homes) {
                HomePoint.homesSaveFile.data.add(home.toString());
            }
            homesSaveFile.save(false);
        }
    }

    public HomePoint(String info) {
        try {
            this.UUID = info.substring(0, info.indexOf(","));
            this.homename = info.substring(info.indexOf(",") + 1, info.indexOf("("));
            String locationInfo = info.substring(info.indexOf("(") + 1, info.indexOf(")"));
            this.location = new Location(locationInfo);
        }
        catch (Exception e) {
            System.err.println("Exception on attemping to rebuild WarpPoint from String.");
            this.UUID = "Error";
            this.homename = "Error";
            this.location = new Location(0, 0, 0, DimensionHelper.getdim("overworld"));
        }
    }

    public String toString() {
        if (this.location == null) {
            return "";
        }
        return this.UUID + "," + this.homename + "(" + this.location.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof HomePoint) {
            return this.homename.equals(((HomePoint)o).homename);
        }
        return false;
    }

    public int hashCode() {
        return this.homename.hashCode();
    }

    private HomePoint(class_3222 player, String name, Object dummy) {
        this.UUID = player.method_5667().toString();
        this.homename = name;
    }

    public static boolean delHomePoint(class_3222 player, String name) {
        for (int i = 0; i < homes.size(); ++i) {
            if (!player.method_5667().toString().equals(HomePoint.homes.get((int)i).UUID) || !name.equalsIgnoreCase(HomePoint.homes.get((int)i).homename)) continue;
            homes.remove(i);
            HomePoint.saveAll();
            return true;
        }
        return false;
    }
}

