/*
 * Decompiled with CFR 0.152.
 */
package de.mybukit.mycommands.helper;

import de.mybukit.mycommands.MyCommands;
import de.mybukit.mycommands.helper.DimensionHelper;
import de.mybukit.mycommands.helper.Location;
import de.mybukit.mycommands.helper.SaveFile;
import de.mybukit.mycommands.helper.WarpData;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class WarpPoint {
    public String name;
    public Location location;
    public static SaveFile warpPointsSaveFile = new SaveFile("warpPoints.txt", MyCommands.getWorldDir().toString() + "/mycommands/warps/");
    public static ArrayList<WarpPoint> warpPoints = new ArrayList();

    public WarpPoint(class_3222 player, String name) {
        this.name = name;
        this.location = new Location(player);
    }

    public WarpPoint(String name, Location location) {
        this.name = name;
        this.location = location;
    }

    public static WarpPoint getWarpPoint(String name) {
        WarpPoint target = new WarpPoint(name, null);
        if (warpPoints.contains(target)) {
            return warpPoints.get(warpPoints.indexOf(target));
        }
        return null;
    }

    public static WarpData WarpToData(WarpData pla) {
        if (warpPoints != null) {
            for (int i = 0; i < warpPoints.size(); ++i) {
                if (pla.warps.containsKey(WarpPoint.warpPoints.get((int)i).name)) continue;
                pla.warps.put(WarpPoint.warpPoints.get((int)i).name, new AbstractMap.SimpleEntry<class_243, class_2960>(new class_243(WarpPoint.warpPoints.get((int)i).location.posX, WarpPoint.warpPoints.get((int)i).location.posY, WarpPoint.warpPoints.get((int)i).location.posZ), DimensionHelper.getid(WarpPoint.warpPoints.get((int)i).location.dimension)));
            }
            pla.converted = true;
            pla.save();
            return pla;
        }
        return null;
    }

    public static String getWarpPoints() {
        String targets = "";
        for (WarpPoint wp : warpPoints) {
            targets = targets + ", " + wp.name;
        }
        if (targets.length() > 2) {
            targets = targets.substring(2);
        }
        return targets;
    }

    public static List<String> getWarpNames() {
        ArrayList<String> wpnames = new ArrayList<String>();
        for (WarpPoint wp : warpPoints) {
            if (wp == null) {
                return null;
            }
            wpnames.add(wp.name);
        }
        return wpnames;
    }

    public static void setWarpPoint(class_3222 player, String name) {
        Location location = new Location(player);
        WarpPoint warpPoint = new WarpPoint(name, location);
        if (warpPoints.contains(warpPoint)) {
            warpPoints.remove(warpPoint);
        }
        warpPoints.add(warpPoint);
        WarpPoint.saveAll();
    }

    public static boolean delWarpPoint(String name) {
        WarpPoint warpPoint = new WarpPoint(name, null);
        if (warpPoints.contains(warpPoint)) {
            warpPoints.remove(warpPoint);
            WarpPoint.saveAll();
            return true;
        }
        return false;
    }

    public static void loadAll() {
        if (warpPointsSaveFile.exists()) {
            warpPointsSaveFile.load();
            warpPoints.clear();
            for (String info : WarpPoint.warpPointsSaveFile.data) {
                warpPoints.add(new WarpPoint(info));
            }
        }
    }

    public static void saveAll() {
        if (warpPointsSaveFile.exists()) {
            warpPointsSaveFile.clear();
            for (WarpPoint warpPoint : warpPoints) {
                WarpPoint.warpPointsSaveFile.data.add(warpPoint.toString());
            }
            warpPointsSaveFile.save(false);
        }
    }

    public WarpPoint(String info) {
        try {
            this.name = info.substring(0, info.indexOf("("));
            String locationInfo = info.substring(info.indexOf("(") + 1, info.indexOf(")"));
            this.location = new Location(locationInfo);
        }
        catch (Exception e) {
            System.err.println("Exception on attemping to rebuild WarpPoint from String.");
            this.name = "Error";
            this.location = new Location(0, 0, 0, DimensionHelper.getdim("overworld"));
        }
    }

    public String toString() {
        if (this.location == null) {
            return "";
        }
        return this.name + "(" + this.location.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof WarpPoint) {
            return this.name.equals(((WarpPoint)o).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private WarpPoint(String name, Object dummy) {
        this.name = name;
    }
}

