/*
 * Decompiled with CFR 0.152.
 */
package de.mybukit.mycommands.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.mybukit.mycommands.MyCommands;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.Level;

public class configneu {
    protected String fileName;
    protected File configFile;
    protected JsonObject config;

    public configneu(String name) {
        this.fileName = name + ".json";
        this.configFile = new File(this.getFileLocation() + this.fileName);
        this.loadConfig();
    }

    public configneu() {
        this("mycommands");
    }

    public void generateConfigFile() {
        MyCommands.log("Creating new config file " + this.fileName);
        InputStream inputStream = MyCommands.class.getResourceAsStream("/assets/mycommands/config/defaults.json");
        JsonElement json = (JsonElement)new Gson().fromJson((Reader)new InputStreamReader(inputStream), JsonElement.class);
        try {
            FileWriter writer = new FileWriter(this.configFile);
            new GsonBuilder().setPrettyPrinting().create().toJson(json, (Appendable)writer);
            writer.close();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public void loadConfig() {
        MyCommands.log("Loading config file " + this.fileName);
        if (!this.configFile.exists()) {
            MyCommands.log("Config file not found, creating...");
            this.generateConfigFile();
        }
        try {
            this.config = new JsonParser().parse((Reader)new FileReader(this.configFile)).getAsJsonObject();
        }
        catch (FileNotFoundException exception) {
            MyCommands.log(Level.FATAL, "Config file couldn't be read or created.", exception);
        }
        MyCommands.log("Config loaded successfully.");
    }

    public String getFileLocation() {
        return FabricLoader.getInstance().getConfigDirectory() + "/" + "mycommands" + "/";
    }

    public String get(String key, String defaultValue) {
        return this.config.has(key) ? this.config.get(key).getAsString() : defaultValue;
    }

    public boolean get(String key, boolean defaultValue) {
        return this.config.has(key) ? this.config.get(key).getAsBoolean() : defaultValue;
    }

    public int get(String key, int defaultValue) {
        return this.config.has(key) ? this.config.get(key).getAsInt() : defaultValue;
    }

    public JsonObject get(String key, JsonObject defaultValue) {
        return this.config.has(key) ? this.config.get(key).getAsJsonObject() : defaultValue;
    }

    public JsonObject get(String key) {
        return this.get(key, new JsonObject());
    }
}

