/*
 * Decompiled with CFR 0.152.
 */
package de.mybukkit.mycommands.helper;

import com.mojang.authlib.GameProfile;
import de.mybukkit.mycommands.helper.Players;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.network.play.server.S2DPacketOpenWindow;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;

public class Player {
    protected Players player;
    private EntityPlayerMP ePlayer;

    public Player(EntityPlayer player) {
        if (player != null) {
            this.ePlayer = (EntityPlayerMP)player;
        }
    }

    public Player(UUID uuid) {
        if (uuid != null) {
            // empty if block
        }
    }

    public Player() {
    }

    public Player(ICommandSender sender) {
        this((EntityPlayer)sender);
    }

    public String getPlayerName() {
        return this.ePlayer.getDisplayName();
    }

    public void kick(String reason) {
        this.ePlayer.field_71135_a.func_147360_c(reason);
    }

    public void sendPacket(Packet packet) {
        this.ePlayer.field_71135_a.func_147359_a(packet);
    }

    public WorldSettings.GameType getGameMode() {
        return this.ePlayer.field_71134_c.func_73081_b();
    }

    public void setGameMode(WorldSettings.GameType type) {
        this.ePlayer.field_71134_c.func_73076_a(type);
        this.sendPacket((Packet)new S2BPacketChangeGameState(3, (float)type.func_77148_a()));
    }

    public void exec(String command) {
        MinecraftServer.func_71276_C().func_71187_D().func_71556_a((ICommandSender)this.ePlayer, command);
    }

    public double getPosX() {
        return this.ePlayer.field_70165_t;
    }

    public double getPosY() {
        return this.ePlayer.field_70163_u;
    }

    public double getPosZ() {
        return this.ePlayer.field_70161_v;
    }

    public boolean isDead() {
        return this.ePlayer.field_70128_L;
    }

    public EntityPlayerMP getPlayer() {
        return this.ePlayer;
    }

    public ItemStack getStackFromInventory(int slot) {
        return this.ePlayer.field_71071_by.field_70462_a[slot];
    }

    public boolean setItemStackInSlot(ItemStack item) {
        return this.ePlayer.field_71071_by.func_70441_a(item.func_77946_l());
    }

    public int getEmptyInventorySlot() {
        for (int i = 0; i < this.ePlayer.field_71071_by.field_70462_a.length; ++i) {
            if (this.ePlayer.field_71071_by.field_70462_a[i] != null) continue;
            return i;
        }
        return -1;
    }

    public void giveItem(ItemStack item) {
        EntityItem i = this.ePlayer.func_71019_a(item, false);
        if (i == null) {
            this.sendErrorMessage("EnityItem is null");
        }
        i.field_145804_b = 0;
        i.func_145797_a(this.ePlayer.func_70005_c_());
    }

    public void suicide() {
        this.ePlayer.func_70106_y();
    }

    public World getWorld() {
        return this.ePlayer.field_70170_p;
    }

    public GameProfile getProfile() {
        return this.ePlayer != null ? this.ePlayer.func_146103_bH() : MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(this.getPlayerName());
    }

    public void setHealth(float val) {
        this.ePlayer.func_70606_j(val);
    }

    public String getNickname() {
        return this.player.getNickName() != null || this.player.getNickName() != "" ? this.player.getNickName() : this.ePlayer.func_70005_c_();
    }

    public void enableNickname() {
        this.player.enableNickname(!this.isNicknameEnabled());
    }

    public boolean isInventoryFull() {
        for (int i = 0; i < this.ePlayer.field_71071_by.field_70462_a.length; ++i) {
            if (this.ePlayer.field_71071_by.field_70462_a[i] != null) continue;
            return false;
        }
        return true;
    }

    public boolean isNicknameEnabled() {
        return this.player.isNicknameEnabled();
    }

    public void refreshDisplayName() {
        this.ePlayer.refreshDisplayName();
    }

    public void updateTime() {
        this.player.setLastUpdate(new Date().getTime());
    }

    public String getGroup() {
        return null;
    }

    public void sendMessage(String message, Object ... args) {
        this.sendMessage(String.format(message, args));
    }

    public void sendMessage(List<String> lines) {
        for (String line : lines) {
            this.sendMessage(line);
        }
    }

    public void sendMessage(String msg) {
        this.ePlayer.func_145747_a((IChatComponent)new ChatComponentText(msg));
    }

    public boolean sendMessageTo(Player target, String msg) {
        if (target == null) {
            return false;
        }
        this.sendMessage("[me -> %s] %s", this.getPlayerName(), msg);
        target.sendMessage("[%s -> me] %s", this.getPlayerName(), msg);
        return true;
    }

    public void spawn() {
    }

    public InetSocketAddress getAddress() {
        if (this.ePlayer.func_70613_aW()) {
            return null;
        }
        SocketAddress addr = this.ePlayer.field_71135_a.field_147371_a.func_74430_c();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    public boolean isFlying() {
        return this.ePlayer.field_71075_bZ.field_75100_b;
    }

    public boolean canFly() {
        return this.ePlayer.field_71075_bZ.field_75101_c;
    }

    public void fly(float speed) {
        boolean bl = this.ePlayer.field_71075_bZ.field_75101_c = !this.isFlying();
        if (!this.ePlayer.field_71075_bZ.field_75101_c) {
            this.ePlayer.field_71075_bZ.field_75100_b = false;
        }
        this.ePlayer.func_71016_p();
    }

    public boolean isInvincible() {
        return this.ePlayer.field_71075_bZ.field_75102_a;
    }

    public boolean isVanished() {
        return this.ePlayer.func_82150_aj();
    }

    public void vanish() {
        this.ePlayer.func_82142_c(!this.isVanished());
    }

    public void god() {
        this.ePlayer.field_71075_bZ.field_75102_a = !this.isInvincible();
        this.ePlayer.func_71016_p();
    }

    public void setFire(int i) {
        this.ePlayer.func_70015_d(i);
    }

    public void removePotionEffect(int id) {
        this.ePlayer.func_82170_o(id);
    }

    public void addPotionEffect(PotionEffect potionEffect) {
        this.ePlayer.func_70690_d(potionEffect);
    }

    public UUID getUniqueID() {
        return this.ePlayer.func_110124_au();
    }

    public void sendErrorMessage(String message, Object ... args) {
        this.sendMessage(EnumChatFormatting.RED + message, args);
    }

    public void sendSuccessMessage(String message, Object ... args) {
        this.sendMessage(EnumChatFormatting.GREEN + message, args);
    }

    public void sendErrorMessage(String message) {
        this.sendMessage(EnumChatFormatting.RED + message);
    }

    public void sendSuccessMessage(String message) {
        this.sendMessage(EnumChatFormatting.GREEN + message);
    }

    public int getBalance() {
        return this.player.getBalance();
    }

    public void setHunger(int value) {
        this.ePlayer.func_71024_bL().func_75122_a(value, 5.0f);
    }

    public float getFoodLevel() {
        return this.ePlayer.func_71024_bL().func_75116_a();
    }

    public float getSaturationLevel() {
        return this.ePlayer.func_71024_bL().func_75115_e();
    }

    public int getXP() {
        return this.ePlayer.field_71068_ca;
    }

    public void setXP(int value) {
        this.ePlayer.func_82242_a(value);
    }

    public void openWorkbench() {
        this.ePlayer.func_71117_bO();
        this.sendPacket((Packet)new S2DPacketOpenWindow(this.ePlayer.field_71139_cq, 1, "Workbench", 9, true));
        this.ePlayer.field_71070_bA = new ContainerWorkbench(this.ePlayer.field_71071_by, this.ePlayer.field_70170_p, 0, 0, 0){

            public void func_75130_a(IInventory par1IInventory) {
                this.field_75160_f.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.field_75162_e, ((Player)Player.this).ePlayer.field_70170_p));
            }

            public void func_75134_a(EntityPlayer par1EntityPlayer) {
                super.func_75134_a(par1EntityPlayer);
                if (!((Player)Player.this).ePlayer.field_70170_p.field_72995_K) {
                    for (int var2 = 0; var2 < 9; ++var2) {
                        ItemStack var3 = this.field_75162_e.func_70304_b(var2);
                        if (var3 == null) continue;
                        par1EntityPlayer.func_71019_a(var3, true);
                    }
                }
            }

            public boolean func_75145_c(EntityPlayer par1EntityPlayer) {
                return true;
            }
        };
        this.ePlayer.field_71070_bA.field_75152_c = this.ePlayer.field_71139_cq;
        this.ePlayer.field_71070_bA.func_75132_a((ICrafting)this.ePlayer);
    }

    public void openEnderchest() {
        if (this.ePlayer.field_71070_bA != this.ePlayer.field_71069_bz) {
            this.ePlayer.func_71053_j();
        }
        this.ePlayer.func_71117_bO();
        InventoryEnderChest chest = this.ePlayer.func_71005_bN();
        this.sendPacket((Packet)new S2DPacketOpenWindow(this.ePlayer.field_71139_cq, 0, chest.func_145825_b(), chest.func_70302_i_(), true));
        this.ePlayer.field_71070_bA = new ContainerChest((IInventory)this.ePlayer.field_71071_by, (IInventory)chest);
        this.ePlayer.field_71070_bA.field_75152_c = this.ePlayer.field_71139_cq;
        this.ePlayer.field_71070_bA.func_75132_a((ICrafting)this.ePlayer);
    }

    public ItemStack getEquipedItem() {
        return this.ePlayer.func_70694_bm();
    }

    public void setEquipedItemDurability(int value) {
        this.ePlayer.func_70694_bm().func_77964_b(value);
    }

    public void clearInventory() {
        for (int i = 0; i < 36; ++i) {
            this.ePlayer.field_71071_by.func_70299_a(i, null);
        }
    }
}

