#version 120			// T r i l i t o n s  S h a d e r s // 
const float	ambientOcclusionLevel = 1.0;		//level of Minecraft smooth lighting,

//disabling is done by adding "//" to the beginning of a line.
#define ALBEDO_MULTIPLIER 0.8 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.9 1.0 1.1 1.2 1.4 1.6 1.7 1.8 1.9 2.0] //texture brightness multiplier, reduce it when using bright ressourcepacks (summerfields for example)
//***************************ADJUSTABLE VARIABLES//***************************
//***************************ADJUSTABLE VARIABLES//***************************
//***************************ADJUSTABLE VARIABLES//***************************

//***************************SHADOWS***************************//
const int 		shadowMapResolution 	= 1024;			//[500 800 2048 4096]shadowmap resolution
const float 	shadowDistance 			= 130.0f;		//[90 100 130 140 150 160 170 180 190 200 300 400 500 600 700 800 900]draw distance of shadows

#define SHADOW_DARKNESS 3.0	// [ 3.5 2.5 2.0 1.5 1.0 0.9 0.7 0.5 0.6 0.4 0.3 0.2 0.1] //shadow darkness levels, lower values mean darker shadows, see .vsh for colors

#define SHADOW_FILTER						//smooth shadows
	#define SHADOW_FILTER_AMOUNT 1.0		//[0.5 1.5 2.0 2.5]
	//#define LQ_SHADOW_FILTER				//Low shadow filter
	#define HQ_SHADOW_FILTER				//High shadow filter

//#define VOLUMETRIC_LIGHT // Disabled by default

#define VL_QUALITY  1.0 //[0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 5.0 6.0 7.0 8.0 9.0 10.0 15.0 20.0]     // Quality of the Volumetric Light. 1.0 is default, 10.0 recommended for quality, 20.0 best quality you can get. But eats a lot of FPS

#define VL_DISTANCE 32.0 //[16.0 32.0 64.0 128.0 256.0 512.0]  // The draw distance of Volumetric Light


//***************************LIGHTNING***************************//
	#define DYNAMIC_HANDLIGHT
		#define HANDLIGHT_AMOUNT 1.0		//[0.5 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

	#define SUNLIGHTAMOUNT 2.5				//[0.5 1.0 1.2 1.3 1.4 1.5 2.0 3.0 3.1 3.2 3.4 3.5 4.0 4.5 5.5 6.0] //change sunlight strength //default is 2.5

	//Torch Color//
	#define TORCH_COLOR 0.8,0.375,0.08		//RGB - Red, Green, Blue
	#define TORCH_COLOR2 0.8,0.370,0.08		//RGB - Red, Green, Blue

	#define TORCH_ATTEN 1.5					//[0.5 0.6 0.7 0.8 0.9 1.1 1.2 1.3 1.4 1.6 1.7 1.8 1.9 2.0]//how much the torch light will be attenuated (decrease if you want the torches to cover a bigger area) // 1.5 is default 
	#define TORCH_INTENSITY 0.60 			//[0.10 0.15 0.20 0.25 0.30 0.40 0.50 0.55 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.0] //How strong a torch will shine 

	//Minecraft lightmap (used for sky)
	#define ATTENUATION 1.0					//[0.5 0.5 0.7 0.8 0.9 1.0 1.1 1.2 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
	#define MIN_LIGHT 0.011				//[0.005 0.022 0.033 0.044 0.066 0.077 0.088 0.099] //This is indoor light //0.011 is default 

//***************************VISUALS***************************//
	//#define GODRAYS
	const float density = 1.0;
	const int NUM_SAMPLES = 20;			//[5 6 7 8 9 10 15 25 30 35 40 45 50] //increase this for better quality at the cost of performance 
	const float grnoise = 1.0;		//amount of noise

	//#define CELSHADING			//This creates lines around textures
		#define BORDER 1.0			//[0.5 0.6 0.7 0.8 0.9 1.1 1.2 1.3 1.4 1.5]

	//#define CLOUDS
	#define Clouds					//The shader clouds

	//#define SSAO						//Screen Space Ambient Occlusion //disabled by default 
	const int nbdir = 4;	           //qualtiy
	const float sampledir = 4;	      //quality
	const float ssaorad = 1;	 //strength

	#define WATER_REFRACT				//surface of the water
		#define REFRACT_MULT 6.0

	//#define WATER_CAUSTIC				
		#define CAUSTIC_STRENGHT 0.8
		#define CAUSTIC_SIZE 2.0
		#define CAUSTIC_SPEED 0.3
		
		
		
	#define NEW_WATER_CAUSTIC				//These are the lights above and below the water 

	const float	sunPathRotation	= -40.0;		//determines sun/moon inclination

//***************************END OF ADJUSTABLE VARIABLES***************************//
//***************************END OF ADJUSTABLE VARIABLES***************************//
//***************************END OF ADJUSTABLE VARIABLES***************************//

const float 	wetnessHalflife 		= 70.0f;
const float 	drynessHalflife 		= 70.0f;
const int 		RGBA16					= 0;
const int 		gdepthFormat 			= RGBA16;
const bool 		shadowHardwareFiltering = false;

const float 	shadowIntervalSize 		= 4.0f;

const int 		noiseTextureResolution  = 1024;

#define SHADOW_MAP_BIAS 0.8		//Dont touch this unless you know what you are doing

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight_color;
varying vec3 ambient_color;
varying vec3 ambient_color2;
varying vec3 moonlight;
varying vec3 sunlight;

varying vec4 lightS;

varying float handItemLight;
varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D gcolor;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2D shadowtex0;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux3;
uniform sampler2D noisetex;
uniform sampler2D shadowtex1;
uniform sampler2D shadowcolor;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferPreviousModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
uniform mat4 gbufferModelView;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;

uniform float isBiomeDesert;
uniform float isBiomeRiver;

uniform float near; 
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform float centerDepthSmooth;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform int fogMode;

float land = texture2D(gaux1, texcoord.st).b;

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0f, 25000.0f) - 23000.0f) / 1000.0f) + (1.0f - (clamp(timefract, 0.0f, 2000.0f)/2000.0f));
	float TimeNoon     = ((clamp(timefract, 0.0f, 2000.0f)) / 2000.0f) - ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f);
	float TimeSunset   = ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f) - ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f);
	float TimeMidnight = ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f) - ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f);

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float landx = land;

float cdist(vec2 coord){
    return distance(coord,vec2(0.5))*2.0;
}

vec3 convertScreenSpaceToWorldSpace(vec2 co, float depth) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, depth) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
    return screenSpace;
}

float edepth(vec2 coord) {
	return texture2D(depthtex1,coord).z;
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

vec3 aux = texture2D(gaux1, texcoord.st).rgb;
vec3 sunPos = sunPosition;

vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;

vec3 fragpos = vec3(texcoord.st, texture2D(depthtex1, texcoord.st).r);

float pixeldepth = texture2D(depthtex1,texcoord.xy).x;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float shadowexit = 0.0;

float handlight = handItemLight*0.5*HANDLIGHT_AMOUNT;
const float speed = 2.5;
float light_jitter = 1.0-sin(frameTimeCounter*1.4*speed+cos(frameTimeCounter*1.9*speed))*0.05;			//little light variations
float torch_lightmap = pow(aux.b*light_jitter,TORCH_ATTEN)*TORCH_INTENSITY*5;
float torch_lightmap2 = pow(aux.b,TORCH_ATTEN*6)*TORCH_INTENSITY*50;

float getCloudNoiseTex(vec4 fragpos, float x, float y, float z) {

    vec4 wrldpos = ((gbufferModelViewInverse) * fragpos / far * 256*(1.0-rainx*0.9));

    float common2 = (wrldpos.y + length(wrldpos.y))/100, t = frameTimeCounter;
    float f = 0.2, frq = 1.0, ap = 0.5;

    vec2 wind = vec2(1+t, 8+t)/(y*15.0), camPos = (wrldpos.xz*z/wrldpos.y);
    vec2 pos = -1+0.01*(camPos+wind/y); pos /= x/y;

    f += texture2D(noisetex, pos*frq- frameTimeCounter/32000).x*ap; frq *= 5.0; ap *= 0.05*(1.0-rainx*-10.0);
    f += texture2D(noisetex, pos*frq).x*ap; frq *= 2.1; ap *= 1.5;
    f += texture2D(noisetex, pos*frq).x*ap; frq *= 2.4; ap *= 0.5;
    f += texture2D(noisetex, pos*frq).x*ap; frq *= 2.9; ap *= 0.5;


    f /= 0.58; float tex = f, b = 0.9, c = tex - (b+0.175);
    if(c <= 0) c = 0; tex = ((1.0 - pow(b, c))*common2);

    float getCloudNoiseTex = tex;

    return getCloudNoiseTex;
}

float sky_lightmap = pow(aux.r,ATTENUATION) * 0.5;
	float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,normalize(upPosition)),0.0));

	vec3 specular = texture2D(gaux3,texcoord.xy).rgb;
	float specmap = specular.r*(1.0-specular.b)+specular.g*iswet+specular.b*0.85;

//poisson distribution for shadow sampling

const vec2 circle_offsets[30] = vec2[30]  (  vec2( 0.0000, 0.2500 ),
         vec2( -0.2165, 0.1250 ),
         vec2( -0.2165, -0.1250 ),
         vec2( -0.0000, -0.2500 ),
         vec2( 0.2165, -0.1250 ),
         vec2( 0.2165, 0.1250 ),
         vec2( 0.0000, 0.5000 ),
         vec2( -0.2500, 0.4330 ),
         vec2( -0.4330, 0.2500 ),
         vec2( -0.5000, 0.0000 ),
         vec2( -0.4330, -0.2500 ),
         vec2( -0.2500, -0.4330 ),
         vec2( -0.0000, -0.5000 ),
         vec2( 0.2500, -0.4330 ),
         vec2( 0.4330, -0.2500 ),
         vec2( 0.5000, -0.0000 ),
         vec2( 0.4330, 0.2500 ),
         vec2( 0.2500, 0.4330 ),
         vec2( 0.0000, 0.7500 ),
         vec2( -0.2565, 0.7048 ),
         vec2( -0.4821, 0.5745 ),
         vec2( -0.6495, 0.3750 ),
         vec2( -0.7386, 0.1302 ),
         vec2( -0.7386, -0.1302 ),
         vec2( -0.6495, -0.3750 ),
         vec2( -0.4821, -0.5745 ),
         vec2( -0.2565, -0.7048 ),
         vec2( -0.0000, -0.7500 ),
         vec2( 0.2565, -0.7048 ),
         vec2( 0.4821, -0.5745 ));

const vec2 cross_offset[36] = vec2[36]  (  vec2( 0.0, 0.1 ),
		vec2( 0.0, 0.15 ),
        vec2( 0.0, 0.2 ),
		vec2( 0.0, 0.25 ),
        vec2( 0.0, 0.3 ),
		vec2( 0.0, 0.35 ),
		vec2( 0.0, 0.4 ),
		vec2( 0.0, 0.45 ),
		vec2( 0.0, 0.5 ),
		vec2( -0.1, 0.0 ),
		vec2( -0.15, 0.0 ),
		vec2( -0.2, 0.0 ),
		vec2( -0.25, 0.0 ),
		vec2( -0.3, 0.0 ),
		vec2( -0.35, 0.0 ),
		vec2( -0.4, 0.0 ),
		vec2( -0.45, 0.0 ),
		vec2( -0.5, 0.0 ),
		vec2( 0.0, -0.1 ),
		vec2( 0.0, -0.15 ),
		vec2( 0.0, -0.2 ),
		vec2( 0.0, -0.25 ),
		vec2( 0.0, -0.3 ),
		vec2( 0.0, -0.35 ),
		vec2( 0.0, -0.4 ),
		vec2( 0.0, -0.45 ),
		vec2( 0.0, -0.5 ),
		vec2( 0.1, 0.0 ),
		vec2( 0.15, 0.0 ),
		vec2( 0.2, 0.0 ),
		vec2( 0.25, 0.0 ),
		vec2( 0.3, 0.0 ),
		vec2( 0.35, 0.0 ),
		vec2( 0.4, 0.0 ),
		vec2( 0.45, 0.0 ),
		vec2( 0.5, 0.0 ));

float ctorspec(vec3 ppos, vec3 lvector, vec3 normal,float rough,float fpow) {
    //half vector
	vec3 pos = -normalize(ppos);
    vec3 cHalf = normalize(lvector + pos);

    // beckman's distribution function D
    float normalDotHalf = dot(normal, cHalf);
    float normalDotHalf2 = normalDotHalf * normalDotHalf;

    float roughness2 = rough;
    float exponent = -(1.0 - normalDotHalf2) / (normalDotHalf2 * roughness2);
    float e = 2.71828182846;
    float D = pow(e, exponent) / (roughness2 * normalDotHalf2 * normalDotHalf2);

    // fresnel term F
	float normalDotEye = dot(normal, pos);
    float F = pow(1.0 - normalDotEye, fpow);

    // self shadowing term G
    float normalDotLight = dot(normal, lvector);
    float X = 2.0 * normalDotHalf / dot(pos, cHalf);
    float G = min(1.0, min(X * normalDotLight, X * normalDotEye));
    float pi = 3.1415927;
    float CookTorrance = (D*F*G)/(pi*normalDotEye);

    return max(CookTorrance/pi,0.0);
}

float diffuseorennayar(vec3 pos, vec3 lvector, vec3 normal, float spec, float roughness) {

    vec3 v=normalize(pos);
	vec3 l=normalize(lvector);
	vec3 n=normalize(normal);

	float vdotn=dot(v,n);
	float ldotn=dot(l,n);
	float cos_theta_r=vdotn;
	float cos_theta_i=ldotn;
	float cos_phi_diff=dot(normalize(v-n*vdotn),normalize(l-n*ldotn));
	float cos_alpha=min(cos_theta_i,cos_theta_r); // alpha=max(theta_i,theta_r);
	float cos_beta=max(cos_theta_i,cos_theta_r); // beta=min(theta_i,theta_r)

	float r2=roughness*roughness;
	float a=1.0-0.5*r2/(r2+0.33);
	float b_term;

	if(cos_phi_diff>=0.0) {
		float b=0.45*r2/(r2+0.09);
		b_term=b*sqrt((1.0-cos_alpha*cos_alpha)*(1.0-cos_beta*cos_beta))/cos_beta*cos_phi_diff;
		b_term = b*sin(cos_alpha)*tan(cos_beta)*cos_phi_diff;
	}
	else b_term= 0.0;

	return clamp(cos_theta_i*(a+b_term),0.0,1.0);
}

#ifdef CELSHADING
vec3 celshade(vec3 clrr) {
	//edge detect
	float d = edepth(texcoord.xy);
	float dtresh = 1/(far-near)/5000.0;
	vec4 dc = vec4(d,d,d,d);
	vec4 sa;
	vec4 sb;
	sa.x = edepth(texcoord.xy + vec2(-pw,-ph)*BORDER);
	sa.y = edepth(texcoord.xy + vec2(pw,-ph)*BORDER);
	sa.z = edepth(texcoord.xy + vec2(-pw,0.0)*BORDER);
	sa.w = edepth(texcoord.xy + vec2(0.0,ph)*BORDER);

	//opposite side samples
	sb.x = edepth(texcoord.xy + vec2(pw,ph)*BORDER);
	sb.y = edepth(texcoord.xy + vec2(-pw,ph)*BORDER);
	sb.z = edepth(texcoord.xy + vec2(pw,0.0)*BORDER);
	sb.w = edepth(texcoord.xy + vec2(0.0,-ph)*BORDER);

	vec4 dd = abs(2.0* dc - sa - sb) - dtresh;
	dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));

	float e = clamp(dot(dd,vec4(0.5f,0.5f,0.5f,0.5f)),0.0,1.0);
	return clrr*e;
}
#endif

float waterH(vec2 posxz) {

vec2 movement = vec2(-abs(frameTimeCounter/2000.-0.5),-abs(frameTimeCounter/1000.-0.5));
vec2 movement2 = vec2(abs(frameTimeCounter/2000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement3 = vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/2000.-0.5));
vec2 movement4 = vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/2000.-0.5));

vec2 coord = (posxz/600)+(movement);
vec2 coord1 = (posxz/599.9)+(movement2);
vec2 coord2 = (posxz/599.8)+(movement);
vec2 coord3 = (posxz/599.7)+(movement2);

float noise = texture2D(noisetex,fract(coord.xy/2.0)).x/8;
noise += texture2D(noisetex,fract(coord1.xy)).x/16.0;
noise += texture2D(noisetex,fract(coord2.xy*2.0)).x/8;
noise += texture2D(noisetex,fract(coord3.xy*2.0)).x/8;

return noise;
}

float getnoise(vec2 pos) {
return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));

}

#ifdef WATER_CAUSTIC

vec3 waterCaustic(vec3 fposition,vec3 color) {

vec2 movement = vec2(-abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));
vec2 movement2 = vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement3 = vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));
vec2 movement4 = vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));

vec3 underwaterpos = vec3(texcoord.st, texture2D(depthtex1, texcoord.st).r);
underwaterpos = nvec3(gbufferProjectionInverse * nvec4(underwaterpos * 2.0 - 1.0));
vec4 worldpositionuw = gbufferModelViewInverse * vec4(underwaterpos,1.0);
vec3 wpos = (worldpositionuw.xyz + cameraPosition.xyz);

vec2 coord = (wpos.xz/(270*CAUSTIC_SIZE))+(movement*(4*CAUSTIC_SPEED));
vec2 coord1 = (wpos.xz/(269.9*CAUSTIC_SIZE))+(movement2*(4*CAUSTIC_SPEED));
vec2 coord2 = (wpos.xz/(269.8*CAUSTIC_SIZE))+(movement3*(4*CAUSTIC_SPEED));
vec2 coord3 = (wpos.xz/(269.7*CAUSTIC_SIZE))+(movement4*(4*CAUSTIC_SPEED));

float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;
noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord1.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord2.xy)).x/2.0;
noise += texture2D(noisetex,fract(coord3.xy)).x/2.0;


float causticstrength = max((noise-1.2),0.0);
float wca = (0.1/CAUSTIC_STRENGHT);
float caustic = (1.0 - (pow(wca,causticstrength)));
vec3 caustic_color = ivec3(ambient_color)/255.0/2.2;	//coloring caustics
vec3 wc = mix(color,caustic_color,caustic);

return wc;
}

#endif



float genDirtyLens (vec2 texcoord) {
	vec2 lens = vec2(0.0, aspectRatio);
	float noise = texture2D(noisetex,(texcoord+lens)*4).x;
	noise += texture2D(noisetex,(texcoord+lens)*8).x/4;
	noise += texture2D(noisetex,(texcoord+lens)*8).x/4;
	noise += texture2D(noisetex,(texcoord+lens)*8).x/4;
	noise += texture2D(noisetex,(texcoord+lens)*8).x/4;
	noise += texture2D(noisetex,(texcoord+lens)*8).x/4;
	noise += texture2D(noisetex,(texcoord+lens)*8).x/4;
	float lensstrength = max(noise-1.8,0.0);
	float wlens = 0.1;
	float LensD = (1.0 - (pow(wlens,lensstrength)));
	LensD *= clamp((eyeBrightness.y-220)/15.0,0.0,1.0);
	return LensD;
	}

	vec2 wind[4] = vec2[4](vec2(abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5))+vec2(0.5),
					vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5)),
					vec2(-abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5)),
					vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5)));

float subSurfaceScattering(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos)),0.0),N)*(N+1)/6.28;

}
float subSurfaceScattering2(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos))*0.5+0.5,0.0),N)*(N+1)/6.28;

}

#ifdef Clouds
vec3 drawCloud(vec3 fposition,vec3 color, float mult, float transition_fading) {
   float Size = 1.0;
   vec3 sVector = normalize(fposition);
   float cosT = max(dot(normalize(sVector),upVec),0.0);
   vec3 tpos = vec3(gbufferModelViewInverse * vec4(sVector,0.0));
   vec3 wvec = normalize(tpos);
   vec3 wVector = normalize(tpos);

   vec3 cloudCol = pow(sunlight_color * 2.4,vec3(3.4))*(TimeSunrise+TimeSunset);
    cloudCol += (vec3(1.0) * 2.0)*(TimeNoon);
    cloudCol += (sunlight_color * 30.0)*(TimeMidnight); //this changes cloud colour for night
    cloudCol += pow(sunlight_color * 1.5,vec3(3.0)) * (1-transition_fading);

   float totalcloud = 0.0;

   float height = (700.0)/(wVector.y);
   vec2 wind = vec2(abs(frameTimeCounter/20000.-0.5),abs(frameTimeCounter/20000.-0.5))+vec2(0.5);

   vec3 intersection;
   float density;
   float d1;

   int Steps = 5;
   float weight;

   for (int i = 0; i < Steps; i++) {
    intersection = wVector * (height - i * 150 * Size / Steps);    //curved cloud plane

    vec2 coord1 = (intersection.xz+cameraPosition.xz*2.5)/200000;
    coord1 += (wind);
    vec2 coord = (coord1/Size);

    float noise = texture2D(noisetex,coord - wind * 0.5).x;
    noise += texture2D(noisetex,coord*3.5).x/3.5;
    noise += texture2D(noisetex,coord*6.125).x/6.125;
    noise += texture2D(noisetex,coord*12.25).x/12.25;
    noise /= clamp(texture2D(noisetex,coord / 4.1).x * 1.25,0.0,1.0);
    noise *= (pow(noise, pow(2.0 * pow(1.0,0.5),0.5)));
    noise /= 0.13;

    float cl = max(noise-0.7,0.0);
    cl = max(cl,0.)*0.05 * (1.0 - rainx * 0.9);
    density = max(1-cl*2.5,0.)*max(1-cl*2.5,0.) / 11.0 / 3.0;
    density *= 2.0;

    totalcloud += density;
    if (totalcloud > (1.0 - 1.0 / Steps + 0.1)) break;
    weight ++;

   }

   cloudCol = mix(cloudCol*pow(1-density, 2.0),vec3(cloudCol*0.125),pow(density, 2.0)) * 2.0;

   cloudCol += pow(sunlight_color * mix(3.0,2.4,TimeSunset + TimeSunrise),vec3(mix(3.4 - (1.0 * (1.0 - transition_fading)),1.0,TimeNoon)))* (50*(pow(1-density, 100.0 * (1-(1-transition_fading * 0.5))))) * mix(1.0,0.1,1.0 - transition_fading) * 1.5 * (1-(TimeMidnight * transition_fading)) * (1-rainx);
   cloudCol += pow(sunlight_color * mix(3.0,2.4,TimeSunset + TimeSunrise),vec3(mix(3.4 - (1.0 * (1.0 - transition_fading)),1.0,TimeNoon))) * 25 * (1- TimeMidnight);
   cloudCol += moonlight * (50*(pow(1-density, 14.0))) * 70 * transition_fading * (1-rainx);

   cloudCol *= (1- (0.5 * TimeMidnight * transition_fading));
   cloudCol *= (1+ TimeNoon);


   totalcloud = min(totalcloud / weight,1.0);
   totalcloud = mix(totalcloud,(0.0),pow(1-density, 100.0));
   return mix(color.rgb,cloudCol * mult/50/0.1 * 0.1 * 0.1 * (1.0 - rainx * 0.8),clamp(totalcloud*50,0.0,1.0) * pow(cosT,1.0)); //These are cloud colours
 }
#endif

float distx(float dist){
 return (far * (dist - near)) / (dist * (far - near));
}

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}


vec4 getShadowSpace(float shadowdepth, vec2 texcoord){

 vec4 fragpos = nvec4(convertScreenSpaceToWorldSpace(texcoord.st,shadowdepth));

 vec4 wpos = vec4(0.0);
  wpos = gbufferModelViewInverse * fragpos;

	wpos = shadowModelView * wpos;
	wpos = shadowProjection * wpos;
	wpos /= wpos.w;

	float distb = sqrt(wpos.x * wpos.x + wpos.y * wpos.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	wpos.xy *= 1.0f / distortFactor;
	wpos = wpos * 0.5f + 0.5f;

 return wpos;

}



float dynamicExposure = mix(1.0,0.0,(pow(eyeBrightnessSmooth.y / 240.0f, 3.0f)));

#ifdef VOLUMETRIC_LIGHT

 // derived from: http://devlog-martinsh.blogspot.nl/2011/03/glsl-8x8-bayer-matrix-dithering.html
 float find_closest(vec2 pos)
 {
  const int ditherPattern[64] = int[64](
   0, 32, 8, 40, 2, 34, 10, 42,
   48, 16, 56, 24, 50, 18, 58, 26,
   12, 44, 4, 36, 14, 46, 6, 38,
   60, 28, 52, 20, 62, 30, 54, 22,
   3, 35, 11, 43, 1, 33, 9, 41,
   51, 19, 59, 27, 49, 17, 57, 25,
   15, 47, 7, 39, 13, 45, 5, 37,
   63, 31, 55, 23, 61, 29, 53, 21);

  vec2 positon = floor(mod(vec2(texcoord.s * viewWidth,texcoord.t * viewHeight), 8.0f));

  int dither = ditherPattern[int(positon.x) + int(positon.y) * 8];

  return float(dither) / 64.0f;
 }

 float getVolumetricRays() {

  ///////////////////////Setting up functions///////////////////////

   vec3 rSD = vec3(0.0);
    rSD.x = 0.0;
    rSD.y = 6.0 / VL_QUALITY;
    rSD.z = find_closest(texcoord.st);


   rSD.z *= rSD.y;

   float maxDist = (VL_DISTANCE);
   float minDist = (0.01);
    minDist += rSD.z;

   float weight = (maxDist / rSD.y);

   vec2 diffthresh = vec2(0.0005, -0.001); // Fixes light leakage from walls

   vec4 worldposition;

   for (minDist; minDist < maxDist; ) {

   ///////////////////////MAKING VL NOT GO THROUGH WALLS///////////////////////

    if (getDepth(pixeldepth) < minDist){
     break;
    }

   ///////////////////////Getting worldpositon///////////////////////

    worldposition = getShadowSpace(distx(minDist),texcoord.st);

   ///////////////////////Projecting shadowmaps on a linear depth plane///////////////////////

    if ( texture2D( shadowtex0, worldposition.xy ).z  >  worldposition.z){
    rSD.x += 1.0;
}

    minDist = minDist + rSD.y;
  }

  ///////////////////////Returning the program///////////////////////

   rSD.x /= weight;
   rSD.x *= 0.15 * maxDist / 32;

   rSD.x = mix(rSD.x, clamp(rSD.x, 0.0, 0.1), dynamicExposure);

   return rSD.x;
 }
#else

float getVolumetricRays(){
 return 0.0;
}

#endif

/* DRAWBUFFERS:01 */

void main() {

	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));

	float comp = 1.0-near/far/far;			//distance above that are considered as sky

	#ifndef DYNAMIC_HANDLIGHT
	handlight = 0.9;
	#endif
	vec2 newtc = texcoord.xy;
	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13500.0)/300.0,0.0,1.0) + clamp((time-22500.0)/300.0,0.0,1.0)-clamp((time-23400.0)/300.0,0.0,1.0));	//fading between sun/moon shadows
	float night = clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-23000.0)/200.0,0.0,1.0);
	float day = clamp((time-22000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/200.0,0.0,1.0);

	float shadowexit = float(aux.g > 0.1 && aux.g < 0.3);
	float land	= float(pixeldepth < comp);
	float iswater = float(aux.g > 0.04 && aux.g < 0.07);
	float translucent = float(aux.g > 0.3 && aux.g < 0.5);
	float hand = float(aux.g > 0.75 && aux.g < 0.85);
	float issky = -land;
	float emissive = float(aux.g > 0.58 && aux.g < 0.62);
	float particle = float(aux.g > 0.68 && aux.g < 0.72);

	if (hand > 0.9) {
	handlight = (handItemLight*10.0*HANDLIGHT_AMOUNT);
	}

	float roughness = mix(1.0-(pow(specular.g,2.0))+specular.b+iswet*specular.g*0.5,0.05,iswater);
	if (specular.r+specular.g+specular.b < 1.0/255.0 && iswater < 0.09) roughness = 0.0;

	float fresnel_pow = pow(1.0-(specular.b+specular.g)/2.0,1.25+iswet*0.75)*3.5;


	vec3 color = texture2D(gcolor, texcoord.st).rgb;
	color = pow(color,vec3(2.2))*(1.0+translucent*0.0)*(ALBEDO_MULTIPLIER*(1-TimeMidnight*0.5));

	float NdotL = dot(lightVector,normal);
	float NdotUp = dot(normal,upVec);

	vec4 fragposition = gbufferProjectionInverse * vec4(newtc.s * 2.0f - 1.0f, newtc.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	if(isEyeInWater == 1) fragposition.xy *= gbufferProjection[1][1] * tan(atan(1.0 / gbufferProjection[1][1]) * 0.85);
	

	float shading = 1.0f;
	vec3 radiance = vec3(0.5);

	float dist = length(fragposition.xyz);

	float shadingsharp = 0.0f;
	float shadingwater = 0.0f;
	vec3 shadingcolour = vec3(0.0f);
	float shadingdifference = 0.0f;


	vec4 worldposition = vec4(0.0);
	vec4 worldpositionraw = vec4(0.0);

	worldposition = gbufferModelViewInverse * fragposition;

     float horizon = max(worldposition.y - texcoord.y,30.0);
	float horizon2 = 1.0;


	float limit = max(pow(max(1.0 - horizon/600.0, 0.01), 4.5), 0.0)*transition_fading*(1.0-TimeSunrise)*(1.0-TimeSunset); // This changes sky colour 
	float limit_ss_sr = max(pow(max(1.0 - horizon/900.0, 0.01), 8.0), 0.0)*transition_fading*(1.0-TimeNoon)*(1.0-TimeMidnight);
	float limit_ss_sr2 = max(pow(max(1.0 - horizon/900.0, 0.01), 8.0), 0.0)*transition_fading*(1.0-TimeNoon)*(1.0-TimeMidnight);
	float limit_ss_sr3 = (max(pow(max(1.0 - horizon/150.0, 0.01), 8.0), 0.0)*transition_fading*(1.0-TimeNoon)*(1.0-TimeMidnight))*1.1;
	float limit_ss_sr3_fix = (max(pow(max(1.0 - horizon2/20.0, 0.01), 8.0), 0.0))*1.1;

	float SkyGradient = max(pow(max(1.0 - horizon/2500.0, 0.01), 8.0), 0.0)*(1.0-limit_ss_sr2);
    SkyGradient = clamp(SkyGradient, 0.25, 1.0);

	vec3 limitcss = vec3(128,1,1)/30;
	vec3 limitcss2 = vec3(0,127,1)/100;
	vec3 limitcss3 = (vec3(4,58,84)/100);
	vec3 limitcss3_fix = vec3(limitcss+limitcss2+limitcss3);

	vec3 skycolor = mix(vec3(ambient_color+1.0), moonlight, TimeMidnight);

	vec3 skycolor_grad = vec3(0.5,0.5,0.1)/4;

	vec3 limit3_fix = vec3(limitcss3+limitcss2+limitcss3);

	vec3 limitcsr = vec3(128,1,1)/30;
	vec3 limitcsr2 = vec3(0,127,1)/100;
	vec3 limitcsr3 = (vec3(4,58,84)/100);

	vec3 limitcn = vec3(moonlight) * 10.0;
	vec3 limitcnoon = vec3(189,209,244)/244;

	vec3 horizoncnoon = vec3(36,76,172)/172;


	if (land < 0.1) {
		color.rgb *= 1.5;
		color.rgb = mix(color.rgb, skycolor * 0.1, limit); // Skygradient horizon 

		//fake atmospheric scattering/////////////////////////////////////////////////////////////////////////////////

		if (limit_ss_sr3_fix < 0.99) {

		color.rgb += (((limitcsr)*limit_ss_sr*(1-limit_ss_sr3_fix))*TimeSunrise*transition_fading)*(1-limit_ss_sr3)*(1*+limit_ss_sr2);
		color.rgb -= ((((skycolor)*0.2)*limit_ss_sr*(1-limit_ss_sr3_fix))*TimeSunrise*transition_fading)*(1-limit_ss_sr3)*(1*+limit_ss_sr2);

		color.rgb += (((limitcss)*limit_ss_sr*(1-limit_ss_sr3_fix))*TimeSunset*transition_fading)*(1-limit_ss_sr3)*(1*+limit_ss_sr2);
		color.rgb -= ((((skycolor)*0.2)*limit_ss_sr*(1-limit_ss_sr3_fix))*TimeSunset*transition_fading)*(1-limit_ss_sr3)*(1*+limit_ss_sr2);

		color.rgb += (((limitcsr2)*limit_ss_sr2*(1-limit_ss_sr3_fix))*TimeSunrise*transition_fading)*(1-limit_ss_sr3);

		color.rgb += (((limitcss2)*limit_ss_sr2*(1-limit_ss_sr3_fix))*TimeSunset*transition_fading)*(1-limit_ss_sr3);

		}


		color.rgb += (((limitcss3_fix)*limit_ss_sr3)*TimeSunrise*TimeSunset*transition_fading)*(1-limit_ss_sr2)*(1-limit_ss_sr)*(1-limit_ss_sr3_fix);


		//////////////////////////////////////////////////////////////////////////////////////////////////////////////

		color.rgb -= ((skycolor)*0.175)*limit*TimeMidnight*transition_fading;
		color.rgb += ((limitcn*0.2)*limit)*TimeMidnight*transition_fading;

		color.rgb += ((limitcnoon*3.0)*limit)*TimeNoon*transition_fading;
		color.rgb -= ((skycolor)*limit)*TimeNoon*transition_fading;

		color.rgb += (vec3(limitcn)/10)*TimeMidnight*transition_fading;


		color.r = color.r*0.6 + ((color.g + color.b)/2.0)*-0.05;
		color.g = color.g*0.6 + ((color.r + color.b)/2.0)*-0.05;
		color.b = color.b*0.6 + ((color.r + color.g)/2.0)*-0.05;

		color.b = color.b*0.6 + ((color.r + color.g)/2.0)*0.2;


		color.rgb = color.rgb*1.5;
		}


	/*
	vec2 uv = ( gl_FragCoord.xy / 500.0);

	float t =  1.0 / horizon / (sin( uv.y + sin(uv.y*0.0) + sin(uv.y*0.0) * uv.y ) * 0.025)*transition_fading;
	vec3 Skycolorgrad = (vec3(ambient_color)*0.5);
	t = clamp(t, 0.25, 1.0);

	if (land < 0.9){
	color = vec3(Skycolorgrad)*t;
	color = clamp(color,0.0,1.0)*t;
	}
	*/

float deltaPos = 0.1;

vec4 fragposition2 = gbufferProjectionInverse * vec4(newtc.s * 2.0f - 1.0f, newtc.t * 2.0f - 1.0f, 2.0f * texture2D(depthtex0, newtc.st).x - 1.0f, 1.0f);
fragposition2 /= fragposition2.w;

vec4 worldposition2 = gbufferModelViewInverse * fragposition2;

vec3 posxz = worldposition2.xyz + cameraPosition.xyz;

float h0 = 0.0;
float h1 = 0.0;
float h2 = 0.0;
float h3 = 0.0;
float h4 = 0.0;

#ifdef WATER_REFRACT

	if (iswater > 0.9) {
	h0 = waterH(posxz.xz);
	h1 = waterH(posxz.xz + vec2(deltaPos,0.0));
	h2 = waterH(posxz.xz + vec2(-deltaPos,0.0));
	h3 = waterH(posxz.xz + vec2(0.0,deltaPos));
	h4 = waterH(posxz.xz + vec2(0.0,-deltaPos));

	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;


	float refMult = (REFRACT_MULT/1000)-dot(normal,normalize(fragposition).xyz)*0.0035;

	vec3 refract = normalize(vec3(xDelta,yDelta,1.0-pow(abs(xDelta+yDelta),2.0)));
	vec4 rA = texture2D(gcolor, texcoord.st + refract.xy*refMult);
	rA.rgb = pow(rA.rgb,vec3(2.2));
	vec4 rB = texture2D(gcolor, texcoord.st);
	rB.rgb = pow(rB.rgb,vec3(2.2));
	float mask = texture2D(gaux1, texcoord.st + refract.xy*refMult).g;
	mask =  float(mask > 0.04 && mask < 0.07);
	color.rgb = rA.rgb*mask + rB.rgb*(1-mask);
}

#endif

	vec3 Ucolor = normalize(vec3(0.10,0.26,0.30))*0.28; // This is the underwater colour or fogwater colour 

	vec3 uPos = vec3(.0);

	float uDepth = texture2D(depthtex0,texcoord.xy).x;
	uPos = nvec3(gbufferProjectionInverse * vec4(vec3(texcoord.xy,uDepth) * 2.0 - 1.0, 1.0));

	vec3 uVec = fragposition.xyz-uPos;
	float UNdotUP = abs(dot(normalize(uVec),normalize(upPosition)));
	float depth = length(uVec)*UNdotUP;

	if (land > 0.9) {

	float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
	float yDistanceSquared  = worldposition.y * worldposition.y;

	worldpositionraw = worldposition;

	worldposition = shadowModelView * worldposition;
	float comparedepth = -worldposition.z;
	worldposition = shadowProjection * worldposition;
	worldposition /= worldposition.w;

	float distb = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	worldposition.xy *= 1.0f / distortFactor;
	worldposition = worldposition * 0.5f + 0.5f;
	int vpsize = 0;
	float diffthresh = 1.0*distortFactor+iswater+translucent;
	float isshadow = 0.0;
	float ssample;

	float distof = clamp(1.0-dist/shadowDistance ,0.0,1.0);
	float distof2 = clamp(1.0-dist/(shadowDistance *0.75),0.0,1.0);
	float shadow_fade = clamp(distof*12.0,0.0,1.0);
	float sss_fade = pow(distof2,0.2);
	float step = 1.0/shadowMapResolution*(2.0+rainStrength*10.0);

		if (dist < shadowDistance) {
			if (shadowexit > 0.1) {
				shading = 1.0;
			}

			else {


		if (particle > 0.9) shading = sky_lightmap;

			#ifdef SHADOW_FILTER
				#ifdef LQ_SHADOW_FILTER
				for(int i = 0; i < 30; i++){
                    shadingsharp += (clamp(comparedepth - (0.05 + (texture2D(shadowtex0, worldposition.st + circle_offsets[i]*step*SHADOW_FILTER_AMOUNT).z) * (256.0)), 0.0, diffthresh)/(diffthresh));
          shadingwater += (clamp(comparedepth - (0.05 + (texture2D(shadowtex1, worldposition.st + circle_offsets[i]*step*SHADOW_FILTER_AMOUNT).z) * (256.0)), 0.0, diffthresh)/(diffthresh));
          shadingcolour += clamp(texture2D(shadowcolor, worldposition.st + circle_offsets[i]*step*SHADOW_FILTER_AMOUNT).rgb, vec3(0.0f), vec3(1.0f));
                }
				shadingsharp /= 25.0;
				shadingwater /= 25.0;
				shadingcolour /= 25.0;
				#endif

				#ifdef HQ_SHADOW_FILTER
				for(int i = 0; i < 30; i++){
                    shadingsharp += (clamp(comparedepth - (0.05 + (texture2D(shadowtex0, worldposition.st + circle_offsets[i]*step*SHADOW_FILTER_AMOUNT).z) * (256.0)), 0.0, diffthresh)/(diffthresh));
          shadingwater += (clamp(comparedepth - (0.05 + (texture2D(shadowtex1, worldposition.st + circle_offsets[i]*step*SHADOW_FILTER_AMOUNT).z) * (256.0)), 0.0, diffthresh)/(diffthresh));
          shadingcolour += clamp(texture2D(shadowcolor, worldposition.st + circle_offsets[i]*step*SHADOW_FILTER_AMOUNT).rgb, vec3(0.0f), vec3(1.0f));
                }
				shadingsharp /= 20.0;
				shadingwater /= 20.0;
				shadingcolour /= 20.0;

				#endif

				shading = 1.0-shadingwater;
				isshadow = 1.0;
				shadingdifference = max(0.0, sign((1.0 - shadingwater) - (1.0 - shadingsharp)));
				shadingcolour = shadingcolour * 1.5 + dot(shadingcolour, vec3(0.2125, 0.7154, 0.0721)) * (1.0 - 1.8);


			#endif

			#ifndef SHADOW_FILTER
				vec2 smcoord = floor(worldposition.st*shadowMapResolution+0.5)/shadowMapResolution;
			shading += shadow2D(shadowtex1, Position.worldSpacePosition.xyz + vec3(vec2(0.0, 1.0) * 0.00075, 0.0)).r;
	shading += shadow2D(shadowtex1, Position.worldSpacePosition.xyz - vec3(vec2(0.0, 1.0) * 0.00075, 0.0)).r;
    shading += shadow2D(shadowtex1, Position.worldSpacePosition.xyz + vec3(vec2(1.0, 0.0) * 0.00075, 0.0)).r;
	shading += shadow2D(shadowtex1, Position.worldSpacePosition.xyz - vec3(vec2(1.0, 0.0)  * 0.00075, 0.0)).r;

	shading /= 4;
}
			#endif
			}




		}

	float ao = 1.0;

#ifdef SSAO

if (land > 0.9 && iswater < 0.9 && hand < 0.9) {
	vec3 norm = texture2D(gnormal,texcoord.xy).rgb*2.0-1.0;
	vec3 projpos = convertScreenSpaceToWorldSpace(texcoord.xy,pixeldepth);

	float progress = 0.0;
	ao = 0.0;

	float projrad = clamp(distance(convertCameraSpaceToScreenSpace(projpos + vec3(ssaorad,ssaorad,ssaorad)).xy,texcoord.xy),7.5*pw,60.0*pw);

		for (int i = 1; i < nbdir; i++) {
			for (int j = 1; j < sampledir; j++) {
				vec2 samplecoord = vec2(cos(progress),sin(progress))*(j/sampledir)*projrad + texcoord.xy;
				float sample = texture2D(depthtex1,samplecoord).x;
				vec3 sprojpos = convertScreenSpaceToWorldSpace(samplecoord,sample);
				float angle = pow(min(1.0-dot(norm,normalize(sprojpos-projpos)),1.0),2.0);
				float dist = pow(min(abs(ld(sample)-ld(pixeldepth)),0.015)/0.015,2.0);
				float temp = min(dist+angle,1.0);
				ao += pow(temp,5.0);
				//progress += (1.0-temp)/nbdir*3.14;
			}
			progress = i*1.256;
		}

		ao /= (nbdir-1)*(sampledir-1);

	}
#endif

	float sss_transparency = mix(0,1,translucent);		//subsurface scattering amount
	float sunlight_direct = 1.0;
	float direct = 1.0;
	float sss = 0.0;
	vec3 npos = normalize(fragposition.xyz);
	float NdotL = 1.0;

		NdotL = dot(normal, lightVector);
		direct = NdotL;

		sunlight_direct = diffuseorennayar(fragposition.xyz, lightVector, normal, specmap, roughness+0.01);
		sunlight_direct = mix(sunlight_direct,0.5*SUNLIGHTAMOUNT,translucent*min(sss_fade+0.4,1.0));

		sss += pow(max(dot(npos, lightVector),0.0),10.0)*sss_transparency*clamp(-NdotL,0.0,1.0)*translucent*4.0;



	sss = mix(0.0,sss,sss_fade);
	shading = clamp(shading,0.0,1.0);


	float handLight = (handlight*1.0)/pow(length(fragposition.xyz),1.0)*diffuseorennayar(fragposition.xyz, -fragposition.xyz, normal, specmap, roughness+0.01);
	float handSpec = ctorspec(fragposition.xyz,-fragposition.xyz,normalize(normal),roughness+0.01,fresnel_pow)*handLight*1.0;

	float sky_absorbance = mix(mix(1.0,exp(-depth/4.5),iswater),1.0,isEyeInWater);

	vec3 causticcol = vec3(0.0);
	#ifdef NEW_WATER_CAUSTIC
	vec3 underwaterpos = vec3(texcoord.st, texture2D(depthtex1, texcoord.st).r);
	underwaterpos = nvec3(gbufferProjectionInverse * nvec4(underwaterpos * 2.0 - 1.0));
	vec4 worldpositionuw = gbufferModelViewInverse * vec4(underwaterpos,1.0);
	vec3 uwpos = (worldpositionuw.xyz + cameraPosition.xyz);
	
	float caustic = 0;
	float csmask = mix(iswater,1-iswater,isEyeInWater);
	float cstorchlm = max(1-sky_lightmap*1.2*mix(1-night*0.5,0.5,rainStrength),0.0)*(max(torch_lightmap-0.1,0.0)+pow(handLight*0.9,2.2)*4)*10;
	cstorchlm *= csmask;
	csmask *= max(shading,sky_lightmap)*(1-night*0.95)*(1-rainStrength);

	h0 = waterH(uwpos.xz) * 1.30;
	h1 = waterH(uwpos.xz + vec2(deltaPos,0.0));
	h2 = waterH(uwpos.xz + vec2(-deltaPos,0.0));
	h3 = waterH(uwpos.xz + vec2(0.0,deltaPos));
	h4 = waterH(uwpos.xz + vec2(0.0,-deltaPos));
	caustic = max(2-(abs(h2-h1)+abs(h4-h3))*6.0-pow(abs(h0-0.5),3.0)*8.0,0.0);
	if (isEyeInWater > 0.5)
	caustic = max(pow(caustic,0.5),0.0)*0.6;
	else
	caustic = max(pow(caustic,1.0),0.0)*0.83; // surface 
	causticcol = caustic*((1+color)*csmask+vec3(TORCH_COLOR)*cstorchlm) * 2.0 * (sunlight_color * 0.2); //This changes caustics accordingly to sunlightamount 
	#endif

	//Apply different lightmaps to image

		vec3 torchcolor = vec3(TORCH_COLOR)*TORCH_INTENSITY;
		vec3 torchcolor2 = vec3(TORCH_COLOR2)*TORCH_INTENSITY;

		vec3 lightCol = mix(sunlight_color, moonlight * 3.0, TimeMidnight);

		vec3 Sunlight_lightmap = mix(vec3(1.0), shadingcolour, shadingdifference) * lightCol*mix(max(sky_lightmap-rainStrength*0.85,0.0),shading*(1.0-rainStrength*0.85),shadow_fade)*SUNLIGHTAMOUNT *sunlight_direct*transition_fading;

		float visibility = (dot(normal,normalize(upPosition))*0.05+0.95)*sky_lightmap;
		float bouncefactor = (dot(normal,normalize(upPosition))*0.5+0.5)*sky_lightmap;

		vec3 reflected_sunlight = SHADOW_DARKNESS*sky_lightmap*lightCol*max(-NdotL*0.6+1.4,0.0)*SUNLIGHTAMOUNT*radiance*ao*0.3;

		float handlightDistance = 13.0f;
		float handlightDistance2 = 5.0f;

		vec3 sky_light = SHADOW_DARKNESS*pow(ambient_color,vec3(15.2))*ao * mix(radiance*0.5,vec3(0.5),bouncefactor) * visibility * vec3(skycolor)*8.0; // this changes ground light when raining 

		vec3 Torchlight_lightmap = (torch_lightmap+handlight*2.0*pow(max(handlightDistance-length(fragposition.xyz),0.0)/handlightDistance,4.0)*max(dot(-fragposition.xyz,normal),0.0)) *  torchcolor ;
		Torchlight_lightmap += (torch_lightmap2+handLight*pow(max(handlightDistance2-length(fragposition.xyz),0.0)/handlightDistance2,4.0)*max(dot(-fragposition.xyz,normal),0.0)) * torchcolor2;

		vec3 color_sunlight = Sunlight_lightmap;
		vec3 color_torchlight = Torchlight_lightmap;

		vec3 emissivecol = length(color)*emissive*color*34.0;
		if (particle > 0.9) color *= 4;

		//Add all light elements together
		color = (reflected_sunlight + SHADOW_DARKNESS*sky_light + MIN_LIGHT*ao + Sunlight_lightmap + color_torchlight*ao  +  sss * lightCol * shading *(1.0-rainStrength*0.)*transition_fading+emissivecol+causticcol)*color * (1.0 + isEyeInWater) + handSpec * torchcolor;


	color *= sky_absorbance;

	//water fog

	float gfactor = mix(0.0,1.0,iswater);

	}

	else if (isEyeInWater < 0.1 && (aux.g < 0.01) ){
				color = mix(color,(gl_Fog.color.rgb+vec3(0.0,0.0,0.02))/2.0,rainStrength)*vec3(0.45,0.45,1.0);

	}

	vec3 cloud_color = normalize((vec3(4,2,-4) + vec3(12,12,12)/12*TimeNoon)* (1-night) + (vec3(4,6,16)/225.0/1.3) + (vec3(0,0,0)*rainx)*night);

	//volumetric cone
	float volumetric_cone = pow(max(dot(normalize(fragpos),lightVector),0.0),2.5*2.5)*transition_fading;
	float volumetric_cone2 = pow(max(dot(normalize(fragpos),lightVector),0.0),2.5*3.5)*transition_fading;
	float volumetric_cone3 = pow(max(dot(normalize(fragpos),-lightVector),0.0),7.0)*transition_fading;

	//volumetric cone
	cloud_color += ambient_color + volumetric_cone*5.0*(1.0-TimeMidnight)*(1.0-TimeSunrise*-2.0)*(1.0-TimeSunset*-2.0);
	cloud_color += ambient_color + volumetric_cone2*1.0*(1.0-rainStrength)*TimeMidnight;
	cloud_color += ambient_color + volumetric_cone3*1.0*(1.0-rainStrength)*TimeMidnight;

	if (land < 0.1){
	#ifdef CLOUDS
	color.rgb += (cloud_color*0.6 * getCloudNoiseTex(fragposition, 15, 1.5, 1.5));
	color.rgb += (cloud_color*0.6 * getCloudNoiseTex(fragposition, 25, 1.4, 1.6));
	color.rgb += (cloud_color*0.3 * getCloudNoiseTex(fragposition, 30, 2.0, 2.0));
	color.rgb += (cloud_color*0.1 * getCloudNoiseTex(fragposition, 45, 2.5, 2.5));

	#endif
		}

#ifdef CELSHADING
	if (land > 0.9 && iswater < 0.9) color = celshade(color);
#endif

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;

	#ifdef GODRAYS

	float gr = 0.0;

	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);

	if (truepos > 0.05) {
		vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
		vec2 textCoord = texcoord.st;
		deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;

			float avgdecay = 0.0;
			float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
			float disty = abs(texcoord.y-lightPos.y);
			vec2 noise = vec2(getnoise(textCoord),getnoise(-textCoord.yx+0.05));

			for(int i=0; i < NUM_SAMPLES ; i++) {
				textCoord -= deltaTextCoord;
				float sample = step(texture2D(gaux1, textCoord+ deltaTextCoord*noise*grnoise).g,0.01);
				gr += sample;
		}
	}
	#endif

	/*
	vec4 tpos2 = vec4(sunPosition,1.0)*gbufferProjection;
		tpos2 = vec4(tpos2.xyz/tpos2.w,1.0);
	vec2 lPos = tpos2.xy/tpos2.z;
		lPos = (lPos + 1.0f)/2.0f;

	float diof = min(min(1.0-lPos.x,lPos.x),min(1.0-lPos.y,lPos.y));
	float fading = clamp(1.0-step(diof,0.1)+pow(diof*10.0,5.0),0.0,1.0);

	float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a*2.5,1.0) * (1.0-rainStrength*0.9) * fading * transition_fading;

	float edgemaskx = clamp(distance(lPos.x, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);
	float edgemasky = clamp(distance(lPos.y, 0.5f)*8.0f - 3.0f, 0.0f, 1.0f);

	float edgemaskxy = (edgemaskx + edgemasky) *fading;

	if (land < 0.9) {

	color += vec3(sunlight_color)*genDirtyLens(texcoord.xy/100)*volumetric_cone;

	}
	*/

/*--------------------------------*/

float horizon3 = (worldposition.y - texcoord.y);
		#ifdef Clouds
		if (land < 0.9 ) color.rgb = drawCloud(fragpos.xyz,color.rgb,1.0,transition_fading);
		#endif

		if (iswater > 0.1 && isEyeInWater < 0.1)
	color = mix(Ucolor*length(ambient_color)*1.00*(1.0-TimeMidnight*0.8),color,exp(-depth/3)); //change the 3 to higher for more transparency

	color = pow(color/16.0,vec3(1.0/2.2));
	color = max(color,0.001);
	//color += getVolumetricRays();
	gl_FragData[0] = vec4(color, 0.0);
	gl_FragData[1] = vec4(vec3(0.0),getVolumetricRays());
}
