#version 120

varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying vec3 ambient_color2;
varying float handItemLight;
varying float eyeAdapt;
varying vec3 moonlight;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying float SdotU;
varying float MdotU;
varying float moonVisibility;
varying float sunVisibility;

uniform vec3 upPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform int worldTime;
uniform int heldItemId;
uniform int heldBlockLightValue;
uniform float rainStrength;

uniform ivec2 eyeBrightnessSmooth;
uniform mat4 gbufferModelView;

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0f, 25000.0f) - 23000.0f) / 1000.0f) + (1.0f - (clamp(timefract, 0.0f, 2000.0f)/2000.0f));
	float TimeNoon     = ((clamp(timefract, 0.0f, 2000.0f)) / 2000.0f) - ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f);
	float TimeSunset   = ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f) - ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f);
	float TimeMidnight = ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f) - ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f);

	////////////////////sunlight color////////////////////
	////////////////////sunlight color////////////////////
	////////////////////sunlight color////////////////////
	const ivec4 ToD[25] = ivec4[25](ivec4(0,1.0,1.75,3.0), //hour,r,g,b
							ivec4(1,1.0,1.75,3.0),
							ivec4(2,1.0,1.75,3.0),
							ivec4(3,1.0,1.75,3.0),
							ivec4(4,1.0,1.75,3.0),
							ivec4(5,1.0,1.75,3.0),
							ivec4(6,200,140,90),
							ivec4(7,160,160,170),
							ivec4(8,160,160,170),
							ivec4(9,160,160,170),
							ivec4(10,160,160,170),
							ivec4(11,160,160,170),
							ivec4(12,160,160,170),
							ivec4(13,160,160,170),
							ivec4(14,160,160,170),
							ivec4(15,160,160,170),
							ivec4(16,160,160,170), 
							ivec4(17,160,160,170),
							ivec4(18,160,160,105),
							ivec4(19,1.0,1.75,3.0),
							ivec4(20,1.0,1.75,3.0),
							ivec4(21,1.0,1.75,3.0),
							ivec4(22,1.0,1.75,3.0),
							ivec4(23,1.0,1.75,3.0),
							ivec4(24,1.0,1.75,3.0));

	////////////////////ambient color////////////////////  // These are colours for landscape and surroundings
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
		const ivec4 ToD2[25] = ivec4[25](ivec4(0,50,70,100), //hour,r,g,b
							ivec4(1,0.5,0.7,1),
							ivec4(2,0.5,0.7,1),
							ivec4(3,0.5,0.7,1),
							ivec4(4,0.5,0.7,1),
							ivec4(5,0.5,0.7,1),
							ivec4(6,10,80,100), 
							ivec4(7,10,80,100),
							ivec4(8,10,80,100),
							ivec4(9,10,80,100),  
							ivec4(10,10,80,100),
							ivec4(11,10,80,100),
							ivec4(12,10,80,100),
							ivec4(13,10,80,100),
							ivec4(14,10,80,100),
							ivec4(15,10,80,100),
							ivec4(16,10,80,100),
							ivec4(17,10,80,100),
							ivec4(18,10,80,100), 
							ivec4(19,0.5,0.7,1),
							ivec4(20,0.5,0.70,1),
							ivec4(21,0.5,0.70,1),
							ivec4(22,0.5,0.70,1),
							ivec4(23,0.5,0.70,1),
							ivec4(24,0.5,0.70,1));

			vec3 sky_color = ivec3(60,170,255)/255.0;


//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
void main() {

	gl_Position = ftransform();

	texcoord = gl_MultiTexCoord0;

	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}

	else {
		lightVector = normalize(moonPosition);
	}


	handItemLight = 0.0;
	if (heldItemId == 50) {
		// torch
		handItemLight = 0.5;
	}

	else if (heldItemId == 76 || heldItemId == 94) {
		// active redstone torch / redstone repeater
		handItemLight = 0.1;
	}

	else if (heldItemId == 89) {
		// lightstone
		handItemLight = 1.0;
	}

	else if (heldItemId == 10 || heldItemId == 11 || heldItemId == 51) {
		// lava / lava / fire
		handItemLight = 0.5;
	}

	else if (heldItemId == 91) {
		// jack-o-lantern
		handItemLight = 0.7;
	}

	else if (heldItemId == 327) {
		//lava bucket
		handItemLight = 1.5;
	}

		else if (heldItemId == 385) {
		//fire charger
		handItemLight = 0.2;
	}

		else if (heldItemId == 138) {
		//Beacon
		handItemLight = 1.0;
	}

		else if (heldItemId == 169) {
		//Sea lantern
		handItemLight = 1.0;
	}

	sunVec = normalize(sunPosition);
	moonVec = normalize(-sunPosition);
	upVec = normalize(upPosition);

	SdotU = dot(sunVec,upVec);
	MdotU = dot(moonVec,upVec);
	moonVisibility = pow(clamp(MdotU+0.1,0.0,0.1)/0.1,2.0);
	sunVisibility = pow(clamp(SdotU+0.1,0.0,0.1)/0.1,2.0);

	vec3 wUp = (gbufferModelView * vec4(vec3(0.0,1.0,0.0),0.0)).rgb;
	vec3 wS1 = (gbufferModelView * vec4(normalize(vec3(3.5,1.0,3.5)),0.0)).rgb;
	vec3 wS2 = (gbufferModelView * vec4(normalize(vec3(-3.5,1.0,3.5)),0.0)).rgb;
	vec3 wS3 = (gbufferModelView * vec4(normalize(vec3(3.5,1.0,-3.5)),0.0)).rgb;
	vec3 wS4 = (gbufferModelView * vec4(normalize(vec3(-3.5,1.0,-3.5)),0.0)).rgb;


ambient_color2 = (sky_color)*50.;
ambient_color2 = pow(normalize(ambient_color2),vec3(1./2.2))*length(ambient_color2);

	eyeAdapt = 1.;
	eyeAdapt = (2.0-min(length(((wUp) + (wS1) + (wS2) + (wS3) + (wS4))*2.)/sqrt(3.)*2.,eyeBrightnessSmooth.y/255.0*0.2))*(1-rainStrength*0.5);

	moonlight =  vec3(0.8,0.9,1.0)/2.0 * 0.050;

	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;


	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];

	sunlight_color = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f * 1.3;

	ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];

	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;

}
