#version 120

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 lightVector;
varying vec3 ambient_color;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;
varying vec3 cloudColor;

varying vec4 color;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform int worldTime;
uniform float rainStrength;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;

uniform mat4 gbufferModelView;

//raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

////////////////////sunlight color////////////////////
////////////////////sunlight color////////////////////
////////////////////sunlight color////////////////////
const ivec4 ToD[25] = ivec4[25](ivec4(0,20,13,8), //hour,r,g,b
							ivec4(1,1.0,1.75,3.0),
							ivec4(2,1.0,1.75,3.0),
							ivec4(3,1.0,1.75,3.0),
							ivec4(4,1.0,1.75,3.0),
							ivec4(5,1.0,1.75,3.0),
							ivec4(6,200,140,90),
							ivec4(7,160,160,170),
							ivec4(8,160,160,170),
							ivec4(9,160,160,170),
							ivec4(10,160,160,170),
							ivec4(11,160,160,170),
							ivec4(12,160,160,170),
							ivec4(13,160,160,170),
							ivec4(14,160,160,170),
							ivec4(15,160,160,170),
							ivec4(16,160,160,170), 
							ivec4(17,160,160,170),
							ivec4(18,160,160,105),
							ivec4(19,1.0,1.75,3.0),
							ivec4(20,1.0,1.75,3.0),
							ivec4(21,1.0,1.75,3.0),
							ivec4(22,1.0,1.75,3.0),
							ivec4(23,1.0,1.75,3.0),
							ivec4(24,1.0,1.75,3.0));



	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
			const ivec4 ToD2[25] = ivec4[25](ivec4(0,50,70,100), //hour,r,g,b
							ivec4(1,0.5,0.7,1),
							ivec4(2,0.5,0.7,1),
							ivec4(3,0.5,0.7,1),
							ivec4(4,0.5,0.7,1),
							ivec4(5,0.5,0.7,1),
							ivec4(6,120,90,70),
							ivec4(7,160,160,170),
							ivec4(8,160,160,170),
							ivec4(9,160,160,170),
							ivec4(10,160,160,170),
							ivec4(11,160,160,170),
							ivec4(12,160,160,170),
							ivec4(13,160,160,170),
							ivec4(14,160,160,170),
							ivec4(15,160,160,170),
							ivec4(16,160,160,170),
							ivec4(17,160,160,170),
							ivec4(18,160,160,100),
							ivec4(19,0.5,0.7,1),
							ivec4(20,0.5,0.70,1),
							ivec4(21,0.5,0.70,1),
							ivec4(22,0.5,0.70,1),
							ivec4(23,0.5,0.70,1),
							ivec4(24,0.5,0.70,1));


/*--------------------------------*/

vec3 getSkyColor(vec3 fposition) {

/*--------------------------------*/
	float SdotU = dot(sunVec,upVec);
	float MdotU = dot(moonVec,upVec);
	float sunVisibility = pow(clamp(SdotU+0.1,0.0,0.1)/0.1,2.0);
	float moonVisibility = pow(clamp(MdotU+0.1,0.0,0.1)/0.1,2.0);
/*--------------------------------*/
vec3 sky_color = vec3(0.1, 0.35, 1.);
vec3 nsunlight = normalize(pow(sunlight,vec3(2.2))*vec3(1.,0.9,0.8));
vec3 sVector = normalize(fposition);

sky_color = normalize(mix(sky_color,vec3(0.25,0.3,0.4)*length(sunlight)*0.3,rainStrength)); //normalize colors in order to don't change luminance
/*--------------------------------*/
float Lz = 1.0;
float cosT = dot(sVector,upVec);
float absCosT = max(cosT,0.0);
float cosS = dot(sunVec,upVec);
float S = acos(cosS);
float cosY = dot(sunVec,sVector);
float Y = acos(cosY);
/*--------------------------------*/
float a = -1.;
float b = -0.24;
float c = 6.0;
float d = -0.8;
float e = 0.45;

/*--------------------------------*/

//sun sky color
float L =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*Y)+e*cosY*cosY);
L = pow(L,1.0-rainStrength*0.8)*(1.0-rainStrength*0.8); //modulate intensity when raining

vec3 skyColorSun = mix(sky_color, nsunlight,1-exp(-0.005*pow(L,4.)*(1-rainStrength*0.8)))*L*0.5; //affect color based on luminance (0% physically accurate)
skyColorSun *= sunVisibility;
/*--------------------------------*/

//moon sky color
float McosS = MdotU;
float MS = acos(McosS);
float McosY = dot(moonVec,sVector);
float MY = acos(McosY);

/*--------------------------------*/

float L2 =  (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*MY)+e*McosY*McosY)+0.2;
L2 = pow(L2,1.0-rainStrength*0.8)*(1.0-rainStrength*0.35); //modulate intensity when raining

vec3 skyColormoon = mix(pow(normalize(moonlight),vec3(2.2))*length(moonlight),normalize(vec3(0.25,0.3,0.4))*length(moonlight),rainStrength)*L2*0.8 ; //affect color based on luminance (0% physically accurate)
skyColormoon *= moonVisibility;
sky_color = skyColormoon*2.0+skyColorSun;
/*--------------------------------*/
return sky_color;
}


//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {

		if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}

	else {
		lightVector = normalize(moonPosition);
	}

	sunVec = normalize(sunPosition);
	moonVec = normalize(-sunPosition);
	upVec = normalize(upPosition);

	SdotU = dot(sunVec,upVec);
	MdotU = dot(moonVec,upVec);
	sunVisibility = pow(clamp(SdotU+0.1,0.0,0.1)/0.1,2.0);
	moonVisibility = pow(clamp(MdotU+0.1,0.0,0.1)/0.1,2.0);

	gl_Position = ftransform();

	texcoord = gl_MultiTexCoord0;

	//sunlight color
	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;


	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];

	sunlight = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;

	sunlight.b *= 0.95;

	moonlight =  vec3(0.8,0.8,1.25) * 0.005;

	ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];

	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;

	//sample the skybox at different places to get an accurate average color from the sky
	vec3 wUp = (gbufferModelView * vec4(vec3(0.0,1.0,0.0),0.0)).rgb;
	vec3 wS1 = (gbufferModelView * vec4(normalize(vec3(3.5,1.0,3.5)),0.0)).rgb;
	vec3 wS2 = (gbufferModelView * vec4(normalize(vec3(-3.5,1.0,3.5)),0.0)).rgb;
	vec3 wS3 = (gbufferModelView * vec4(normalize(vec3(3.5,1.0,-3.5)),0.0)).rgb;
	vec3 wS4 = (gbufferModelView * vec4(normalize(vec3(-3.5,1.0,-3.5)),0.0)).rgb;

	vec3 ambient_color2 = (getSkyColor(wUp) + getSkyColor(wS1) + getSkyColor(wS2) + getSkyColor(wS3) + getSkyColor(wS4))*2.;
	ambient_color2 = pow(normalize(ambient_color),vec3(1./2.2))*length(ambient_color);

	cloudColor = sunlight*sunVisibility*length(ambient_color2) + ambient_color2*(1-moonVisibility*0.8) + 2.0*moonlight*moonVisibility;


}
