#version 120
#define MAX_COLOR_RANGE 48.0

//Triliton`s shaders derive from Chocapic13`s v4
//disabling is done by adding "//" to the beginning of a line.

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

#define VIGNETTE
	#define VIGNETTE_STRENGTH 1.1 		//[0.5 1.0 1.2 1.3 1.4 1.5]

	#define LensFlare
		#define Lens_Strength 1.5		//[0.5 1.1 1.2 1.3 1.4 1.6 1.7 1.8 1.9 2.0]



#define Bloom								//do the "fog blur" in the same time

//#define DOF								//enable depth of field (blur on non-focused objects)
	#define CIRCLE_BOKEH					//enabled : circular blur shape
	//#define HEXAGONAL_BOKEH				//enabled : hexagonal blur shape
	//#define LOW_BOKEH					//enabled : low quality circular blur shape
	//#define TILT_SHIFT 					//to let everything look small more for cinematic purposes
	#define TILT_SHIFT_MULT 1.5;			//[1.0 1.1 1.2 1.3 1.4]
	#define DOF_MULT 1.0					//[1.1 1.2 1.3 1.4 1.5]
	const float MAX_BLUR_SIZE = 1.0;

#define CONTRAST 0.1 				//[0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.5 2.0 2.5]

//#define GLARE							//Glare is removed for now
	#define GLARE_INTENSITY 0.1
	#define GLARE_OFFSET 1.0
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES


const bool gaux2MipmapEnabled = true;
varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 lightVector;
uniform sampler2D depthtex0;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D texture;
uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D composite;
uniform sampler2D noisetex;
uniform sampler2D gnormal;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
varying vec3 ambient_color;
varying vec3 moonlight;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float centerDepthSmooth;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
varying float moonVisibility;
vec3 sunPos = sunPosition;
uniform int fogMode;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float matflag = texture2D(gaux1,texcoord.xy).g;
vec3 aux = texture2D(gaux1, texcoord.st).xyz;

float sky_lightmap = pow(aux.x, 1.0);

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

#ifdef BLOOM
	#ifdef B_SAMPLER
		const vec2 offsets_1[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);
	#endif

#endif

#ifdef TILT_SHIFT
const float focal = 2.0;
float aperture = 0.15;
const float sizemult = 0.25*TILT_SHIFT_MULT;
#else
const float focal = 0.015;
float aperture = 0.009;
const float sizemult = 50.0*DOF_MULT;
#endif


#ifdef DOF

//hexagon pattern
	const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
											vec2(  0.0000,  0.2500 ),
											vec2( -0.2165,  0.1250 ),
											vec2( -0.2165, -0.1250 ),
											vec2( -0.0000, -0.2500 ),
											vec2(  0.2165, -0.1250 ),
											vec2(  0.4330,  0.2500 ),
											vec2(  0.0000,  0.5000 ),
											vec2( -0.4330,  0.2500 ),
											vec2( -0.4330, -0.2500 ),
											vec2( -0.0000, -0.5000 ),
											vec2(  0.4330, -0.2500 ),
											vec2(  0.6495,  0.3750 ),
											vec2(  0.0000,  0.7500 ),
											vec2( -0.6495,  0.3750 ),
											vec2( -0.6495, -0.3750 ),
											vec2( -0.0000, -0.7500 ),
											vec2(  0.6495, -0.3750 ),
											vec2(  0.8660,  0.5000 ),
											vec2(  0.0000,  1.0000 ),
											vec2( -0.8660,  0.5000 ),
											vec2( -0.8660, -0.5000 ),
											vec2( -0.0000, -1.0000 ),
											vec2(  0.8660, -0.5000 ),
											vec2(  0.2163,  0.3754 ),
											vec2( -0.2170,  0.3750 ),
											vec2( -0.4333, -0.0004 ),
											vec2( -0.2163, -0.3754 ),
											vec2(  0.2170, -0.3750 ),
											vec2(  0.4333,  0.0004 ),
											vec2(  0.4328,  0.5004 ),
											vec2( -0.2170,  0.6250 ),
											vec2( -0.6498,  0.1246 ),
											vec2( -0.4328, -0.5004 ),
											vec2(  0.2170, -0.6250 ),
											vec2(  0.6498, -0.1246 ),
											vec2(  0.6493,  0.6254 ),
											vec2( -0.2170,  0.8750 ),
											vec2( -0.8663,  0.2496 ),
											vec2( -0.6493, -0.6254 ),
											vec2(  0.2170, -0.8750 ),
											vec2(  0.8663, -0.2496 ),
											vec2(  0.2160,  0.6259 ),
											vec2( -0.4340,  0.5000 ),
											vec2( -0.6500, -0.1259 ),
											vec2( -0.2160, -0.6259 ),
											vec2(  0.4340, -0.5000 ),
											vec2(  0.6500,  0.1259 ),
											vec2(  0.4325,  0.7509 ),
											vec2( -0.4340,  0.7500 ),
											vec2( -0.8665, -0.0009 ),
											vec2( -0.4325, -0.7509 ),
											vec2(  0.4340, -0.7500 ),
											vec2(  0.8665,  0.0009 ),
											vec2(  0.2158,  0.8763 ),
											vec2( -0.6510,  0.6250 ),
											vec2( -0.8668, -0.2513 ),
											vec2( -0.2158, -0.8763 ),
											vec2(  0.6510, -0.6250 ),
											vec2(  0.8668,  0.2513 ));

	const vec2 offsets[60] = vec2[60]  (  vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.6495, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.6495, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.6495, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));
const vec2 fast_offsets[20] = vec2[20](vec2(1,0),
									vec2(-1,0),
									vec2(0,1),
									vec2(0,-1),
									vec2(0.7,0.7),
									vec2(-0.7,0.7),
									vec2(0.7,-0.7),
									vec2(-0.7,-0.7),
									vec2(0.5,0),
									vec2(-0.5,0),
									vec2(0,0.5),
									vec2(0,-0.5),
									vec2(0.35,0.35),
									vec2(-0.35,0.35),
									vec2(0.35,-0.35),
									vec2(-0.35,-0.35),
									vec2(0.25,0),
									vec2(-0.25,0),
									vec2(0,0.25),
									vec2(0,-0.25)
									);
#endif

float A = 1.0;		//brightness multiplier
float B = 0.34;		//black level (lower means darker and more constrasted, higher make the image whiter and less constrasted)
float C = 0.1;		//constrast level

vec3 Uncharted2Tonemap(vec3 x) {
	float D = 0.09;
	float E = 0.02;
	float F = 0.3;
	float W = MAX_COLOR_RANGE;
	/*--------------------------------*/
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}


float hand  = float(matflag > 0.75 && matflag < 0.85);
float land  = float(matflag > 0.04);

float distratio(vec2 pos, vec2 pos2, float ratio) {
float xvect = pos.x*ratio-pos2.x*ratio;
float yvect = pos.y-pos2.y;
return sqrt(xvect*xvect + yvect*yvect);
}

//circle position pattern (vec2 coordinate, size)
const vec3 pattern[16] = vec3[16](	vec3(0.1,0.1,0.02),
								vec3(-0.12,0.07,0.02),
								vec3(-0.11,-0.13,0.02),
								vec3(0.1,-0.1,0.02),

								vec3(0.07,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.15,-0.19,0.02),

								vec3(0.012,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.02,-0.17,0.021),

								vec3(0.10,0.05,0.02),
								vec3(-0.13,0.09,0.02),
								vec3(-0.05,-0.1,0.02),
								vec3(0.1,0.01,0.02)
								);

float gen_circular_lens(vec2 center, float size) {
return 1.0-pow(min(distratio(texcoord.xy,center,aspectRatio),size)/size,3.0);
}

vec2 noisepattern(vec2 pos) {
return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
}
/*

float pent(in vec2 p){
    vec2 q = abs(p);
    return max(max(q.x*1.176-p.y*0.385, q.x*0.727+p.y), -p.y*1.237)*1.;
}

vec3 flare2(vec2 p, vec2 pos)
{
	vec2 q = p-pos;
    vec2 pds = p*(length(p))*0.75;
	float a = atan(q.x,q.y);

    float rz = 0.0; //Spokes

    rz += max(1.0/(1.0+32.0*pent(pds+0.8*pos)),.0)*00.2;
    vec2 p2 = mix(p,pds,-.5); //Reverse distort
	rz += max(0.01-pow(pent(p2 + 0.4*pos),2.2),.0)*3.0;
	rz += max(0.01-pow(pent(p2 + 0.2*pos),5.5),.0)*3.0;
	rz += max(0.01-pow(pent(p2 - 0.1*pos),1.6),.0)*4.0;
    rz += max(0.01-pow(pent(-(p2 + 1.*pos)),2.5),.0)*5.0;
    rz += max(0.01-pow(pent(-(p2 - .5*pos)),2.),.0)*4.0;
    rz += max(0.01-pow(pent(-(p2 + .7*pos)),5.),.0)*3.0;

    return vec3(clamp(rz,0.,1.));
}
*/

vec3 flare(vec2 uv,vec2 pos)
{
	vec2 main = uv-pos;
	vec2 uvd = uv*(length(uv));

	float ang = atan(main.x,main.y);
	float dist=length(main); dist = pow(dist,.1);

	float f0 = 1.0/(length(uv-pos)*16.0+1.0);
	float f1 = max(0.01-pow(length(uv+1.2*pos),1.9),.0)*7.0;

	float f2 = max(1.0/(1.0+32.0*pow(length(uvd+0.8*pos),1.0)),.0)*00.25;
	float f22 = max(1.0/(1.0+32.0*pow(length(uvd+0.83*pos),1.0)),.0)*00.23;
	float f23 = max(1.0/(1.0+32.0*pow(length(uvd+0.87*pos),1.0)),.0)*00.21;

	vec2 uvx = mix(uv,uvd,-0.5);

	float f4 = max(0.01-pow(length(uvx+0.4*pos),1.4),.0)*6.0;
	float f42 = max(0.01-pow(length(uvx+0.43*pos),1.4),.0)*5.0;
	float f43 = max(0.01-pow(length(uvx+0.47*pos),1.4),.0)*3.0;

	uvx = mix(uv,uvd,-.4);

	float f5 = max(0.01-pow(length(uvx+0.3*pos),3.5),.0)*2.0;
	float f52 = max(0.01-pow(length(uvx+0.35*pos),3.5),.0)*2.0;
	float f53 = max(0.01-pow(length(uvx+0.4*pos),3.5),.0)*2.0;

	uvx = mix(uv,uvd,-0.5);

	float f6 = max(0.01-pow(length(uvx-0.3*pos),0.6),.0)*6.0;
	float f62 = max(0.01-pow(length(uvx-0.325*pos),0.6),.0)*3.0;
	float f63 = max(0.01-pow(length(uvx-0.35*pos),0.6),.0)*5.0;

	vec3 c = vec3(.0);

	c.r+=f2+f4+f5+f6; c.g+=f22+f42+f52+f62; c.b+=f23+f43+f53+f63;
	c = c*1.3 - vec3(length(uvd)*.05);
	c+=vec3(0);

	return c;
}

vec3 cc(vec3 color, float factor,float factor2) // color modifier
{
	float w = color.x+color.y+color.z;
	return mix(color,vec3(w)*factor,w*factor2);
}


float smoothCircleDist (in float lensDist) {

 vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	 tpos = vec4(tpos.xyz/tpos.w,1.0);
 vec2 lightPos = tpos.xy/tpos.z*lensDist;
	 lightPos = (lightPos + 1.0f)/2.0f;

 return distratio(lightPos.xy, texcoord.xy, aspectRatio);
}


void robobo1221sTonemap(inout vec3 color){

	vec3 x = color - 0.07453525;
 vec3 tonemap = ((4.0*x+0.4824124214) / (3.7*x+0.6236954f) - 0.5124124214) * 1.7753525;
 	tonemap = pow(tonemap, vec3(2.2));

 color = tonemap;

}

void convertFinalToHDR(inout vec3 color){

	vec3 MaxExp = color * 4.0;
	vec3 MinExp = color / 4.0;


	vec3 getHDR = mix(MinExp,MaxExp,color.rgb);

	color = getHDR;
}

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {

		float rainlens = 0.0;

	const float lifetime = 4.0;		//water drop lifetime in seconds
	float ftime = frameTimeCounter*2.0/lifetime;
	vec2 drop = vec2(0.0,fract(frameTimeCounter/10.0));
	if (rainStrength > 0.02) {
		float gen = 1.0-fract((ftime+0.5)*0.5);
		vec2 pos = (noisepattern(vec2(-0.94386347*floor(ftime*0.5+1.0),floor(ftime*0.5+1.0))))*0.8+0.1 - drop;
		rainlens += gen_circular_lens(fract(pos),0.04)*gen*rainStrength;

		gen = 1.0-fract((ftime+1.0)*0.5);
		pos = (noisepattern(vec2(0.9347*floor(ftime*0.5+0.5),-1.033282*floor(ftime*0.5+0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.023)*gen*rainStrength;

		gen = 1.0-fract((ftime+1.5)*0.5);
		pos = (noisepattern(vec2(0.785282*floor(ftime*0.5+0.75),-0.285282*floor(ftime*0.5+0.75))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.03)*gen*rainStrength;

		gen =  1.0-fract(ftime*0.5);
		pos = (noisepattern(vec2(-0.347*floor(ftime*0.5),0.6847*floor(ftime*0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.05)*gen*rainStrength;

		rainlens *= clamp((eyeBrightnessSmooth.y-220.0)/15.0,0.0,1.0);
	}

	vec2 fake_refract = vec2(sin(frameTimeCounter*0.5 + texcoord.x*0.0 + texcoord.y*0.0),cos(frameTimeCounter*0.5 + texcoord.y*0.0 + texcoord.x*0.0)) *isEyeInWater ;
	vec2 fake_refract2 = vec2(sin(frameTimeCounter*6.0 + texcoord.x*0.0 + texcoord.y*50.0),cos(frameTimeCounter*0.0 + texcoord.y*0.0 + texcoord.x*100.0));

	vec2 newTC = texcoord.st + fake_refract * 0.01 + (fake_refract2 * 0.02 *rainlens);
	vec3 color = pow(texture2D(gaux2, newTC.xy).rgb,vec3(2.2))*16.0;



#ifdef DOF
    float z = ld(texture2D(depthtex0, texcoord.st).r)*far;
	float blursize = MAX_BLUR_SIZE * 0.1;

	float focus = ld(centerDepthSmooth) * far;

    #ifdef TILT_SHIFT
        blursize = 3.0;
    #endif

    float pcoc = abs((blursize) * ((35.0 / far) * (focus - z)) / (focus * (z - (35.0 / far))));

    #ifdef DISTANT_BLUR
    if (land > 0.9)
    pcoc = min(fog*pw*sizemult,pw*blursize);
    else
    pcoc = min(fog*pw*sizemult,pw*blursize)*(fog*(1-rainStrength)+rainStrength);
    #endif

    #ifdef DUAL_BLUR
    pcoc = min((abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))+fog*pw*land)*sizemult,pw*blursize);
    #endif

    #ifndef HAND_BLUR
    pcoc = pcoc*(1-hand);
    #endif


    vec4 sample = vec4(0.0);
    vec3 bcolor = color/MAX_COLOR_RANGE;
    float nb = 0.0;
    vec2 bcoord = vec2(0.0);

{
     {
    #ifdef HEXAGONAL_BOKEH

        for ( int i = 0; i < 60; i++) {
            bcolor += pow(texture2D(gaux2, texcoord.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb, vec3(2.2));

        }
        color.rgb = bcolor/3.75;
    #endif
    #ifdef LOW_BOKEH
    for ( int i = 0; i < 20; i++) {
        bcolor += pow(texture2D(gaux2, texcoord.xy + fast_offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb, vec3(2.2));
        }
        color.rgb = bcolor/3.75;
    #endif
    #ifdef CIRCLE_BOKEH
    for ( int i = 0; i < 60; i++) {
        bcolor += pow(texture2D(gaux2, texcoord.xy + offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb, vec3(2.2));
        }
        color.rgb = bcolor/3.75;
    #endif
    }
    }
#endif

	float plum = luma(color.rgb);

#ifdef Bloom
vec3 blur = vec3(0);
vec2 bloomcoord = texcoord.xy;

	vec3 blur1 = pow(texture2D(composite,bloomcoord/pow(2.0,2.0) + vec2(0.0,0.0)).rgb,vec3(2.2))*pow(7.0,1.0);
	vec3 blur2 = pow(texture2D(composite,bloomcoord/pow(2.0,3.0) + vec2(0.3,0.0)).rgb,vec3(2.2))*pow(6.0,1.0);
	vec3 blur3 = pow(texture2D(composite,bloomcoord/pow(2.0,4.0) + vec2(0.0,0.3)).rgb,vec3(2.2))*pow(5.0,1.0);
	vec3 blur4 = pow(texture2D(composite,bloomcoord/pow(2.0,5.0) + vec2(0.1,0.3)).rgb,vec3(2.2))*pow(4.0,1.0);
	vec3 blur5 = pow(texture2D(composite,bloomcoord/pow(2.0,6.0) + vec2(0.2,0.3)).rgb,vec3(2.2))*pow(3.0,1.0);
	vec3 blur6 = pow(texture2D(composite,bloomcoord/pow(2.0,7.0) + vec2(0.3,0.3)).rgb,vec3(2.2))*pow(2.0,1.0);

	blur = blur1 + blur2 + blur3 + blur4 + blur5 + blur6;

float fogrange = ((50*(8.0-2.5*rainStrength))/(1+rainStrength)*(1-isEyeInWater) + isEyeInWater);
float fogfade = 128.0*(12*(1-isEyeInWater)+2.0*isEyeInWater);
vec3 wpos  = nvec3(gbufferProjectionInverse * nvec4(vec3(texcoord.xy,texture2D(depthtex0,texcoord.xy).x) * 2.0 - 1.0));
float fbfog = max((length(wpos)-fogrange)/fogfade,0.0);

vec3 fblurcol = clamp(mix(blur1/7.0,blur/22.0,rainStrength)*MAX_COLOR_RANGE*0.05,vec3(0.0),vec3(2.2));
float blurmix0 = clamp(fbfog*8.0*(1.0+rainStrength*4),0.0,1.0)*(mix(land,1.0,isEyeInWater)*(1-rainStrength)+rainStrength);
//color = mix(color,fblurcol,blurmix0);

color.rgb = mix(color,blur*MAX_COLOR_RANGE,0.0043);
#endif


color.rgb += texture2D(gaux4,texcoord.xy).rgb*sqrt(texture2D(gaux4,texcoord.xy).a);
color.rgb *= 1.0+pow(rainlens,2.0)*0.3;

#ifdef LensFlare
vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
vec2 lightPos = tpos.xy/tpos.z;
	lightPos = (lightPos + 1.0f)/2.0f;
	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);
	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22800.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));
	float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
	float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);
	float fade = clamp(1.0-step(distof,0.08),0.0,1.0);
	float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a*2.5,1.0) * (1.0-rainStrength*0.9) * fading * transition_fading;
	float sun = sunvisibility*Lens_Strength;
	float visibility = max(pow(max(1.0 - smoothCircleDist(1)/.75,.1),2)-.1,0);
	float h = TimeMidnight, r = rainStrength;
	vec3 L = lightVector;
	float tp = pow(clamp(dot(-L,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);
	float x = abs(lightPos.x-texcoord.x);
	float y = abs(lightPos.y-texcoord.y);


	if (sun*fade > 0.05) {
color += vec3(1.4,1.2,1.0)*flare(texcoord.st - 0.5,sunPosition.xy/100)*(1-h) * truepos * sun * (1-r);
//color += vec3(1.4,1.2,1.0)*flare2(texcoord.st - 0.5,sunPosition.xy/100)*(1-h) * (1-r);
	//Anamorphic Lens
	float a_l = exp(-y*y/0.0001)*exp(-x*x/0.04)*sun*(1-h*0.9) * (1-r);
	//color.rgb += (vec3(0.0,1.08,1.4)*a_l)* tp;

	}
#endif

#ifdef VIGNETTE

float dv = distance(texcoord.st, vec2(0.5, 0.5));

dv *= VIGNETTE_STRENGTH;

dv = 0.9 - dv;

dv = pow(dv, 0.25);

dv *= 2.3;
dv -= 0.9;

color *= dv;
#endif

color *= 1.0+3.0*color;
color /= sqrt(color*color+1.0);
color *= sqrt(color);

	color = clamp(pow(color,vec3(1.0/2.2)),0.0,1.0);

 gl_FragColor = vec4(color,1.0);

}
