#version 120

/*
!! DO NOT REMOVE !!
This code is from CYBOX shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

varying vec4 texcoord;

varying vec3 worldpos;

varying float iswater;

uniform sampler2D tex;

uniform vec3 cameraPosition;

uniform float frameTimeCounter;

uniform sampler2D noisetex;

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

float waterH(vec2 posxz) {

vec2 movement = vec2(-abs(frameTimeCounter/2000.-0.5),-abs(frameTimeCounter/1000.-0.5));
vec2 movement2 = vec2(abs(frameTimeCounter/2000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement3 = vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/2000.-0.5));
vec2 movement4 = vec2(abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/2000.-0.5));

vec2 coord = (posxz/600)+(movement);
vec2 coord1 = (posxz/599.9)+(movement2);
vec2 coord2 = (posxz/599.8)+(movement);
vec2 coord3 = (posxz/599.7)+(movement2);

float noise = texture2D(noisetex,fract(coord.xy/2.0)).x/8;
noise += texture2D(noisetex,fract(coord1.xy)).x/16.0;
noise += texture2D(noisetex,fract(coord2.xy*2.0)).x/8;
noise += texture2D(noisetex,fract(coord3.xy*2.0)).x/8;

return noise;
}

void main() {
	vec3 uwpos = (worldpos + cameraPosition.xyz);
	
  const float deltaPos = 0.1;

  float caustic = 0;

  if(iswater > 0.5) {
    float base = waterH(uwpos.xz);
	
	

    #define h0 base

    vec4 compare = vec4(0.0);

    #define h1 compare.x
    #define h2 compare.y
    #define h3 compare.z
    #define h4 compare.w

    h1 = waterH(uwpos.xz + vec2(deltaPos,0.0));
    h2 = waterH(uwpos.xz + vec2(-deltaPos,0.0));
    h3 = waterH(uwpos.xz + vec2(0.0,deltaPos));
    h4 = waterH(uwpos.xz + vec2(0.0,-deltaPos));

    caustic = max(2-(abs(h2-h1)+abs(h4-h3))*6.0-pow(abs(h0-0.5),3.0)*24.0,0.0);
    caustic = max(pow(caustic,6.0),0.0)*0.05;
  }

  vec4 albedo = texture2D(tex, texcoord.xy);

  if(iswater > 0.5) albedo.rgb = vec3(caustic);

	gl_FragData[0] = albedo;
}