#version 120

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

	//Torch Color//
	vec3 torchcolor = vec3(2.0,3.0,1.0);		//RGB - Red, Green, Blue /
	#define TORCH_ATTEN 1.5					//[0.5 0.6 0.7 0.8 0.9 1.1 1.2 1.3 1.4 1.6 1.7 1.8 1.9 2.0]//how much the torch light will be attenuated (decrease if you want the torches to cover a bigger area) // 1.5 is default
	#define TORCH_INTENSITY 0.60 			//[0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.50 0.55 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.0] //How strong a torch will shine 
	
#define Stars	
	
//#define GODRAYS						//These are the sunrays. 
	const float exposure = 0.3;
	const float density = 1.0;
	const int NUM_SAMPLES = 20;			//[5 6 7 8 9 10 15 25 30 35 40 45 50] //increase this for better quality at the cost of performance 
	const float grnoise = 1.0;		//amount of noise /0.0 is default
#define	GODRAYS_SIZE 0.1			// [0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0] //higher values = smaller [0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

#define WATER_REFLECTIONS				//This is the mirror reflection in the water
	#define REFLECTION_STRENGTH 0.25		//[ 0.1 0.15 0.2 0.3 0.35 0.4 0.5 0.6 0.7 0.9 1.0] //default 0.25

//#define RAIN_REFLECTION				//Wetness reflection is disabled for now

//#define VOLUMETRIC_LIGHT				//These are the volumetric rays

//#define MOTIONBLUR					//This is the blurr effect when moving your head from side to side 
	#define MOTIONBLUR_AMOUNT 0.002		//[0.001 0.003 0.004 0.005 0.006 0.007 0.008 0.009]

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES 

const bool gdepthMipmapEnabled = true;



//don't touch these lines if you don't know what you do!
const int maxf = 5;				//number of refinements
const float stp = 1.0;			//size of one step for raytracing algorithm
const float ref = 0.12;			//refinement multiplier
const float inc = 1.6;			//increasement factor at each step

const int Gmaxf = 4;			//number of refinements
const float Gstp = 1.0;			//size of one step for raytracing algorithm
const float Gref = 0.1;			//refinement multiplier
const float Ginc = 2.4;			//increasement factor at each step


varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 lightVector;
varying vec3 ambient_color;

uniform sampler2D gcolor;
uniform sampler2D gaux1;
uniform sampler2D gaux3;
uniform sampler2D gaux2;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D composite;
uniform sampler2D gdepth;
uniform sampler2D noisetex; 

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform vec3 skyColor;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferPreviousModelView;
uniform vec3 previousCameraPosition;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int isEyeInLava;
uniform int worldTime;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
float timefract = worldTime;
uniform int fogMode;

float comp = 1.0-near/far/far;			//distance above that are considered as sky

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float transition_fading = 1.0-(clamp((timefract-12000.0)/300.0,0.0,1.0)-clamp((timefract-13000.0)/300.0,0.0,1.0) + clamp((timefract-22800.0)/200.0,0.0,1.0)-clamp((timefract-23400.0)/200.0,0.0,1.0));


float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

	float matflag = texture2D(gaux1,texcoord.xy).g;


	vec3 fogclr = mix(gl_Fog.color.rgb,vec3(0.2,0.2,0.2),rainStrength)*ambient_color;
	vec3 fogclr2 = fogclr;
	vec3 fogclr3 = fogclr;
	vec3 fogclr4 = fogclr;

    vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
    vec3 normal = texture2D(composite, texcoord.st).rgb * 2.0 - 1.0;

	float sky_lightmap = texture2D(gaux1,texcoord.xy).r;
    float pixeldepth = texture2D(depthtex0,texcoord.xy).r;  
	float iswet = wetness*pow(sky_lightmap,8.0)*sqrt(0.5+max(dot(normal,normalize(upPosition)),0.0));
	
	int iswater = int(matflag > 0.04 && matflag < 0.07);

	vec3 specular = texture2D(gaux3,texcoord.xy).rgb;
	float specmap = specular.r*(1.4-specular.b*1.4)+specular.g*iswet+specular.b*0.85;
    vec4 color = vec4(pow(texture2D(gcolor,texcoord.xy).rgb,vec3(2.2))*16.0,1.0);

	const float speed = 1.5;
	float light_jitter = 1.0-sin(frameTimeCounter*1.4*speed+cos(frameTimeCounter*1.9*speed))*0.025;			//little light variations
	float torch_lightmap = pow(texture2D(gaux1,texcoord.xy).b*light_jitter,TORCH_ATTEN)*TORCH_INTENSITY;


float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.x-0.5),abs(coord.y-0.5))*2.0;
}

float luma(vec3 color) {
return dot(color.rgb,vec3(0.299, 0.587, 0.114));
}

vec4 raytrace(vec3 fragpos, vec3 normal, vec3 fogColor, float fresnel) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = distance(fragpos.xyz,spos.xyz);
        if(err < pow(length(vector)*1.85,1.15)){

                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 5.0), 0.0, 1.0);
					bool land = texture2D(depthtex1, pos.st).x < comp;
                    color = texture2D(gcolor, pos.st) * fresnel;
					color.rgb = land ? color.rgb : fogColor;
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=ref;


}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}

float getnoise(vec2 pos) {
return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));

}

float dynamicExposure() {
		return clamp((-eyeBrightnessSmooth.y+230)/100.0,0.0,1.0);
}

vec3 getFog(in vec3 color, in float land, in vec2 pos, in float hand, in float iswater){

	vec3 fragposFog = vec3(pos.st, texture2D(depthtex0, pos.st).r);
	fragposFog = nvec3(gbufferProjectionInverse * nvec4(fragposFog * 2.0 - 1.0));

	vec4 worldposition = vec4(0.0);
		 worldposition = gbufferModelViewInverse * vec4(fragposFog,1.0);
	float horizon = (worldposition.y - (pos.y-cameraPosition.y));

	float calcHeight = (max(pow(max(1.5 - horizon/100.0, 0.0), 1.0)-0.0, 0.0));

	float volumetric_cone = pow(max(dot(normalize(fragposFog),lightVector),0.0),2.5)*transition_fading;
	float volumetric_cone2 = pow(max(dot(normalize(fragposFog),lightVector),0.0),10.0*400.0);
	float volumetric_cone3 = pow(max(dot(normalize(fragposFog),lightVector),0.0),10.0*1000.0)*transition_fading;
	float norain = 1.0-rainx;

	if (isEyeInWater > .9) {
	} else {

		float fog = exp(-pow(sqrt(dot(fragposFog,fragposFog))/far*0.5*(1- dynamicExposure())*(1-(TimeSunrise+TimeSunset)*0.4) ,2.0)); //increasing far increases fog for day
		float fog2 = exp(-pow(sqrt(dot(fragposFog,fragposFog))/60*(1-dynamicExposure()*.8) ,2.0)); //this controls rainfog distance.
		float fog3 = exp(-pow(sqrt(dot(fragposFog,fragposFog))/140 ,2.0));
		float fog4 = exp(-pow(sqrt(dot(fragposFog,fragposFog))/40 ,2.0));
		float fogfactor =  clamp(fog + hand,0.0,1.0);
		float fogfactor2 =  clamp(fog2 + hand,0.0,1.0);
		float fogfactor3 =  clamp(fog3 + hand,0.0,1.0);
		float fogfactor4 =  clamp(fog4 + hand,0.0,1.0)*rainx;

		vec3 rainfogclr = vec3(0.1,0.095,0.1)*rainx*mix(1-TimeMidnight,1.0,(1-transition_fading) * pow(TimeSunrise + TimeSunset, 0.5)); 

		fogclr2 = rainfogclr*8.0*rainx;
		fogclr2 += mix(color.rgb,ambient_color*0.7,1.0)*rainx*(TimeMidnight + (1-transition_fading));
		fogclr2 = clamp(fogclr2,0.0,0.8*0.18); //change the last numbers for brighter fog.
		fogclr = clamp(mix(fogclr, ambient_color, (1-TimeMidnight)*(1+TimeSunrise*.25)*(1+TimeNoon*.5)),0.0,1.0);
		fogclr.g -= fogclr.g*0.05; //changing this to lower makes more gray fog 
		fogclr.rb -= fogclr.rb*0.1*(TimeSunrise+TimeSunset);

		//glow

		fogclr += pow(sunlight,vec3(2.2)) * volumetric_cone*transition_fading*(1.0-TimeMidnight)*(1.0-TimeNoon)*(1.0-rainx*0.4)*2.5;
		fogclr += fogclr * 0.05 * volumetric_cone*2*transition_fading*TimeMidnight*(1.0-rainx)*1.0;

		fogclr = mix(fogclr,sunlight,volumetric_cone*0.5*(1.0-TimeMidnight)*(1.0-TimeSunrise)*(1.0-TimeSunset)*(1.0-rainx)*1.0);

		if (land > 0.9) {
		} else {
			color.rgb = mix(color.rgb,fogclr,clamp((1-fogfactor)*(1-clamp(calcHeight,0.0,1.0))*.5*(1- dynamicExposure()), 0.0, 1.0));
			color.rgb = mix(color.rgb,fogclr2,(1-fogfactor2)*rainx*(1-TimeMidnight));
		}

		if (land < 0.9) {
			} else {
				color.rgb += vec3(rainfogclr*rainx)*(1.0*rainx)*(1.0-TimeMidnight);
			}

		color.rgb = mix(color.rgb,fogclr2 * 1.2,min((1-fogfactor2)*rainx*(1- TimeMidnight) * 2.0,1.0));
		color.rgb = mix(color.rgb,fogclr2 / 2.0,(1-fogfactor2)*rainx*(TimeMidnight));

		//altitude fog
		if (land > 0.9) {
			} else {
				color.rgb = mix(color.rgb,fogclr.rgb*(1- rainx),clamp((1-fogfactor)*2.0*(1-rainx)*(1-TimeMidnight)*(clamp((calcHeight), 0.0, 1.0)),0.0,1.0));

				calcHeight = (max(pow(max(0.76 - horizon/300.0, 0.0), 8.0)-0.0, 0.0));
				color.rgb  = mix(color.rgb,clamp(fogclr * 0.0, 0.0, 0.0),clamp(3.0*(clamp((calcHeight) * 100, 0.0, 1.0))*(TimeMidnight)*(1- rainx)*(1-TimeSunrise)*(transition_fading)*(1-fogfactor3),0.0,1.0));
			}

			float volumetric_cone = pow(max(dot(normalize(fragpos),lightVector),0.0),2.5)*transition_fading;
			float volumetric_cone2 = pow(max(dot(normalize(fragpos),lightVector),0.0),1000.0)*transition_fading;    //this is the moon size 
			float volumetric_cone3 = pow(max(dot(normalize(fragpos),lightVector),0.0),10.0*25.0)*transition_fading;
			float volumetric_cone4 = pow(max(dot(normalize(fragpos),lightVector),0.0),10.0*5.0)*transition_fading;

			//sun
			if (land > 0.9) {
			
			color += sunlight*volumetric_cone4*(0.5)*(1.0-TimeMidnight)*(1.0-rainStrength)*(1.0-iswater*0.37); // this is the sun shape and size 

			//moon
			color += (moonlight*1+ambient_color*0.1+1*volumetric_cone2*3.0*(1.0-rainStrength)*(1.0-iswater*0.8))*TimeMidnight;
			}

	}
	return color;
}
#ifdef Stars
 vec3 drawStar(vec3 fposition,vec3 color) {
  float volumetric_cone = pow(max(dot(normalize(fposition),normalize(-sunPosition)),0.0),200.0);
  vec3 sVector = normalize(fposition);
  float cosT = dot(sVector,normalize(upPosition));

  //star generation

  vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
  vec3 wVector = normalize(tpos);
  vec3 intersection = wVector*(50.0/(wVector.y));
  vec2 coord = (intersection.xz)/256.0 + 0.1;
  float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;
  noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
  float star = max(noise-1.3,0.0);
  star = star * max(cosT,0.0) * 2.0 * TimeMidnight * (1-rainx);

  vec3 sum = vec3(1.0, 1.0, 1.0)*(1-rainx) * (1-volumetric_cone);

  vec3 s = mix(color,sum,star);
  return s;
 }
#endif

float getEyeBrightnessSmooth = pow(clamp(eyeBrightnessSmooth.y / 220.0f,0.0,1.0), 3.0f);

#ifdef VOLUMETRIC_LIGHT

 vec3 getVolumetricLight(vec3 color, vec2 pos){

  float volumetricLightSample = 0.0;
  float vlWeight = 0.0;
  
  float depth = ld(pixeldepth);
  
  for (float i = -1.0; i < 1.0; i++){
   for (float j = -1.0; j < 1.0; j++){
    
    vec2 offset = vec2(i,j) / vec2(viewWidth, viewHeight);
    
    float depth2 = ld(texture2D(depthtex0, pos.st + offset * 8.0).x);
    
    float weight = pow(1.0 - abs(depth - depth2) * 10.0, 32.0);
     weight = max(0.1e-8, weight);
     
    volumetricLightSample += texture2D(gdepth, pos.xy + offset * 4.0, 2.0).a * weight;
    
    vlWeight += weight;
   }
  }
  
  volumetricLightSample /= vlWeight*4.0;
  
  //volumetricLightSample = texture2D(gcolor, pos.xy).a;
  
  float sunAngleCosine = pow(clamp(dot(normalize(fragpos.rgb), lightVector), 0.0, 1.0), 25.0);
  
  float vlMult = 0.5;
   vlMult = vlMult + (1.0 - getEyeBrightnessSmooth) * (1.0 - TimeMidnight * transition_fading * 0.5);
   vlMult *= 1.0 - isEyeInWater; 
   vlMult *= 0.75 * 0.5;
  
  vec3 lightCol = mix(sunlight, moonlight * 40.0, TimeMidnight);
   lightCol = mix(mix(mix(mix(lightCol, ambient_color, 0.95), lightCol, sunAngleCosine), lightCol, clamp(TimeMidnight * (1.0 - TimeSunrise * 0.5),0.0,1.0)), lightCol, 1.0 - getEyeBrightnessSmooth);
   lightCol *= 1.0 + sunAngleCosine * mix(3.0, 1.0, TimeNoon);
  
  return pow(mix(pow(color, vec3(2.2)), pow(lightCol, vec3(2.2)), volumetricLightSample * mix(0.5, 1.0, clamp(TimeMidnight + pow(TimeSunset, 6.0) * 0.05,0.0,1.0)) * transition_fading * (1.0 - rainStrength) * vlMult), vec3(0.4545));
 }

#endif

float Blinn_Phong(vec3 ppos, vec3 lvector, vec3 normal,float fpow, float gloss, float visibility)  {
 vec3 lightDir = vec3(lvector);

 vec3 surfaceNormal = normal;
 float cosAngIncidence = dot(surfaceNormal, lightDir);
 cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);

 vec3 viewDirection = normalize(-ppos);

 vec3 halfAngle = normalize(lightDir + viewDirection);
 float blinnTerm = dot(surfaceNormal, halfAngle);

 float normalDotEye = dot(normal, normalize(ppos));
 float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0);
 fresnel = fresnel*0.5 + 0.5 * (1.0-fresnel);
 float pi = 3.1415927;
 float n =  pow(1.8,gloss*13.0); 
 return (pow(blinnTerm, n )*((n+8.0)/(8*pi)))*fresnel*visibility * 10;
}



//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {
	int land = int(matflag < 0.03);
	int hand  = int(matflag > 0.75 && matflag < 0.85);

	vec3 moonlight = vec3(0.8,0.8,1.25) * 0.005; // this is Moonlight
	

#ifdef MOTIONBLUR

	vec4 depth  = texture2D(depthtex2, texcoord.st);

	vec4 currentPosition = vec4(texcoord.x * 2.0 - 1.0, texcoord.y * 2.0 - 1.0, 2.0 * depth.x - 1.0, 1.0);

	vec4 fragposition = gbufferProjectionInverse * currentPosition;
	fragposition = gbufferModelViewInverse * fragposition;
	fragposition /= fragposition.w;
	fragposition.xyz += cameraPosition;


	vec4 previousPosition = fragposition;
	previousPosition.xyz -= previousCameraPosition;
	previousPosition = gbufferPreviousModelView * previousPosition;
	previousPosition = gbufferPreviousProjection * previousPosition;
	previousPosition /= previousPosition.w;


	vec2 velocity = (currentPosition - previousPosition).st * MOTIONBLUR_AMOUNT;

	int samples = 1;

	vec2 coord = texcoord.st + velocity;
	for (int i = 0; i < 8; ++i, coord += velocity) {
		if (coord.s > 1.0 || coord.t > 1.0 || coord.s < 0.0 || coord.t < 0.0) {
			break;
		}
            color += texture2D(gcolor, coord),color.rgb, iswater;
			++samples;
	}

	color = (color/1.0)/samples;

#endif

	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));

	#ifdef Stars
  if (land>0.9) color.rgb = drawStar(fragpos.xyz,color.rgb);
 #endif
 
	
	
	float fresnel_pow = mix(pow(1.0-(specular.b+specular.g)/2.0,1.25+iswet*0.75)*3.5,3.0,iswater);
		float normalDotEye = dot(normal, normalize(fragpos));
		float fresnel = clamp(pow(1.0 + normalDotEye, fresnel_pow),0.0,1.0);
		vec4 reflection;
		
		
		vec3 waterSkyColor = gl_Fog.color.rgb / 2.0;
	
	if (iswater > 0.9 && isEyeInWater < 0.9) {
	#ifdef WATER_REFLECTIONS
	
		waterSkyColor *= fresnel * 3;
		
		float spec =  Blinn_Phong(fragpos.xyz,lightVector,normal,fresnel_pow,1.0,1.0) * iswater * (1.0-isEyeInWater) * (1.0-TimeMidnight*0.97) * (1.0-rainx);
		
		waterSkyColor += clamp(spec * float(sky_lightmap > 0.9),0.0,1.0);
	
		reflection = raytrace(fragpos, normal, waterSkyColor, fresnel);
		
		reflection.rgb = mix(waterSkyColor, reflection.rgb, reflection.a);			//fake sky reflection, avoid empty spaces
		reflection.a = min(reflection.a + 0.1*sky_lightmap,0.1);
		color.rgb += reflection.rgb * REFLECTION_STRENGTH;

		#endif
	    }

	#ifdef RAIN_REFLECTION
	if (iswater < 0.9) {
	reflection = raytrace(fragpos, normal, waterSkyColor, fresnel);
	color.rgb += (reflection.rgb*fresnel*0.4*reflection.a)*iswet;
	}

	  {
  color.rgb += reflection.rgb * mix(vec3(1.0/sqrt(3.0)),normalize(color.rgb),specular.b*1+0.05) * (specmap+iswater)*fresnel*(1.5-isEyeInWater*-2.0) *reflection.a;
  }
  	#endif

	    vec3 colmult = mix(vec3(1.0),vec3(0.6)*(1.0-TimeMidnight*0.7),isEyeInWater); //lower the 06 to get it darker under water 
		float depth_diff = clamp(pow(ld(texture2D(depthtex0, texcoord.st).r) * 2.0,0.25),0.0,1.0);
		color.rgb = mix(color.rgb * colmult,vec3(0.025,0.05,0.068) * 4.0,depth_diff*(1.0-TimeMidnight*-0.4)*isEyeInWater); //this changes underwater colours
	
	

	color.rgb = getFog(color.rgb, land, texcoord.st, hand, iswater);

/* DRAWBUFFERS:5 */


		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
		vec2 pos1 = tpos.xy/tpos.z;
		vec2 lightPos = pos1*0.5+0.5;

	#ifdef GODRAYS
	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);
	if (truepos > 0.05) {
	    vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
    vec2 textCoord = texcoord.st;
    deltaTextCoord *= 0.0 /  float(NUM_SAMPLES) * density;
    float illuminationDecay = 1.0;
	vec2 noise = vec2(getnoise(textCoord),getnoise(-textCoord.yx+0.05));
	float gr = 0.0;
	float avgdecay = 0.0;
			float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
			float disty = abs(texcoord.y-lightPos.y);
            illuminationDecay = pow(max(1.0-sqrt(distx*distx+disty*disty),0.0),GODARYS_SIZE);
    for(int i=0; i < NUM_SAMPLES ; i++)
    {

            textCoord -= deltaTextCoord;




            float sample = texture2D(gdepth, textCoord + noise*grnoise, 2.25).r;
			gr += sample;

    }
	color.rgb = mix(color.rgb,pow(sunlight,vec3(1.0/4.0))*(1-TimeMidnight) + (moonlight*50.0 * TimeMidnight),(gr/NUM_SAMPLES)*exposure*length(pow(sunlight,vec3(1.0/4.0))*(1-TimeMidnight) + + (moonlight*50.0 * TimeMidnight))*(1.0 - rainStrength*0.5)*illuminationDecay*truepos/sqrt(3.0)*transition_fading);
	}
	#endif

float visiblesun = 0.0;
float temp;
int nb = 0;


//calculate sun occlusion (only on one pixel)
if (texcoord.x < pw && texcoord.x < ph) {
	for (int i = 0; i < 10;i++) {
		for (int j = 0; j < 10 ;j++) {
		temp = texture2D(gaux1,lightPos + vec2(pw*(i-5.0)*1.0,ph*(j-5.0)*1.0)).g;
		visiblesun +=  1.0-float(temp > 0.04) ;
		nb += 1;
		}
	}
	visiblesun /= nb;

}
		#ifdef VOLUMETRIC_LIGHT 
  color.rgb = getVolumetricLight(color.rgb, texcoord.st);
 #endif

	gl_FragData[0] = vec4(pow(color.rgb/16.0,vec3(1.0/2.2)),visiblesun);

}
