#version 120

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 lightVector;

uniform int worldTime;
uniform float rainStrength;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

	const ivec4 ToD[25] = ivec4[25](ivec4(0,2.0,2.5,4), //hour,r,g,b
							ivec4(1,2.0,2.5,4),
							ivec4(2,2.0,2.5,4),
							ivec4(3,2.0,2.5,4),
							ivec4(4,2.0,2.5,4),
							ivec4(5,2.0,2.5,4),
							ivec4(6,135,50,10),
							ivec4(7,135,55,30),
							ivec4(8,150,100,60),
							ivec4(9,160,120,80),
							ivec4(10,160,120,80),
							ivec4(11,160,120,80),
							ivec4(12,160,120,80),
							ivec4(13,160,120,80),
							ivec4(14,160,120,80),
							ivec4(15,160,120,80),
							ivec4(16,150,100,60),
							ivec4(17,135,55,30),
							ivec4(18,135,50,10),
							ivec4(19,2.0,2.5,4),
							ivec4(20,2.0,2.5,4),
							ivec4(21,2.0,2.5,4),
							ivec4(22,2.0,2.5,4),
							ivec4(23,2.0,2.5,4),
							ivec4(24,2.0,2.5,4));

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {

	gl_Position = ftransform();

	texcoord = gl_MultiTexCoord0;

	if (worldTime < 12700 || worldTime > 23250) {
	lightVector = normalize(sunPosition);
}

else {
	lightVector = normalize(moonPosition);
}

	//sunlight color
	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;


	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];

	sunlight = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;
}
