#version 120
#extension GL_ARB_shader_texture_lod : enable

/* DRAWBUFFERS:0346 */

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
uniform int isEyeInWater;
	//#define USE_WATER_TEXTURE
	
vec4 watercolor = vec4(0.15*0.5,0.70*0.4,0.80*0.8,0.88)*(1.0-isEyeInWater*0.5) * 0.55; 	//water color and opacity (r,g,b,opacity)  //last nr controls transparency

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

const int MAX_OCCLUSION_POINTS = 20;
const float MAX_OCCLUSION_DISTANCE = 32.0;
const float bump_distance = 64.0;				//Bump render distance: tiny = 32, short = 64, normal = 128, far = 256
const float pom_distance = 32.0;				//POM render distance: tiny = 32, short = 64, normal = 128, far = 256
const float fademult = 1.0;
const float PI = 3.1415927;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;
varying vec4 position;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 viewVector;
varying vec3 wpos;
varying float iswater;
varying float viewdistance;

uniform vec3 cameraPosition;
uniform vec3 upPosition;

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform int worldTime;
uniform float rainStrength;
uniform float frameTimeCounter;

	float timefract = worldTime;

	float TimeSunrise  = ((clamp(timefract, 23000.0f, 25000.0f) - 23000.0f) / 1000.0f) + (1.0f - (clamp(timefract, 0.0f, 2000.0f)/2000.0f));
	float TimeNoon     = ((clamp(timefract, 0.0f, 2000.0f)) / 2000.0f) - ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f);
	float TimeSunset   = ((clamp(timefract, 9000.0f, 12000.0f) - 9000.0f) / 3000.0f) - ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f);
	float TimeMidnight = ((clamp(timefract, 12000.0f, 12750.0f) - 12000.0f) / 750.0f) - ((clamp(timefract, 23000.0f, 24000.0f) - 23000.0f) / 1000.0f);

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

float waterH(vec2 posxz) {

vec2 movement = vec2(abs(frameTimeCounter/2000.-0.5),-abs(frameTimeCounter/2000.-0.5));
vec2 movement2 = vec2(abs(frameTimeCounter/2000.-0.5),abs(frameTimeCounter/2000.-0.5));
vec2 movement3 = vec2(-abs(frameTimeCounter/1000.-0.5),abs(frameTimeCounter/1000.-0.5));
vec2 movement4 = vec2(-abs(frameTimeCounter/1000.-0.5),-abs(frameTimeCounter/1000.-0.5));

vec2 coord = (posxz/600)+(movement);
vec2 coord1 = (posxz/599.9)+(movement2);
vec2 coord2 = (posxz/599.8)+(movement3);
vec2 coord3 = (posxz/599.7)+(movement4);

float noise = texture2D(noisetex,fract(coord.xy + coord.yx/4.0)).x/2.0;
noise += texture2D(noisetex,fract(coord1.xy + coord1.yx)).x/2.0;
noise += texture2D(noisetex,fract(coord2.xy + coord2.yx*2.0)).x/4.0;
noise += texture2D(noisetex,fract(coord3.xy + coord3.yx*4.0)).x/8.0;

return noise;
}

vec3 stokes(in float ka, in vec3 k, in vec3 g) {
    // ka = wave steepness, k = displacements, g = gradients / wave number
    float theta = k.x + k.z + k.t;
    float s = ka * (sin(theta) + ka * sin(2.0f * theta));
    return vec3(s * g.x, s * g.z, g.t);  // (-deta/dx, -deta/dz, scale)
}

vec3 waves1() {
    float scale = 8.0f / (viewdistance * viewdistance);
    vec3 gg = vec3(scale, 3600.0f, scale);
    vec3 gk = vec3(viewdistance * 6.0f, frameTimeCounter * -6.0f, 0.0f);
    vec3 gwave = stokes(10.0f, gk, gg);
    return normalize(gwave);
}

float smoothStep(in float edge0, in float edge1, in float x) {
    float t = clamp((x - edge0) / (edge1 - edge0), 0.0f, 1.0f);
    return t * t * (3.0f - 2.0f * t);
}

vec3 getParallaxWaves(vec3 posxz, vec3 viewVector) {
	vec3 parallaxPos = posxz;
	float height = 1.2;
	int sample = 4;
	float waveH = (waterH(posxz.xz)*1.0-0.5)*height/sample;
	
	for(int i = 0; i < sample; i++){
		parallaxPos.xz += waveH*(viewVector.xy);
		waveH = (waterH(parallaxPos.xz)*1.0-0.5)*height/sample;
	}
	return parallaxPos;
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	vec4 tex = vec4((watercolor*length(texture2D(texture, texcoord.xy).rgb*color.rgb)*color).rgb,watercolor.a);
	#ifdef USE_WATER_TEXTURE
	if (iswater > 0.9)  tex = texture2D(texture, texcoord.xy)*color;
	#else
	if (iswater < 0.9)  tex = texture2D(texture, texcoord.xy)*color;
	#endif

	vec3 posxz = wpos.xyz;
	posxz = getParallaxWaves(posxz,viewVector);

	float deltaPos = 0.3;
	float h0 = waterH(posxz.xz);
	float h1 = waterH(posxz.xz + vec2(deltaPos,0.0));
	float h2 = waterH(posxz.xz + vec2(-deltaPos,0.0));
	float h3 = waterH(posxz.xz + vec2(0.0,deltaPos));
	float h4 = waterH(posxz.xz + vec2(0.0,-deltaPos));

	float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	vec3 newnormal = normalize(vec3(xDelta,yDelta,1.0-pow(abs(xDelta+yDelta),2.0)));

	vec4 frag2;
		frag2 = vec4((normal) * 0.5f + 0.5f, 1.0f);

	if (iswater > 0.9) {
		vec3 bump = newnormal;
			bump = bump;


		float bumpmult = 0.03;

		bump = bump * vec3(bumpmult, bumpmult, bumpmult) + vec3(0.0f, 0.0f, 1.0f - bumpmult);
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							tangent.y, binormal.y, normal.y,
							tangent.z, binormal.z, normal.z);

		frag2 = vec4(normalize(bump * tbnMatrix) * 0.5 + 0.5, 1.0);
	}
	gl_FragData[0] = tex;
	gl_FragData[1] = frag2;
	gl_FragData[2] = vec4(lmcoord.t, mix(1.0,0.05,iswater), lmcoord.s, 1.0);
}
