#version 120

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

//#define WAVING_LEAVES
//#define WAVING_VINES
//#define WAVING_GRASS
//#define WAVING_WHEAT
//#define WAVING_FLOWERS
//#define WAVING_FIRE
//#define WAVING_LAVA
//#define WAVING_LILYPAD
//#define WAVING_NETHER_WART
//#define WAVING_DEAD_BUSH
//#define WAVING_POTATO_AND_CARROT
//#define WAVING_COBWEB
//#define WAVING_LARGE_FERN
//#define WAVING_FERN


#define ENTITY_LEAVES        18.0
#define ENTITY_VINES        106.0
#define ENTITY_TALLGRASS     31.0
#define ENTITY_DANDELION     37.0
#define ENTITY_ROSE          38.0
#define ENTITY_WHEAT         59.0
#define ENTITY_LILYPAD      111.0
#define ENTITY_FIRE          51.0
#define ENTITY_LAVAFLOWING   10.0
#define ENTITY_LAVASTILL     11.0
#define ENTITY_LEAVES2		161.0
#define ENTITY_NEWFLOWERS	175.0
#define ENTITY_NETHER_WART	115.0
#define ENTITY_DEAD_BUSH	 32.0
#define ENTITY_CARROT		141.0
#define ENTITY_POTATO		142.0
#define ENTITY_COBWEB		 30.0
#define ENTITY_LARGE_FERN	175.3
#define ENTITY_FERN			 31.2

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES

#define SHADOW_MAP_BIAS 0.8

const float PI = 3.1415927;

varying vec4 texcoord;

varying vec3 worldpos;

varying float iswater;

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

uniform float frameTimeCounter;
uniform float rainStrength;
uniform vec3 cameraPosition;
uniform mat4 shadowProjectionInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowModelView;
uniform int worldTime;

float timefract = worldTime;

float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;

float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float pi2wt = PI*2*(frameTimeCounter*24);

vec3 calcWave(in vec3 pos, in float fm, in float mm, in float ma, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5) {
    vec3 ret;
    float magnitude,d0,d1,d2,d3;
    magnitude = sin(pi2wt*fm + pos.x*0.5 + pos.z*0.5 + pos.y*0.5) * mm + ma;
    d0 = sin(pi2wt*f0);
    d1 = sin(pi2wt*f1);
    d2 = sin(pi2wt*f2);
    ret.x = sin(pi2wt*f3 + d0 + d1 - pos.x + pos.z + pos.y) * magnitude;
    ret.z = sin(pi2wt*f4 + d1 + d2 + pos.x - pos.z + pos.y) * magnitude;
	ret.y = sin(pi2wt*f5 + d2 + d0 + pos.z + pos.y - pos.y) * magnitude;
    return ret;
}

vec3 calcMove(in vec3 pos, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5, in vec3 amp1, in vec3 amp2) {
    vec3 move1 = calcWave(pos      , 0.0027, 0.0400, 0.0400, 0.0127, 0.0089, 0.0114, 0.0063, 0.0224, 0.0015) * amp1;
	vec3 move2 = calcWave(pos+move1, 0.0348, 0.0400, 0.0400, f0, f1, f2, f3, f4, f5) * amp2;
    return move1+move2;
}
/*
vec3 calcWave(in vec3 pos, in float fm, in float mm, in float ma, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5)
{
    vec3 ret;
    float magnitude,d0,d1,d2,d3;
    magnitude = sin(pi2ft*fm + pos.x*0.5 + pos.z*0.5 + pos.y*0.5) * mm + ma;
    d0 = sin(pi2ft*f0);
    d1 = sin(pi2ft*f1);
    d2 = sin(pi2ft*f2);
    ret.x = sin(pi2ft*f3 + d0 + d1 - pos.x + pos.z + pos.y) * magnitude;
    ret.z = sin(pi2ft*f4 + d1 + d2 + pos.x - pos.z + pos.y) * magnitude;
	ret.y = sin(pi2ft*f5 + d2 + d0 + pos.z + pos.y - pos.y) * magnitude;
    return ret;
}

vec3 calcMove(in vec3 pos, in float f1, in float f2, in float f3, in float f4, in vec3 amp1, in vec3 amp2)
{
/*
    const vec3 v1 = vec3( 2.0/16.0,2.0/16.0,2.0/16.0);
	const vec3 v2 = vec3(-3.0/16.0,3.0/16.0,3.0/16.0);
	float pi2t = PI*frameTimeCounter;
	float s1 = sin(pi2t*f1 + dot(2*PI*v1,pos));
	float s2 = sin(pi2t*f2 + dot(2*PI*v2,pos));
	vec3 move1 = (normalize(v1)*s1 + normalize(v2)*s2)*amp1*2.5;
	pos += move1;
    const vec3 v3 = vec3( 5.0/16.0,5.0/16.0,6.0/16.0);
	const vec3 v4 = vec3(-6.0/16.0,5.0/16.0,5.0/16.0);
	float s3 = sin(pi2t*f3 + dot(2*PI*v3,pos));
	float s4 = sin(pi2t*f4 + dot(2*PI*v4,pos));
	vec3 move2 = (normalize(v3)*s3 + normalize(v4)*s4)*(abs(s1*s2)*0.6+0.4)*amp2*2.5;
    return move1+move2;


}
*/
vec3 calcWaterMove(in vec3 pos)
{
	float fy = fract(pos.y + 0.001);
	if (fy > 0.002)
	{
		float wave = 0.05 * sin(2*PI/4*frameTimeCounter + 2*PI*2/16*pos.x + 2*PI*5/16*pos.z)
				   + 0.05 * sin(2*PI/3*frameTimeCounter - 2*PI*3/16*pos.x + 2*PI*4/16*pos.z);
		return vec3(0, clamp(wave, -fy, 1.0-fy), 0);
	}
	else
	{
		return vec3(0);
	}
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	gl_Position = ftransform();

	vec4 position = gl_Position;

  if(mc_Entity.x == 8.0 || mc_Entity.x == 9.0) iswater = 1.0; else iswater = 0.0;

	position = shadowProjectionInverse * position;
	position = shadowModelViewInverse * position;

  worldpos = position.xyz;

    vec2 lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
	float underCover = lmcoord.t;
	underCover = pow(underCover, 15.0);
	
	vec3 worldpos = position.xyz + cameraPosition;
	float mat = 1.0f;
	float istopv = 0.0;
	//texcoord = gl_MultiTexCoord0.xy;
	if (gl_MultiTexCoord0.t < mc_midTexCoord.t) istopv = 1.0;

	//initialize per-entity waving parameters
	float parm0;
	float parm1;
	float parm2;
	float parm3;
	float parm4;
	float parm5;
	vec3 ampl1,ampl2;
	ampl1 = vec3(0.0);
	ampl2 = vec3(0.0);

#ifdef WAVING_LEAVES
	if ( mc_Entity.x == ENTITY_LEAVES || mc_Entity.x == ENTITY_LEAVES2 || mc_Entity.x == ENTITY_NEWFLOWERS ) {
			parm0 = 0.0030;
			parm1 = 0.0054;
			parm2 = 0.0033;
			parm3 = 0.0025;
			parm4 = 0.0017;
			parm5 = 0.0031;
			ampl1 = vec3(0.75,0.15,0.75+rainx*+1.0 +TimeMidnight*-1.0);
			ampl2 = vec3(0.375,0.075,0.375+rainx*+1.0 +TimeMidnight*-1.0);
			}
#endif

#ifdef WAVING_VINES
	if ( mc_Entity.x == ENTITY_VINES ) {
			parm0 = 0.0040;
			parm1 = 0.0064;
			parm2 = 0.0043;
			parm3 = 0.0035;
			parm4 = 0.0037;
			parm5 = 0.0041;
			ampl1 = vec3(0.5,0.1,0.5+rainx*+1.0 +TimeMidnight*-1.0);
			ampl2 = vec3(0.25,0.05,0.25+rainx*+1.0 +TimeMidnight*-1.0);
			}
			
#endif

#ifdef WAVING_COBWEB
	if ( mc_Entity.x == ENTITY_COBWEB ) {
			parm0 = 0.0020*0.1;
			parm1 = 0.0024*0.1;
			parm2 = 0.0013*0.1;
			parm3 = 0.0045*0.1;
			parm4 = 0.0017*0.1;
			parm5 = 0.0011*0.1;
			ampl1 = vec3(0.5,0.2,0.5*0.1+rainx*+1.0 +TimeMidnight*-1.0)*0.3;
			ampl2 = vec3(0.25,0.05,0.25*0.1+rainx*+1.0 +TimeMidnight*-1.0)*0.3;
			}
			
#endif

#ifdef WAVING_LARGE_FERN
	if ( mc_Entity.x == ENTITY_LARGE_FERN ) {
			parm0 = 0.0020*0.1;
			parm1 = 0.0024*0.1;
			parm2 = 0.0013*0.1;
			parm3 = 0.0045*0.1;
			parm4 = 0.0017*0.1;
			parm5 = 0.0011*0.1;
			ampl1 = vec3(0.55,0.2,0.55*0.1+rainx*+1.0 +TimeMidnight*-1.0)*0.3;
			ampl2 = vec3(0.25,0.05,0.25*0.1+rainx*+1.0 +TimeMidnight*-1.0)*0.3;
			}
			
#endif

#ifdef WAVING_FERN
	if ( mc_Entity.x == ENTITY_FERN ) {
			parm0 = 0.0020*0.1;
			parm1 = 0.0024*0.1;
			parm2 = 0.0013*0.1;
			parm3 = 0.0045*0.1;
			parm4 = 0.0017*0.1;
			parm5 = 0.0011*0.1;
			ampl1 = vec3(0.35,0.2,0.35*0.1+rainx*+1.0 +TimeMidnight*-1.0)*0.3;
			ampl2 = vec3(0.25,0.05,0.25*0.1+rainx*+1.0 +TimeMidnight*-1.0)*0.3;
			}
			
#endif

			if (istopv > 0.9) {
#ifdef WAVING_GRASS
	if ( mc_Entity.x == ENTITY_TALLGRASS) {
			parm0 = 0.0082;
			parm1 = 0.0140;
			parm2 = 0.0088;
			parm3 = 0.0075;
			parm4 = 0.002126;
			parm5 = 0.0;
			ampl1 = vec3(1.6,0.0,1.6+rainx*+1.0 +TimeMidnight*-1.0);
			ampl2 = vec3(0.8,0.0,0.8+rainx*+1.0 +TimeMidnight*-1.0);
			}			
#endif
	
#ifdef WAVING_FLOWERS
	if ((mc_Entity.x == ENTITY_DANDELION || mc_Entity.x == ENTITY_ROSE)) {
			parm0 = 0.0041;
			parm1 = 0.005;
			parm2 = 0.0044;
			parm3 = 0.0038;
			parm4 = 0.0240;
			parm5 = 0.0;
			ampl1 = vec3(0.8,0.0,0.8+rainx*+1.0 +TimeMidnight*-1.0);
			ampl2 = vec3(0.4,0.0,0.4+rainx*+1.0 +TimeMidnight*-1.0);
			}
#endif
	
#ifdef WAVING_WHEAT
	if ( mc_Entity.x == ENTITY_WHEAT) {
			parm0 = 0.0041;
			parm1 = 0.0070;
			parm2 = 0.0044;
			parm3 = 0.0240;
			parm4 = 0.0063;
			parm5 = 0.0;
			ampl1 = vec3(0.8,0.0,0.8+rainx*+1.0 +TimeMidnight*-1.0);
			ampl2 = vec3(0.4,0.0,0.4+rainx*+1.0 +TimeMidnight*-1.0);
			}
#endif
	
#ifdef WAVING_FIRE
	if ( mc_Entity.x == ENTITY_FIRE) {
			parm0 = 0.0105;
			parm1 = 0.0096;
			parm2 = 0.0087;
			parm3 = 0.0063;
			parm4 = 0.0097;
			parm5 = 0.0156;
			ampl1 = vec3(4.8,1.6,4.8+rainx*+1.0 +TimeMidnight*-1.0);
			ampl2 = vec3(2.4,0.8,2.4+rainx*+1.0 +TimeMidnight*-1.0);
			}				
#endif

#ifdef WAVING_NETHER_WART
	if ( mc_Entity.x == ENTITY_NETHER_WART ) {
			parm0 = 0.0040;
			parm1 = 0.0064;
			parm2 = 0.0043;
			parm3 = 0.0035;
			parm4 = 0.0037;
			parm5 = 0.0041;
			ampl1 = vec3(1.0,0.2,1.0+rainx*+1.0 +TimeMidnight*-1.0);
			ampl2 = vec3(0.5,0.1,0.5+rainx*+1.0 +TimeMidnight*-1.0);
			}
			
#endif

#ifdef WAVING_DEAD_BUSH
	if ( mc_Entity.x == ENTITY_DEAD_BUSH ) {
			parm0 = 0.0020;
			parm1 = 0.0032;
			parm2 = 0.0021;
			parm3 = 0.0016;
			parm4 = 0.0018;
			parm5 = 0.0020;
			ampl1 = vec3(2.0,0.4,2.0+rainx*+1.0 +TimeMidnight*-1.0);
			ampl2 = vec3(1.0,0.2,1.0+rainx*+1.0 +TimeMidnight*-1.0);
			}
			
#endif


#ifdef WAVING_POTATO_AND_CARROT
	if ( mc_Entity.x == ENTITY_CARROT || mc_Entity.x == ENTITY_POTATO) {
			parm0 = 0.0041;
			parm1 = 0.0070;
			parm2 = 0.0044;
			parm3 = 0.0240;
			parm4 = 0.0063;
			parm5 = 0.0;
			ampl1 = vec3(0.7,0.0,0.7+rainx*+1.0 +TimeMidnight*-1.0);
			ampl2 = vec3(0.4,0.0,0.4+rainx*+1.0 +TimeMidnight*-1.0);
			}
#endif

}
			
	float movemult = 0.0;
	
	#ifdef WAVING_LAVA
	if ( mc_Entity.x == ENTITY_LAVAFLOWING || mc_Entity.x == ENTITY_LAVASTILL ) {
			mat = 0.4;
			position.xyz += calcWaterMove(worldpos.xyz) * 0.25;
			}
	#endif
	#ifdef WAVING_LILYPAD
	if ( mc_Entity.x == ENTITY_LILYPAD ) {
			position.xyz += calcWaterMove(worldpos.xyz);
			mat = 0.4;
			}
	#endif
	
	position.xyz += calcWaterMove(worldpos.xyz) * movemult;
	position.xyz += calcMove(worldpos.xyz, parm0, parm1, parm2, parm3, parm4, parm5, ampl1, ampl2)* underCover;
	
	position = shadowModelView * position;
	position = shadowProjection * position;



	float dist = sqrt(gl_Position.x * gl_Position.x + gl_Position.y * gl_Position.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
	
	gl_Position.xy *= 1.0f / distortFactor;
	
	texcoord = gl_MultiTexCoord0;

	gl_FrontColor = gl_Color;
}
