/*
 * Decompiled with CFR 0.152.
 */
package alexndr.plugins.SimpleOres;

import alexndr.api.content.inventory.SimpleTab;
import alexndr.api.core.ContentTypes;
import alexndr.api.core.LogHelper;
import alexndr.api.core.UpdateChecker;
import alexndr.api.helpers.game.OreGenerator;
import alexndr.api.helpers.game.SimpleBucketType;
import alexndr.api.helpers.game.StatTriggersHelper;
import alexndr.plugins.SimpleOres.Content;
import alexndr.plugins.SimpleOres.ModInfo;
import alexndr.plugins.SimpleOres.Recipes;
import alexndr.plugins.SimpleOres.Settings;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="simpleores", name="SimpleOres 2", version="1.6.0", dependencies="required-after:simplecore")
public class SimpleOres {
    public static Item.ToolMaterial toolCopper;
    public static Item.ToolMaterial toolTin;
    public static Item.ToolMaterial toolMythril;
    public static Item.ToolMaterial toolAdamantium;
    public static Item.ToolMaterial toolOnyx;
    public static ItemArmor.ArmorMaterial armorCopper;
    public static ItemArmor.ArmorMaterial armorTin;
    public static ItemArmor.ArmorMaterial armorMythril;
    public static ItemArmor.ArmorMaterial armorAdamantium;
    public static ItemArmor.ArmorMaterial armorOnyx;
    public static SimpleBucketType copperBucketType;
    public static SimpleTab simpleOresBlocks;
    public static SimpleTab simpleOresDecorations;
    public static SimpleTab simpleOresMaterials;
    public static SimpleTab simpleOresTools;
    public static SimpleTab simpleOresCombat;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        LogHelper.info((String)"Loading SimpleOres...");
        ModInfo.setModInfoProperties(event);
        Settings.createOrLoadSettings(event);
        if (Settings.updateChecker.asBoolean()) {
            UpdateChecker updateChecker = new UpdateChecker("simpleores", "1.6.0", "https://dl.dropboxusercontent.com/u/66466201/Mods/SimpleOres%202/SimpleOres%202%20Version.txt");
        }
        SimpleOres.tabPreInit();
        SimpleOres.setToolAndArmorStats();
        Content.preInitialize();
        Recipes.preInitialize();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        Recipes.initialize();
        SimpleOres.tabInit();
        SimpleOres.setBucketVariants();
        SimpleOres.setRepairMaterials();
        SimpleOres.setAchievementTriggers();
        SimpleOres.setOreGenSettings();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LogHelper.info((String)"SimpleOres loaded");
    }

    private static void setAchievementTriggers() {
        StatTriggersHelper.addPickupTrigger((ItemStack)new ItemStack(Content.copper_ore), (Achievement)Content.copperAch);
        StatTriggersHelper.addPickupTrigger((ItemStack)new ItemStack(Content.tin_ore), (Achievement)Content.tinAch);
        StatTriggersHelper.addPickupTrigger((ItemStack)new ItemStack(Content.mythril_ore), (Achievement)Content.mythrilAch);
        StatTriggersHelper.addPickupTrigger((ItemStack)new ItemStack(Content.adamantium_ore), (Achievement)Content.adamantiumAch);
        StatTriggersHelper.addPickupTrigger((ItemStack)new ItemStack(Content.onyx_gem), (Achievement)Content.onyxAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.copper_pickaxe), (Achievement)Content.copperPickAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.copper_bucket), (Achievement)Content.copperBucketAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.tin_chestplate), (Achievement)Content.tinChestplateAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.tin_shears), (Achievement)Content.tinShearsAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.mythril_axe), (Achievement)Content.mythrilAxeAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.mythril_bow), (Achievement)Content.mythrilBowAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.adamantium_leggings), (Achievement)Content.adamantiumLegsAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.adamantium_shears), (Achievement)Content.adamantiumShearsAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.onyx_sword), (Achievement)Content.onyxSwordAch);
        StatTriggersHelper.addCraftingTrigger((ItemStack)new ItemStack(Content.onyx_bow), (Achievement)Content.onyxBowAch);
        StatTriggersHelper.addSmeltingTrigger((ItemStack)new ItemStack(Content.onyx_gem), (Achievement)Content.onyxAch);
    }

    private static void setBucketVariants() {
        copperBucketType.setVariant(Blocks.field_150350_a, Content.copper_bucket, "empty").setVariant(Blocks.field_150355_j, Content.copper_bucket_water, "water").setDestroyIfNoLavaBucket(true);
    }

    private static void setOreGenSettings() {
        OreGenerator.INSTANCE.registerOreForGeneration(0, Content.copper_ore, Blocks.field_150348_b, Settings.copperOre.getVeinSize(), Settings.copperOre.getSpawnRate(), Settings.copperOre.getMaxHeight(), Settings.copperOre.getMinHeight());
        OreGenerator.INSTANCE.registerOreForGeneration(0, Content.tin_ore, Blocks.field_150348_b, Settings.tinOre.getVeinSize(), Settings.tinOre.getSpawnRate(), Settings.tinOre.getMaxHeight(), Settings.tinOre.getMinHeight());
        OreGenerator.INSTANCE.registerOreForGeneration(0, Content.mythril_ore, Blocks.field_150348_b, Settings.mythrilOre.getVeinSize(), Settings.mythrilOre.getSpawnRate(), Settings.mythrilOre.getMaxHeight(), Settings.mythrilOre.getMinHeight());
        OreGenerator.INSTANCE.registerOreForGeneration(0, Content.adamantium_ore, Blocks.field_150348_b, Settings.adamantiumOre.getVeinSize(), Settings.adamantiumOre.getSpawnRate(), Settings.adamantiumOre.getMaxHeight(), Settings.adamantiumOre.getMinHeight());
        OreGenerator.INSTANCE.registerOreForGeneration(-1, Content.onyx_ore, Blocks.field_150424_aL, Settings.onyxOre.getVeinSize(), Settings.onyxOre.getSpawnRate(), Settings.onyxOre.getMaxHeight(), Settings.onyxOre.getMinHeight());
    }

    private static void setRepairMaterials() {
        toolCopper.setRepairItem(new ItemStack(Content.copper_ingot));
        toolTin.setRepairItem(new ItemStack(Content.tin_ingot));
        toolMythril.setRepairItem(new ItemStack(Content.mythril_ingot));
        toolAdamantium.setRepairItem(new ItemStack(Content.adamantium_ingot));
        toolOnyx.setRepairItem(new ItemStack(Content.onyx_gem));
        SimpleOres.armorCopper.customCraftingMaterial = Content.copper_ingot;
        SimpleOres.armorTin.customCraftingMaterial = Content.tin_ingot;
        SimpleOres.armorMythril.customCraftingMaterial = Content.mythril_ingot;
        SimpleOres.armorAdamantium.customCraftingMaterial = Content.adamantium_ingot;
        SimpleOres.armorOnyx.customCraftingMaterial = Content.onyx_gem;
    }

    private static void setToolAndArmorStats() {
        toolCopper = EnumHelper.addToolMaterial((String)"COPPER", (int)Settings.copperTools.getMiningLevel(), (int)Settings.copperTools.getUses(), (float)Settings.copperTools.getMiningSpeed(), (float)Settings.copperTools.getDamageVsEntity(), (int)Settings.copperTools.getEnchantability());
        toolTin = EnumHelper.addToolMaterial((String)"TIN", (int)Settings.tinTools.getMiningLevel(), (int)Settings.tinTools.getUses(), (float)Settings.tinTools.getMiningSpeed(), (float)Settings.tinTools.getDamageVsEntity(), (int)Settings.tinTools.getEnchantability());
        toolMythril = EnumHelper.addToolMaterial((String)"MYTHRIL", (int)Settings.mythrilTools.getMiningLevel(), (int)Settings.mythrilTools.getUses(), (float)Settings.mythrilTools.getMiningSpeed(), (float)Settings.mythrilTools.getDamageVsEntity(), (int)Settings.mythrilTools.getEnchantability());
        toolAdamantium = EnumHelper.addToolMaterial((String)"ADAMANTIUM", (int)Settings.adamantiumTools.getMiningLevel(), (int)Settings.adamantiumTools.getUses(), (float)Settings.adamantiumTools.getMiningSpeed(), (float)Settings.adamantiumTools.getDamageVsEntity(), (int)Settings.adamantiumTools.getEnchantability());
        toolOnyx = EnumHelper.addToolMaterial((String)"ONYX", (int)Settings.onyxTools.getMiningLevel(), (int)Settings.onyxTools.getUses(), (float)Settings.onyxTools.getMiningSpeed(), (float)Settings.onyxTools.getDamageVsEntity(), (int)Settings.onyxTools.getEnchantability());
        armorCopper = EnumHelper.addArmorMaterial((String)"COPPER", (int)Settings.copperArmor.getDurability(), (int[])new int[]{Settings.copperArmor.getHelmetReduction(), Settings.copperArmor.getChestplateReduction(), Settings.copperArmor.getLeggingsReduction(), Settings.copperArmor.getBootsReduction()}, (int)Settings.copperArmor.getEnchantability());
        armorTin = EnumHelper.addArmorMaterial((String)"TIN", (int)Settings.tinArmor.getDurability(), (int[])new int[]{Settings.tinArmor.getHelmetReduction(), Settings.tinArmor.getChestplateReduction(), Settings.tinArmor.getLeggingsReduction(), Settings.tinArmor.getBootsReduction()}, (int)Settings.tinArmor.getEnchantability());
        armorMythril = EnumHelper.addArmorMaterial((String)"MYTHRIL", (int)Settings.mythrilArmor.getDurability(), (int[])new int[]{Settings.mythrilArmor.getHelmetReduction(), Settings.mythrilArmor.getChestplateReduction(), Settings.mythrilArmor.getLeggingsReduction(), Settings.mythrilArmor.getBootsReduction()}, (int)Settings.mythrilArmor.getEnchantability());
        armorAdamantium = EnumHelper.addArmorMaterial((String)"ADAMANTIUM", (int)Settings.adamantiumArmor.getDurability(), (int[])new int[]{Settings.adamantiumArmor.getHelmetReduction(), Settings.adamantiumArmor.getChestplateReduction(), Settings.adamantiumArmor.getLeggingsReduction(), Settings.adamantiumArmor.getBootsReduction()}, (int)Settings.adamantiumArmor.getEnchantability());
        armorOnyx = EnumHelper.addArmorMaterial((String)"ONYX", (int)Settings.onyxArmor.getDurability(), (int[])new int[]{Settings.onyxArmor.getHelmetReduction(), Settings.onyxArmor.getChestplateReduction(), Settings.onyxArmor.getLeggingsReduction(), Settings.onyxArmor.getBootsReduction()}, (int)Settings.onyxArmor.getEnchantability());
    }

    private static void tabInit() {
        if (Settings.tabs.asBoolean()) {
            simpleOresBlocks.setIcon(new ItemStack(Content.copper_ore));
            if (Settings.separateTabs.asBoolean()) {
                simpleOresDecorations.setIcon(new ItemStack(Content.adamantium_block));
                simpleOresMaterials.setIcon(new ItemStack(Content.mythril_ingot));
                simpleOresTools.setIcon(new ItemStack(Content.onyx_pickaxe));
                simpleOresCombat.setIcon(new ItemStack(Content.tin_sword));
            }
        }
    }

    private static void tabPreInit() {
        if (Settings.tabs.asBoolean()) {
            simpleOresBlocks = new SimpleTab("simpleOresBlocks", ContentTypes.CreativeTab.BLOCKS);
            if (Settings.separateTabs.asBoolean()) {
                simpleOresDecorations = new SimpleTab("simpleOresDecorations", ContentTypes.CreativeTab.DECORATIONS);
                simpleOresMaterials = new SimpleTab("simpleOresMaterials", ContentTypes.CreativeTab.MATERIALS);
                simpleOresTools = new SimpleTab("simpleOresTools", ContentTypes.CreativeTab.TOOLS);
                simpleOresCombat = new SimpleTab("simpleOresCombat", ContentTypes.CreativeTab.COMBAT);
            }
        }
    }

    static {
        copperBucketType = new SimpleBucketType("copper");
    }
}

