/*
 * Decompiled with CFR 0.152.
 */
package alexndr.plugins.SimpleOres;

import alexndr.api.content.items.SimpleBucketType;
import alexndr.api.core.SimpleCoreAPI;
import alexndr.api.core.UpdateChecker;
import alexndr.api.helpers.game.OreGenerator;
import alexndr.api.helpers.game.RenderItemHelper;
import alexndr.api.helpers.game.StatTriggersHelper;
import alexndr.api.logger.LogHelper;
import alexndr.api.registry.ContentRegistry;
import alexndr.api.registry.Plugin;
import alexndr.plugins.SimpleOres.Content;
import alexndr.plugins.SimpleOres.ModInfo;
import alexndr.plugins.SimpleOres.Recipes;
import alexndr.plugins.SimpleOres.Settings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="simpleores", name="SimpleOres 2", version="1.7.1", dependencies="required-after:simplecore", acceptedMinecraftVersions="[1.8]")
public class SimpleOres {
    public static Plugin plugin = new Plugin("simpleores", "SimpleOres 2");
    public static Item.ToolMaterial toolCopper;
    public static Item.ToolMaterial toolTin;
    public static Item.ToolMaterial toolMythril;
    public static Item.ToolMaterial toolAdamantium;
    public static Item.ToolMaterial toolOnyx;
    public static ItemArmor.ArmorMaterial armorCopper;
    public static ItemArmor.ArmorMaterial armorTin;
    public static ItemArmor.ArmorMaterial armorMythril;
    public static ItemArmor.ArmorMaterial armorAdamantium;
    public static ItemArmor.ArmorMaterial armorOnyx;
    public static SimpleBucketType copperBucketType;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LogHelper.info((String)"SimpleOres 2", (String)"Loading...");
        ContentRegistry.registerPlugin((Plugin)plugin);
        ModInfo.setModInfoProperties(event);
        Settings.createOrLoadSettings(event);
        if (Settings.updateChecker.asBoolean()) {
            UpdateChecker updateChecker = new UpdateChecker("simpleores", "1.7.1", "https://dl.dropboxusercontent.com/u/66466201/Mods/SimpleOres%202/SimpleOres%202%20Version.txt");
        }
        SimpleOres.setToolAndArmorStats();
        Content.preInitialize();
        Recipes.preInitialize();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RenderItemHelper.renderItemsAndBlocks((Plugin)plugin);
        Recipes.initialize();
        SimpleOres.setTabIcons();
        SimpleOres.setRepairMaterials();
        SimpleOres.setBucketVariants();
        SimpleOres.setAchievementTriggers();
        SimpleOres.setOreGenSettings();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LogHelper.info((String)"SimpleOres 2", (String)"Loading Complete!");
    }

    private static void setToolAndArmorStats() {
        LogHelper.verbose((String)"SimpleOres 2", (String)"Setting Tool and Armor stats");
        toolCopper = EnumHelper.addToolMaterial((String)"COPPER", (int)Settings.copperTools.getHarvestLevel(), (int)Settings.copperTools.getUses(), (float)Settings.copperTools.getHarvestSpeed(), (float)Settings.copperTools.getDamageVsEntity(), (int)Settings.copperTools.getEnchantability());
        toolTin = EnumHelper.addToolMaterial((String)"TIN", (int)Settings.tinTools.getHarvestLevel(), (int)Settings.tinTools.getUses(), (float)Settings.tinTools.getHarvestSpeed(), (float)Settings.tinTools.getDamageVsEntity(), (int)Settings.tinTools.getEnchantability());
        toolMythril = EnumHelper.addToolMaterial((String)"MYTHRIL", (int)Settings.mythrilTools.getHarvestLevel(), (int)Settings.mythrilTools.getUses(), (float)Settings.mythrilTools.getHarvestSpeed(), (float)Settings.mythrilTools.getDamageVsEntity(), (int)Settings.mythrilTools.getEnchantability());
        toolAdamantium = EnumHelper.addToolMaterial((String)"ADAMANTIUM", (int)Settings.adamantiumTools.getHarvestLevel(), (int)Settings.adamantiumTools.getUses(), (float)Settings.adamantiumTools.getHarvestSpeed(), (float)Settings.adamantiumTools.getDamageVsEntity(), (int)Settings.adamantiumTools.getEnchantability());
        toolOnyx = EnumHelper.addToolMaterial((String)"ONYX", (int)Settings.onyxTools.getHarvestLevel(), (int)Settings.onyxTools.getUses(), (float)Settings.onyxTools.getHarvestSpeed(), (float)Settings.onyxTools.getDamageVsEntity(), (int)Settings.onyxTools.getEnchantability());
        armorCopper = EnumHelper.addArmorMaterial((String)"COPPER", (String)"copper", (int)Settings.copperArmor.getDurability(), (int[])new int[]{Settings.copperArmor.getHelmReduction(), Settings.copperArmor.getChestReduction(), Settings.copperArmor.getLegsReduction(), Settings.copperArmor.getBootsReduction()}, (int)Settings.copperArmor.getEnchantability());
        armorTin = EnumHelper.addArmorMaterial((String)"TIN", (String)"tin", (int)Settings.tinArmor.getDurability(), (int[])new int[]{Settings.tinArmor.getHelmReduction(), Settings.tinArmor.getChestReduction(), Settings.tinArmor.getLegsReduction(), Settings.tinArmor.getBootsReduction()}, (int)Settings.tinArmor.getEnchantability());
        armorMythril = EnumHelper.addArmorMaterial((String)"MYTHRIL", (String)"mythril", (int)Settings.mythrilArmor.getDurability(), (int[])new int[]{Settings.mythrilArmor.getHelmReduction(), Settings.mythrilArmor.getChestReduction(), Settings.mythrilArmor.getLegsReduction(), Settings.mythrilArmor.getBootsReduction()}, (int)Settings.mythrilArmor.getEnchantability());
        armorAdamantium = EnumHelper.addArmorMaterial((String)"ADAMANTIUM", (String)"adamantium", (int)Settings.adamantiumArmor.getDurability(), (int[])new int[]{Settings.adamantiumArmor.getHelmReduction(), Settings.adamantiumArmor.getChestReduction(), Settings.adamantiumArmor.getLegsReduction(), Settings.adamantiumArmor.getBootsReduction()}, (int)Settings.adamantiumArmor.getEnchantability());
        armorOnyx = EnumHelper.addArmorMaterial((String)"ONYX", (String)"onyx", (int)Settings.onyxArmor.getDurability(), (int[])new int[]{Settings.onyxArmor.getHelmReduction(), Settings.onyxArmor.getChestReduction(), Settings.onyxArmor.getLegsReduction(), Settings.onyxArmor.getBootsReduction()}, (int)Settings.onyxArmor.getEnchantability());
    }

    private static void setTabIcons() {
        LogHelper.verbose((String)"SimpleOres 2", (String)"Setting tab icons");
        ArrayList list = Lists.newArrayList((Object[])new Item[]{Item.func_150898_a((Block)Content.copper_ore), Item.func_150898_a((Block)Content.adamantium_block), Content.mythril_ingot, Content.onyx_pickaxe, Content.copper_sword});
        SimpleCoreAPI.setTabIcons((List)list);
    }

    private static void setRepairMaterials() {
        LogHelper.verbose((String)"SimpleOres 2", (String)"Setting Tool and Armor repair materials");
        toolCopper.setRepairItem(new ItemStack(Content.copper_ingot));
        toolTin.setRepairItem(new ItemStack(Content.tin_ingot));
        toolMythril.setRepairItem(new ItemStack(Content.mythril_ingot));
        toolAdamantium.setRepairItem(new ItemStack(Content.adamantium_ingot));
        toolOnyx.setRepairItem(new ItemStack(Content.onyx_gem));
        SimpleOres.armorCopper.customCraftingMaterial = Content.copper_ingot;
        SimpleOres.armorTin.customCraftingMaterial = Content.tin_ingot;
        SimpleOres.armorMythril.customCraftingMaterial = Content.mythril_ingot;
        SimpleOres.armorAdamantium.customCraftingMaterial = Content.adamantium_ingot;
        SimpleOres.armorOnyx.customCraftingMaterial = Content.onyx_gem;
    }

    private static void setBucketVariants() {
        LogHelper.verbose((String)"SimpleOres 2", (String)"Setting bucket variants");
        copperBucketType.addVariant("empty", Content.copper_bucket, Blocks.field_150350_a).addVariant("water", Content.copper_bucket_water, (Block)Blocks.field_150355_j).setDestroyOnLava(true);
    }

    private static void setAchievementTriggers() {
        LogHelper.verbose((String)"SimpleOres 2", (String)"Setting achievement triggers");
        StatTriggersHelper.addPickupTrigger((Item)Item.func_150898_a((Block)Content.copper_ore), (Achievement)Content.copperAch);
        StatTriggersHelper.addPickupTrigger((Item)Item.func_150898_a((Block)Content.tin_ore), (Achievement)Content.tinAch);
        StatTriggersHelper.addPickupTrigger((Item)Item.func_150898_a((Block)Content.mythril_ore), (Achievement)Content.mythrilAch);
        StatTriggersHelper.addPickupTrigger((Item)Item.func_150898_a((Block)Content.adamantium_ore), (Achievement)Content.adamantiumAch);
        StatTriggersHelper.addPickupTrigger((Item)Content.onyx_gem, (Achievement)Content.onyxAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.copper_pickaxe, (Achievement)Content.copperPickAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.copper_bucket, (Achievement)Content.copperBucketAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.tin_chestplate, (Achievement)Content.tinChestplateAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.tin_shears, (Achievement)Content.tinShearsAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.mythril_axe, (Achievement)Content.mythrilAxeAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.mythril_bow, (Achievement)Content.mythrilBowAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.adamantium_leggings, (Achievement)Content.adamantiumLegsAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.adamantium_shears, (Achievement)Content.adamantiumShearsAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.onyx_sword, (Achievement)Content.onyxSwordAch);
        StatTriggersHelper.addCraftingTrigger((Item)Content.onyx_bow, (Achievement)Content.onyxBowAch);
        StatTriggersHelper.addSmeltingTrigger((Item)Content.onyx_gem, (Achievement)Content.onyxAch);
    }

    private static void setOreGenSettings() {
        LogHelper.verbose((String)"SimpleOres 2", (String)"Setting ore gen parameters");
        OreGenerator.registerOreForGen((int)0, (Block)Content.copper_ore, (Block)Blocks.field_150348_b, (int)Settings.copperOre.getSpawnRate(), (int)Settings.copperOre.getVeinSize(), (int)Settings.copperOre.getMinHeight(), (int)Settings.copperOre.getMaxHeight());
        OreGenerator.registerOreForGen((int)0, (Block)Content.tin_ore, (Block)Blocks.field_150348_b, (int)Settings.tinOre.getSpawnRate(), (int)Settings.tinOre.getVeinSize(), (int)Settings.tinOre.getMinHeight(), (int)Settings.tinOre.getMaxHeight());
        OreGenerator.registerOreForGen((int)0, (Block)Content.mythril_ore, (Block)Blocks.field_150348_b, (int)Settings.mythrilOre.getSpawnRate(), (int)Settings.mythrilOre.getVeinSize(), (int)Settings.mythrilOre.getMinHeight(), (int)Settings.mythrilOre.getMaxHeight());
        OreGenerator.registerOreForGen((int)0, (Block)Content.adamantium_ore, (Block)Blocks.field_150348_b, (int)Settings.adamantiumOre.getSpawnRate(), (int)Settings.adamantiumOre.getVeinSize(), (int)Settings.adamantiumOre.getMinHeight(), (int)Settings.adamantiumOre.getMaxHeight());
        OreGenerator.registerOreForGen((int)-1, (Block)Content.onyx_ore, (Block)Blocks.field_150424_aL, (int)Settings.onyxOre.getSpawnRate(), (int)Settings.onyxOre.getVeinSize(), (int)Settings.onyxOre.getMinHeight(), (int)Settings.onyxOre.getMaxHeight());
    }

    static {
        copperBucketType = new SimpleBucketType("copper");
    }
}

