/*
 * Decompiled with CFR 0.152.
 */
package animalium.entities;

import animalium.Animalium;
import animalium.configs.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBear
extends EntityMob {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityBear.class, (DataSerializer)DataSerializers.field_187198_h);
    public float standingAngle;
    public float prevStandingAngle;

    public EntityBear(World world) {
        super(world);
        this.func_70105_a(2.0f, 2.0f);
        if (world != null && !world.field_72995_K) {
            if (ConfigHandler.BEAR_ATTACK_MOBS) {
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true, true, null));
            }
            if (ConfigHandler.BEAR_ATTACK_CREATURES) {
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, null));
            }
            this.field_70138_W = 2.0f;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    private void setIsStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIBearAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
    }

    public void func_70636_d() {
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_70638_az() != null) {
                this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 20.0f);
                double distance = this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
                if (distance > 5.0) {
                    this.setIsStanding(false);
                }
                if (distance <= 5.0) {
                    this.setIsStanding(true);
                }
            }
            if (this.func_70638_az() == null) {
                this.setIsStanding(false);
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            this.prevStandingAngle = this.standingAngle;
            if (this.standingAngle > 0.0f && !this.isStanding()) {
                this.standingAngle -= 0.1f;
            }
            if (this.isStanding() && this.standingAngle <= 1.0f) {
                this.standingAngle += 0.1f;
            }
            if (this.standingAngle < 0.0f && !this.isStanding()) {
                this.standingAngle = 0.0f;
            }
            if (this.isStanding() && this.standingAngle > 1.0f) {
                this.standingAngle = 1.0f;
            }
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public float smoothedAngle(float partialTicks) {
        return this.standingAngle + (this.standingAngle - this.prevStandingAngle) * partialTicks;
    }

    public boolean func_70686_a(Class entity) {
        return EntityBear.class != entity;
    }

    protected boolean func_70814_o() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return this.func_130014_f_().func_175642_b(EnumSkyBlock.BLOCK, blockpos) < 8;
    }

    public boolean func_70601_bi() {
        if (ConfigHandler.BEAR_SPAWN_ONLY_AT_DAY) {
            if (this.func_130014_f_().func_72935_r()) {
                return this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && this.func_70814_o() && this.func_70058_J() && this.field_70163_u <= (double)ConfigHandler.BEAR_SPAWN_Y_HEIGHT;
            }
            return false;
        }
        return this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && this.func_70814_o() && this.func_70058_J() && this.field_70163_u <= (double)ConfigHandler.BEAR_SPAWN_Y_HEIGHT;
    }

    public boolean func_70058_J() {
        return !this.func_130014_f_().func_72953_d(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70641_bl() {
        return 1;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int randomAmount = 1 + this.field_70146_Z.nextInt(2 + looting);
        for (int count = 0; count < randomAmount; ++count) {
            this.func_70099_a(new ItemStack(Animalium.BEAR_CLAW), 0.0f);
        }
        this.func_70099_a(new ItemStack(this.func_70027_ad() ? Animalium.BEAR_MEAT_COOKED : Animalium.BEAR_MEAT), 0.0f);
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            boolean hasHitTarget = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            if (hasHitTarget) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 3.141593f / 180.0f)) * 0.5f), 0.2, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * 3.141593f / 180.0f)) * 0.5f));
                if (!this.func_130014_f_().field_72995_K) {
                    this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_190031_ew, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
            return hasHitTarget;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    static class AIBearAttack
    extends EntityAIAttackMelee {
        public AIBearAttack(EntityBear bear) {
            super((EntityCreature)bear, 0.6, false);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

