/*
 * Decompiled with CFR 0.152.
 */
package animalium.entities;

import animalium.Animalium;
import animalium.configs.ConfigHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityRat
extends EntityMob {
    private EntityAIAttackMelee aiAttack;
    private EntityAIAvoidEntity<EntityLivingBase> aiRunAway;
    private EntityAINearestAttackableTarget<EntityPlayer> aiTarget;
    private static final DataParameter<Boolean> CAN_ATTACK = EntityDataManager.func_187226_a(EntityRat.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityRat(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.9f);
        if (world != null && !world.field_72995_K) {
            if (ConfigHandler.RAT_ATTACK_MOBS) {
                this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true, true, null));
            }
            if (ConfigHandler.RAT_ATTACK_CREATURES) {
                this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, null));
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CAN_ATTACK, (Object)false);
    }

    public boolean getCanAttack() {
        return (Boolean)this.field_70180_af.func_187225_a(CAN_ATTACK);
    }

    private void setCanAttack(boolean canAttack) {
        this.field_70180_af.func_187227_b(CAN_ATTACK, (Object)canAttack);
    }

    protected void func_184651_r() {
        this.aiAttack = new AIRatAttack(this);
        this.aiRunAway = new EntityAIAvoidEntity((EntityCreature)this, EntityLivingBase.class, 10.0f, 0.6, 0.6);
        this.aiTarget = new AIRatTarget<EntityPlayer>(this, EntityPlayer.class);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttack);
        this.field_70714_bg.func_75776_a(1, this.aiRunAway);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIRatAttack(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.65));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, this.aiTarget);
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.65);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && !this.getCanAttack()) {
                this.field_70714_bg.func_85156_a(this.aiRunAway);
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttack);
                this.field_70715_bh.func_75776_a(0, this.aiTarget);
                this.setCanAttack(true);
            }
            if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b() && this.getCanAttack()) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttack);
                this.field_70715_bh.func_85156_a(this.aiTarget);
                this.field_70714_bg.func_75776_a(1, this.aiRunAway);
                this.setCanAttack(false);
            }
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            boolean attacked = super.func_70652_k(entity);
            if (attacked && entity instanceof EntityPlayer && this.func_70681_au().nextInt(1) == 0) {
                ItemStack stack;
                EntityPlayer player = (EntityPlayer)entity;
                if (!this.func_130014_f_().field_72995_K && this.getCanAttack() && !(stack = player.func_184614_ca()).func_190926_b()) {
                    ItemStack stack2 = stack.func_77946_l();
                    if (stack.func_77942_o()) {
                        stack2.func_77982_d(stack.func_77978_p());
                    }
                    stack2.func_77979_a(stack.func_190916_E() - 1);
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack2);
                    this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.field_71071_by.func_184437_d(stack);
                    }
                }
            }
            return attacked;
        }
        return false;
    }

    public boolean func_70686_a(Class entity) {
        return EntityRat.class != entity;
    }

    protected boolean func_70814_o() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return this.func_130014_f_().func_175642_b(EnumSkyBlock.BLOCK, blockpos) < 8;
    }

    public boolean func_70601_bi() {
        return this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL && this.func_70814_o() && this.func_70058_J() && this.field_70163_u <= (double)ConfigHandler.RAT_SPAWN_Y_HEIGHT;
    }

    public boolean func_70058_J() {
        return !this.func_130014_f_().func_72953_d(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    protected boolean func_70692_ba() {
        return this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b();
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        ItemStack stack;
        if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
            stack = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
            this.func_70099_a(stack, 1.0f);
        }
        if (this.func_130014_f_().field_73012_v.nextInt(5) == 0) {
            stack = new ItemStack(Animalium.RAT_MEAT);
            if (this.func_70027_ad()) {
                stack = new ItemStack(Animalium.RAT_MEAT_COOKED);
            }
            this.func_70099_a(stack, 1.0f);
        }
    }

    protected float func_70647_i() {
        return 0.5f;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184601_bQ() {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187820_el;
    }

    static class AIRatTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIRatTarget(EntityRat rat, Class<T> classTarget) {
            super((EntityCreature)rat, classTarget, true);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c(1.0f);
            return f >= 0.5f ? false : super.func_75250_a();
        }
    }

    static class AIRatAttack
    extends EntityAIAttackMelee {
        private final EntityRat rat;

        public AIRatAttack(EntityRat rat) {
            super((EntityCreature)rat, 0.65, false);
            this.rat = rat;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.rat.getCanAttack();
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c(1.0f);
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0 || !this.rat.getCanAttack()) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

