/*
 * Decompiled with CFR 0.152.
 */
package animalium.entities;

import animalium.ModEntities;
import animalium.ModItems;
import animalium.configs.Config;
import animalium.entities.EntityDogPart;
import animalium.entities.ai.WildDogLeapAtTargetGoal;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class EntityWildDog
extends MonsterEntity {
    public EntityDogPart[] dogPartArray;
    public EntityDogPart dogPartHead = new EntityDogPart(this, "head", 0.5f, 0.5f);

    public EntityWildDog(EntityType<? extends EntityWildDog> type, World world) {
        super(type, world);
        this.dogPartArray = new EntityDogPart[]{this.dogPartHead};
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WildDogLeapAtTargetGoal((MobEntity)this, 0.5f));
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{PlayerEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        if (((Boolean)Config.WILD_DOG_ATTACK_MOBS.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, true));
        }
        if (((Boolean)Config.WILD_DOG_ATTACK_CREATURES.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, true));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return typeIn != ModEntities.WILD_DOG;
    }

    public static boolean isValidLightLevel(IWorld world, BlockPos pos) {
        return world.func_175642_b(LightType.BLOCK, pos) < 8;
    }

    public static boolean canSpawnHere(EntityType<EntityWildDog> entity, IWorld world, SpawnReason spawn_reason, BlockPos pos, Random random) {
        if (EntityWildDog.isDimBlacklisted(world.func_201675_m().func_186058_p().func_186068_a())) {
            return false;
        }
        return world.func_175659_aa() != Difficulty.PEACEFUL && EntityWildDog.isValidLightLevel(world, pos) && pos.func_177956_o() <= (Integer)Config.WILD_DOG_SPAWN_Y_HEIGHT.get();
    }

    public boolean func_205019_a(IWorldReader world) {
        return !world.func_72953_d(this.func_174813_aQ()) && world.func_217346_i((Entity)this);
    }

    public static boolean isDimBlacklisted(int dimensionIn) {
        return ((List)Config.WILD_DOG_BLACKLISTED_DIMS.get()).contains(dimensionIn);
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        if (this.func_130014_f_().field_73012_v.nextInt(5) == 0) {
            ItemStack stack = new ItemStack((IItemProvider)ModItems.WILD_DOG_PELT);
            if (this.func_70027_ad()) {
                stack = new ItemStack((IItemProvider)Items.field_151103_aS);
            }
            this.func_70099_a(stack, 1.0f);
        }
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187861_gG;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70761_aq = this.field_70177_z;
        double a = Math.toRadians(this.field_70177_z);
        double offSetX = -Math.sin(a) * -0.75;
        double offSetZ = Math.cos(a) * -0.75;
        this.dogPartHead.func_70012_b(this.field_70165_t - offSetX, this.field_70163_u + 0.7, this.field_70161_v - offSetZ, 0.0f, 0.0f);
    }

    public boolean attackEntityFromPart(EntityDogPart dogPart, DamageSource source, float damage) {
        if (source.func_76346_g() instanceof PlayerEntity || source.func_94541_c()) {
            this.attackDogFrom(source, damage);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
            this.attackEntityFromPart(this.dogPartHead, source, amount);
        }
        return this.attackDogFrom(source, amount);
    }

    protected boolean attackDogFrom(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(EntityWildDog dog) {
            super((CreatureEntity)dog, 0.6, false);
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }
}

