/*
 * Decompiled with CFR 0.152.
 */
package animalium.entities;

import animalium.ModEntities;
import animalium.ModItems;
import animalium.configs.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityBear
extends MonsterEntity {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityBear.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float standingAngle;
    public float prevStandingAngle;

    public EntityBear(EntityType<? extends EntityBear> type, World world) {
        super(type, world);
        this.field_70138_W = 2.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    private void setIsStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new TargetGoal<PlayerEntity>(this, PlayerEntity.class));
        if (((Boolean)Config.BEAR_ATTACK_MOBS.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(1, new TargetGoal<MonsterEntity>(this, MonsterEntity.class));
        }
        if (((Boolean)Config.BEAR_ATTACK_CREATURES.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(2, new TargetGoal<LivingEntity>(this, LivingEntity.class));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_70638_az() != null) {
                this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 20.0f);
                double distance = this.func_70032_d((Entity)this.func_70638_az());
                if (distance > 5.0) {
                    this.setIsStanding(false);
                }
                if (distance <= 5.0) {
                    this.setIsStanding(true);
                }
            }
            if (this.func_70638_az() == null) {
                this.setIsStanding(false);
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            this.prevStandingAngle = this.standingAngle;
            if (this.standingAngle > 0.0f && !this.isStanding()) {
                this.standingAngle -= 0.1f;
            }
            if (this.isStanding() && this.standingAngle <= 1.0f) {
                this.standingAngle += 0.1f;
            }
            if (this.standingAngle < 0.0f && !this.isStanding()) {
                this.standingAngle = 0.0f;
            }
            if (this.isStanding() && this.standingAngle > 1.0f) {
                this.standingAngle = 1.0f;
            }
        }
        super.func_70071_h_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float smoothedAngle(float partialTicks) {
        return this.standingAngle + (this.standingAngle - this.prevStandingAngle) * partialTicks;
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return typeIn != ModEntities.BEAR;
    }

    protected static boolean isValidLightLevel(IWorld world, BlockPos pos) {
        if (((Boolean)Config.BEAR_SPAWN_ONLY_AT_DAY.get()).booleanValue()) {
            if (world.func_175657_ab() < 4 && world.func_226658_a_(LightType.BLOCK, pos) >= 6) {
                return true;
            }
        } else if (world.func_226658_a_(LightType.BLOCK, pos) >= 8) {
            return false;
        }
        return true;
    }

    public static boolean canSpawnHere(EntityType<EntityBear> entity, IWorld world, SpawnReason spawn_reason, BlockPos pos, Random random) {
        if (EntityBear.isDimBlacklisted(world.func_201675_m().func_186058_p().func_186068_a())) {
            return false;
        }
        if (((Boolean)Config.BEAR_SPAWN_ONLY_AT_DAY.get()).booleanValue()) {
            if (world.func_175657_ab() < 4) {
                return world.func_175659_aa() != Difficulty.PEACEFUL && EntityBear.isValidLightLevel(world, pos) && pos.func_177956_o() <= (Integer)Config.BEAR_SPAWN_Y_HEIGHT.get();
            }
            return false;
        }
        return world.func_175659_aa() != Difficulty.PEACEFUL && EntityBear.isValidLightLevel(world, pos) && pos.func_177956_o() <= (Integer)Config.BEAR_SPAWN_Y_HEIGHT.get();
    }

    public boolean func_205019_a(IWorldReader world) {
        return !world.func_72953_d(this.func_174813_aQ()) && world.func_226668_i_((Entity)this);
    }

    public int func_70641_bl() {
        return 1;
    }

    public static boolean isDimBlacklisted(int dimensionIn) {
        return ((List)Config.BEAR_BLACKLISTED_DIMS.get()).contains(dimensionIn);
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        int randomAmount = 1 + this.field_70146_Z.nextInt(2 + looting);
        for (int count = 0; count < randomAmount; ++count) {
            this.func_70099_a(new ItemStack((IItemProvider)ModItems.BEAR_CLAW), 0.0f);
        }
        this.func_70099_a(new ItemStack((IItemProvider)(this.func_70027_ad() ? ModItems.BEAR_MEAT_COOKED : ModItems.BEAR_MEAT)), 0.0f);
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_70685_l(entity)) {
            boolean hasHitTarget = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b()));
            if (hasHitTarget) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 3.141593f / 180.0f)) * 0.5f), 0.2, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * 3.141593f / 180.0f)) * 0.5f));
                if (!this.func_130014_f_().field_72995_K) {
                    this.func_130014_f_().func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_190031_ew, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
            return hasHitTarget;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(EntityBear bear) {
            super((CreatureEntity)bear, 0.6, false);
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(EntityBear bear, Class<T> classTarget) {
            super((MobEntity)bear, classTarget, true);
        }
    }
}

