/*
 * Decompiled with CFR 0.152.
 */
package animalium.entities;

import animalium.ModEntities;
import animalium.ModItems;
import animalium.configs.Config;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityPiranha
extends MonsterEntity {
    private static final DataParameter<Boolean> IS_LEAPING = EntityDataManager.func_187226_a(EntityPiranha.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityPiranha(EntityType<? extends EntityPiranha> type, World world) {
        super(type, world);
        this.field_70765_h = new PiranhaMoveHelperController(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 0.75));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.75, 80));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, new TargetGoal<PlayerEntity>(this, PlayerEntity.class));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        if (((Boolean)Config.PIRANHA_ATTACK_MOBS.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(1, new TargetGoal<MonsterEntity>(this, MonsterEntity.class));
        }
        if (((Boolean)Config.PIRANHA_ATTACK_CREATURES.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(2, new TargetGoal<LivingEntity>(this, LivingEntity.class));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LEAPING, (Object)false);
    }

    public boolean isLeaping() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LEAPING);
    }

    private void setIsLeaping(boolean leaping) {
        this.field_70180_af.func_187227_b(IS_LEAPING, (Object)leaping);
    }

    public boolean isGrounded() {
        return !this.func_70090_H() && this.func_130014_f_().func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)(this.func_226278_cu_() + 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()))) && this.func_130014_f_().func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.func_226277_ct_()), MathHelper.func_76128_c((double)(this.func_226278_cu_() - 1.0)), MathHelper.func_76128_c((double)this.func_226281_cx_()))).func_200132_m();
    }

    public boolean func_184198_c(CompoundNBT nbt) {
        return super.func_184198_c(nbt);
    }

    public void func_70020_e(CompoundNBT nbt) {
        super.func_70020_e(nbt);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    protected PathNavigator func_175447_b(World world) {
        return new SwimmerPathNavigator((MobEntity)this, world);
    }

    public boolean func_205019_a(IWorldReader world) {
        return world.func_226668_i_((Entity)this);
    }

    public static boolean canSpawnHere(EntityType<EntityPiranha> entity, IWorld world, SpawnReason spawn_reason, BlockPos pos, Random random) {
        if (EntityPiranha.isDimBlacklisted(world.func_201675_m().func_186058_p().func_186068_a())) {
            return false;
        }
        if ((double)pos.func_177956_o() < 45.0 || pos.func_177956_o() >= 80) {
            return false;
        }
        return !(random.nextInt(10) != 0 && world.func_175710_j(pos) || world.func_175659_aa() == Difficulty.PEACEFUL || spawn_reason != SpawnReason.SPAWNER && !world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a));
    }

    public int func_70641_bl() {
        return 3;
    }

    public static boolean isDimBlacklisted(int dimensionIn) {
        return ((List)Config.PIRANHA_BLACKLISTED_DIMS.get()).contains(dimensionIn);
    }

    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? SoundEvents.field_187549_bG : SoundEvents.field_187684_cg;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187690_ci;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187553_bI;
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.func_184185_a(SoundEvents.field_187553_bI, 1.0f, 2.0f);
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(this.func_70090_H() ? SoundEvents.field_187549_bG : SoundEvents.field_187684_cg, 0.5f, 2.0f);
    }

    public float func_205022_a(BlockPos pos, IWorldReader world) {
        return world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a) ? 10.0f + world.func_205052_D(pos) - 0.5f : super.func_205022_a(pos, world);
    }

    public void func_70636_d() {
        if (this.func_130014_f_().field_72995_K && this.func_70090_H()) {
            Vec3d vec3d = this.func_70676_i(0.0f);
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d.field_72450_a * 1.5, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - vec3d.field_72448_b * 1.5, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d.field_72449_c * 1.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f), 0.5, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f)));
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            if (this.isLeaping()) {
                this.setIsLeaping(false);
            }
            this.field_70122_E = false;
            this.field_70160_al = true;
            if (this.func_130014_f_().func_82737_E() % 5L == 0L) {
                this.func_130014_f_().func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187684_cg, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            this.func_70665_d(DamageSource.field_76369_e, 0.5f);
        }
        super.func_70636_d();
    }

    public void func_213352_e(Vec3d travel_vector) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_213309_a(0.1f, travel_vector);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.9f));
                if (this.func_70638_az() == null) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
                }
            } else {
                super.func_213352_e(travel_vector);
            }
        } else {
            super.func_213352_e(travel_vector);
        }
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        if (this.func_130014_f_().field_73012_v.nextInt(5) == 0) {
            ItemStack stack = new ItemStack((IItemProvider)ModItems.PIRANHA_STEAK);
            if (this.func_70027_ad()) {
                stack = new ItemStack((IItemProvider)ModItems.PIRANHA_STEAK_COOKED);
            }
            this.func_70099_a(stack, 1.0f);
        }
    }

    public void func_70071_h_() {
        Double distance;
        if (!this.func_130014_f_().field_72995_K && this.func_70638_az() != null && !this.func_130014_f_().func_72953_d(this.func_70638_az().func_174813_aQ()) && (distance = Double.valueOf(this.func_70032_d((Entity)this.func_70638_az()))) > 1.0 && distance < 6.0 && this.func_70090_H() && this.func_130014_f_().func_175623_d(new BlockPos((int)this.func_226277_ct_(), (int)this.func_226278_cu_() + 1, (int)this.func_226281_cx_()))) {
            if (!this.isLeaping()) {
                this.setIsLeaping(true);
                this.func_130014_f_().func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.HOSTILE, 1.0f, 2.0f);
            }
            double distanceX = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_();
            double distanceY = this.func_70638_az().func_226278_cu_() + (double)(this.func_70638_az().func_213302_cg() * 0.5f) - (this.func_226278_cu_() + (double)this.func_70047_e());
            double distanceZ = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_();
            float distanceSqrRoot = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ));
            double motionX = distanceX / (double)distanceSqrRoot * 0.5 * 0.900000011920929 + this.func_213322_ci().func_82615_a() * 0.7000000029802322;
            double motionY = 0.125;
            double motionZ = distanceZ / (double)distanceSqrRoot * 0.5 * 0.900000011920929 + this.func_213322_ci().func_82616_c() * 0.7000000029802322;
            this.func_213317_d(this.func_213322_ci().func_72441_c(motionX * 0.25, motionY, motionZ * 0.25));
        }
        super.func_70071_h_();
    }

    public boolean func_213358_a(EntityType<?> typeIn) {
        return typeIn != ModEntities.PIRANHA;
    }

    public boolean func_70652_k(Entity entity) {
        return this.func_70685_l(entity) && super.func_70652_k(entity);
    }

    protected void func_85033_bc() {
        List list;
        super.func_85033_bc();
        if (((Boolean)Config.PIRANHA_DAMAGE_BOATS.get()).booleanValue() && !(list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())).isEmpty() && this.field_70146_Z.nextInt((Integer)Config.PIRANHA_DAMAGE_BOATS_CHANCE.get()) == 0) {
            for (int k = 0; k < list.size(); ++k) {
                if (!((Entity)list.get(k) instanceof BoatEntity)) continue;
                this.func_70652_k((Entity)list.get(k));
            }
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(EntityPiranha piranha) {
            super((CreatureEntity)piranha, 0.75, true);
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 0.5f + attackTarget.func_213311_cf();
        }
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(EntityPiranha piranha, Class<T> classTarget) {
            super((MobEntity)piranha, classTarget, true);
        }
    }

    static class PiranhaMoveHelperController
    extends MovementController {
        private final EntityPiranha piranha;

        public PiranhaMoveHelperController(EntityPiranha piranha) {
            super((MobEntity)piranha);
            this.piranha = piranha;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.piranha.func_70661_as().func_75500_f()) {
                Vec3d vec3d = new Vec3d(this.field_75646_b - this.piranha.func_226277_ct_(), this.field_75647_c - this.piranha.func_226278_cu_(), this.field_75644_d - this.piranha.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                double d1 = vec3d.field_72450_a / d0;
                double d2 = vec3d.field_72448_b / d0;
                double d3 = vec3d.field_72449_c / d0;
                float f = (float)(MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) * 57.2957763671875) - 90.0f;
                this.piranha.field_70761_aq = this.piranha.field_70177_z = this.func_75639_a(this.piranha.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.piranha.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.piranha.func_70689_ay(), (float)f1);
                this.piranha.func_70659_e(f2);
                double d4 = Math.sin((double)(this.piranha.field_70173_aa + this.piranha.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.piranha.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.piranha.field_70177_z * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.piranha.field_70173_aa + this.piranha.func_145782_y()) * 0.75) * 0.05;
                this.piranha.func_213317_d(this.piranha.func_213322_ci().func_72441_c(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f2 * d2 * 0.1, d4 * d6));
                LookController lookcontroller = this.piranha.func_70671_ap();
                double d8 = this.piranha.func_226277_ct_() + d1 * 2.0;
                double d9 = (double)this.piranha.func_70047_e() + this.piranha.func_226278_cu_() + d2 / d0;
                double d10 = this.piranha.func_226281_cx_() + d3 * 2.0;
                double d11 = lookcontroller.func_180423_e();
                double d12 = lookcontroller.func_180422_f();
                double d13 = lookcontroller.func_180421_g();
                if (!lookcontroller.func_180424_b()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.piranha.func_70671_ap().func_75650_a(MathHelper.func_219803_d((double)0.125, (double)d11, (double)d8), MathHelper.func_219803_d((double)0.125, (double)d12, (double)d9), MathHelper.func_219803_d((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
            } else {
                this.piranha.func_70659_e(0.0f);
            }
        }
    }
}

