/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.api.impl;

import hunternif.mc.api.MarkerAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.packet.c2s.play.DeleteMarkerRequestC2SPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.DeleteMarkerResponseS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.MarkersS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collections;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkerApiImpl
implements MarkerAPI {
    private static final int GLOBAL = -1;

    @Override
    @Nullable
    public Marker putMarker(@NotNull class_1937 world, boolean visibleAhead, int atlasID, class_2960 marker, class_2561 label, int x, int z) {
        return this.doPutMarker(world, visibleAhead, atlasID, marker, label, x, z);
    }

    @Override
    @Nullable
    public Marker putGlobalMarker(@NotNull class_1937 world, boolean visibleAhead, class_2960 marker, class_2561 label, int x, int z) {
        return this.doPutMarker(world, visibleAhead, -1, marker, label, x, z);
    }

    private Marker doPutMarker(class_1937 world, boolean visibleAhead, int atlasID, class_2960 markerId, class_2561 label, int x, int z) {
        Marker marker = null;
        if (!world.field_9236 && world.method_8503() != null) {
            GlobalMarkersData data = atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            marker = ((MarkersData)data).createAndSaveMarker(markerId, (class_5321<class_1937>)world.method_27983(), x, z, visibleAhead, label);
            new MarkersS2CPacket(atlasID, (class_5321<class_1937>)world.method_27983(), Collections.singleton(marker)).send((class_3218)world);
        }
        return marker;
    }

    @Override
    public void deleteMarker(@NotNull class_1937 world, int atlasID, int markerID) {
        this.doDeleteMarker(world, atlasID, markerID);
    }

    @Override
    public void deleteGlobalMarker(@NotNull class_1937 world, int markerID) {
        this.doDeleteMarker(world, -1, markerID);
    }

    private void doDeleteMarker(class_1937 world, int atlasID, int markerID) {
        if (world.field_9236) {
            if (atlasID == -1) {
                Log.warn("Client tried to delete a global marker!", new Object[0]);
            } else {
                new DeleteMarkerRequestC2SPacket(atlasID, markerID).send();
            }
        } else {
            GlobalMarkersData data = atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            data.removeMarker(markerID);
            new DeleteMarkerResponseS2CPacket(atlasID, markerID).send(world.method_8503());
        }
    }
}

