/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.client.texture.Texture;
import java.util.ArrayList;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

@Environment(value=EnvType.CLIENT)
class SetTileRenderer {
    private final HashMap<class_2960, ArrayList<TileCorner>> subjects = new HashMap();
    private final class_4587 matrices;
    private final int tileHalfSize;
    private final int light;
    private final class_4597 buffer;

    public SetTileRenderer(class_4597 buffer, class_4587 matrices, int tileHalfSize, int light) {
        this.matrices = matrices;
        this.tileHalfSize = tileHalfSize;
        this.light = light;
        this.buffer = buffer;
    }

    public void addTileCorner(class_2960 texture, int x, int y, int u, int v) {
        ArrayList set = this.subjects.computeIfAbsent(texture, k -> new ArrayList());
        set.add(new TileCorner(x, y, u, v));
    }

    public void draw() {
        for (class_2960 key : this.subjects.keySet()) {
            ArrayList<TileCorner> tca = this.subjects.get(key);
            Texture texture = new Texture(key, 4, 6, false);
            for (TileCorner tc : tca) {
                this.drawInlineAutotileCorner(texture, tc.x, tc.y, tc.u, tc.v);
            }
        }
    }

    private void drawInlineAutotileCorner(ITexture texture, int x, int y, int u, int v) {
        if (x + this.tileHalfSize <= 240 && x - this.tileHalfSize >= 0 && y + this.tileHalfSize < 166 && y - this.tileHalfSize >= 0) {
            texture.drawWithLight(this.buffer, this.matrices, x, y, this.tileHalfSize, this.tileHalfSize, u, v, 1, 1, this.light);
        }
    }

    public class TileCorner {
        final int x;
        final int y;
        final int u;
        final int v;

        TileCorner(int x, int y, int u, int v) {
            this.x = x;
            this.y = y;
            this.u = u;
            this.v = v;
        }
    }
}

