/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5458;
import net.minecraft.class_5464;

@Environment(value=EnvType.CLIENT)
public class TileTextureMap {
    private static final TileTextureMap INSTANCE = new TileTextureMap();
    private final Map<class_2960, TextureSet> textureMap = new HashMap<class_2960, TextureSet>();

    public static TileTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(class_2960 tileId, TextureSet textureSet) {
        if (textureSet == null) {
            if (this.textureMap.remove(tileId) != null) {
                Log.warn("Removing old texture for %d", tileId);
            }
            return;
        }
        this.textureMap.put(tileId, textureSet);
    }

    public TextureSet getDefaultTexture() {
        return TextureSetMap.instance().getByName(AntiqueAtlasMod.id("test"));
    }

    public void autoRegister(class_2960 id, class_1959 biome) {
        if (biome == null) {
            Log.error("Given biome is null. Cannot autodetect a suitable texture set for that.", new Object[0]);
            return;
        }
        switch (biome.method_8688()) {
            case field_9364: {
                this.setTexture(id, biome.method_8686() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("swamp_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("swamp")));
                break;
            }
            case field_9367: 
            case field_9369: {
                this.setTexture(id, biome.method_8694() == class_1959.class_1963.field_9383 ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("ice")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("water")));
                break;
            }
            case field_9363: {
                this.setTexture(id, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("shore")));
                break;
            }
            case field_9358: {
                this.setTexture(id, biome.method_8686() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("jungle_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("jungle")));
                break;
            }
            case field_9356: {
                this.setTexture(id, biome.method_8695() >= 1.0f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("plateau_savanna")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("savanna")));
                break;
            }
            case field_9354: {
                this.setTexture(id, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("plateau_mesa")));
                break;
            }
            case field_9370: {
                this.setTexture(id, biome.method_8694() == class_1959.class_1963.field_9383 ? (biome.method_8686() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow_pines_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow_pines"))) : (biome.method_8686() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("forest_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("forest"))));
                break;
            }
            case field_9355: {
                this.setTexture(id, biome.method_8694() == class_1959.class_1963.field_9383 ? (biome.method_8686() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow"))) : (biome.method_8686() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("plains"))));
                break;
            }
            case field_9362: {
                this.setTexture(id, biome.method_8686() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("mountains_snow_caps")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("ice_spikes")));
                break;
            }
            case field_9368: {
                this.setTexture(id, biome.method_8686() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("desert_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("desert")));
                break;
            }
            case field_9361: {
                this.setTexture(id, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow")));
                break;
            }
            case field_9357: {
                this.setTexture(id, biome.method_8686() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("mountains")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("hills")));
                break;
            }
            case field_9360: {
                List features = biome.method_30970().method_30983();
                boolean has_chorus_plant = features.stream().anyMatch(supplier -> supplier.stream().anyMatch(step -> step.get() == class_5464.field_26119));
                if (has_chorus_plant) {
                    this.setTexture(id, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("end_island_plants")));
                    break;
                }
                this.setTexture(id, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("end_island")));
                break;
            }
            case field_9365: {
                this.setTexture(id, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("mushroom")));
            }
            case field_9366: {
                this.setTexture(id, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("soul_sand_valley")));
            }
            case field_9371: {
                this.setTexture(id, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("end_void")));
                break;
            }
            case field_29217: {
                Log.warn("Underground biomes aren't supported yet.", new Object[0]);
                break;
            }
            default: {
                Log.warn("Couldn't auto-registered standard texture set for biome %s", id.toString());
                return;
            }
        }
        if (this.textureMap.get(id) != null) {
            Log.info("Auto-registered standard texture set for biome %s: %s", id.toString(), this.textureMap.get((Object)id).name);
        } else {
            Log.error("Failed to auto-register a standard texture set for the biome '%s'. This is most likely caused by errors in the TextureSet configurations, check your resource packs first before reporting it as an issue!", id.toString());
        }
    }

    public void checkRegistration(class_2960 id, class_1959 biome) {
        if (!this.isRegistered(id)) {
            this.autoRegister(id, biome);
        }
    }

    private void checkRegistration(class_2960 id) {
        if (!this.isRegistered(id)) {
            this.setTexture(id, this.getDefaultTexture());
        }
    }

    public boolean isRegistered(class_2960 id) {
        return this.textureMap.containsKey(id);
    }

    public TextureSet getTextureSet(class_2960 tile) {
        if (tile == null) {
            return this.getDefaultTexture();
        }
        class_1959 biome = (class_1959)class_5458.field_25933.method_10223(tile);
        if (biome != null) {
            this.checkRegistration(tile, biome);
        } else {
            this.checkRegistration(tile);
        }
        return this.textureMap.getOrDefault(tile, this.getDefaultTexture());
    }

    public ITexture getTexture(SubTile subTile) {
        return this.getTextureSet(subTile.tile).getTexture(subTile.variationNumber);
    }

    public List<class_2960> getAllTextures() {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        for (Map.Entry<class_2960, TextureSet> entry : this.textureMap.entrySet()) {
            Arrays.stream(entry.getValue().textures).forEach(iTexture -> list.add(iTexture.getTexture()));
        }
        return list;
    }
}

