/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.network.packet.s2c.play.CustomTileInfoS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.Streams;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class TileDataStorage
extends class_18 {
    private static final int VERSION = 3;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_TILE_LIST = "tiles";
    private static final int CHUNK_SIZE = 10000;
    private final Map<class_1923, class_2960> tiles = new ConcurrentHashMap<class_1923, class_2960>(2, 0.75f, 2);

    public static TileDataStorage readNbt(class_2487 compound) {
        TileDataStorage data = new TileDataStorage();
        int version = compound.method_10550(TAG_VERSION);
        if (version < 3) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 3);
            return data;
        }
        class_2499 tileList = compound.method_10554(TAG_TILE_LIST, 10);
        tileList.forEach(tag1 -> {
            class_2487 tile = (class_2487)tag1;
            class_1923 coords = new class_1923(tile.method_10550("x"), tile.method_10550("y"));
            data.tiles.put(coords, class_2960.method_12829((String)tile.method_10558("id")));
        });
        return data;
    }

    public class_2487 method_75(class_2487 compound) {
        compound.method_10569(TAG_VERSION, 3);
        class_2499 tileList = new class_2499();
        for (Map.Entry<class_1923, class_2960> entry : this.tiles.entrySet()) {
            class_2487 tile = new class_2487();
            tile.method_10569("x", entry.getKey().field_9181);
            tile.method_10569("y", entry.getKey().field_9180);
            tile.method_10582("id", entry.getValue().toString());
            tileList.add((Object)tile);
        }
        compound.method_10566(TAG_TILE_LIST, (class_2520)tileList);
        return compound;
    }

    public class_2960 getTile(int x, int z) {
        return this.tiles.get(new class_1923(x, z));
    }

    public void setTile(int x, int z, class_2960 tile) {
        this.tiles.put(new class_1923(x, z), tile);
        this.method_80();
    }

    public void removeTile(int x, int z) {
        this.tiles.remove(new class_1923(x, z));
        this.method_80();
    }

    public void syncToPlayer(class_1657 player, class_5321<class_1937> world) {
        Streams.chunked(this.tiles.entrySet().stream(), 10000).forEach(chunk -> new CustomTileInfoS2CPacket(world, (List<Map.Entry<class_1923, class_2960>>)chunk).send((class_3222)player));
        Log.info("Sent custom biome data to player %s", player.method_5671().method_9214());
    }
}

