/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.ITileStorage;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.Rect;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class TileGroup
implements ITileStorage {
    public static final String TAG_POSITION = "p";
    public static final String TAG_TILES = "t";
    public static final int CHUNK_STEP = 16;
    Rect scope = new Rect(0, 0, 16, 16);
    class_2960[][] tiles = new class_2960[16][16];

    public TileGroup(int x, int y) {
        this.scope.minX = x;
        this.scope.minY = y;
        this.scope.maxX = this.scope.minX + 16 - 1;
        this.scope.maxY = this.scope.minY + 16 - 1;
    }

    public TileGroup() {
    }

    public TileGroup readFromNBT(class_2487 compound) {
        this.scope.minX = compound.method_10561(TAG_POSITION)[0];
        this.scope.minY = compound.method_10561(TAG_POSITION)[1];
        this.scope.maxX = this.scope.minX + 16 - 1;
        this.scope.maxY = this.scope.minY + 16 - 1;
        class_2499 listTag = compound.method_10554(TAG_TILES, 8);
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                String id = listTag.method_10608(x + y * 16);
                if (id.isEmpty()) continue;
                this.tiles[x][y] = class_2960.method_12829((String)id);
            }
        }
        return this;
    }

    public class_2487 writeToNBT(class_2487 compound) {
        int[] pos = new int[]{this.scope.minX, this.scope.minY};
        class_2499 listTag = new class_2499();
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                listTag.method_10531(x + y * 16, (class_2520)class_2519.method_23256((String)(this.tiles[x][y] == null ? "" : this.tiles[x][y].toString())));
            }
        }
        compound.method_10539(TAG_POSITION, pos);
        compound.method_10566(TAG_TILES, (class_2520)listTag);
        return compound;
    }

    @Override
    public void setTile(int x, int y, class_2960 tile) {
        if (x >= this.scope.minX && y >= this.scope.minY && x <= this.scope.maxX && y <= this.scope.maxY) {
            int rx = x - this.scope.minX;
            int ry = y - this.scope.minY;
            this.tiles[rx][ry] = tile;
        } else {
            Log.warn("TileGroup tried to set tile out of bounds:\n\tbounds:" + this.scope + "\n\ttarget: x:" + x + ", y:" + y, new Object[0]);
        }
    }

    @Override
    public class_2960 removeTile(int x, int y) {
        class_2960 tmp = this.getTile(x, y);
        this.setTile(x, y, null);
        return tmp;
    }

    @Override
    public class_2960 getTile(int x, int y) {
        if (x >= this.scope.minX && y >= this.scope.minY && x <= this.scope.maxX && y <= this.scope.maxY) {
            int rx = x - this.scope.minX;
            int ry = y - this.scope.minY;
            return this.tiles[rx][ry];
        }
        return null;
    }

    @Override
    public boolean hasTileAt(int x, int y) {
        return this.getTile(x, y) != null;
    }

    @Override
    public Rect getScope() {
        return this.scope;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TileGroup)) {
            return false;
        }
        TileGroup other = (TileGroup)obj;
        if (!this.scope.equals(other.scope)) {
            return false;
        }
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                class_2960 a = this.tiles[x][y];
                class_2960 b = other.tiles[x][y];
                if (a == null) {
                    if (b == null) continue;
                    return false;
                }
                if (this.tiles[x][y].equals((Object)other.tiles[x][y])) continue;
                return false;
            }
        }
        return true;
    }
}

