/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import com.google.common.collect.HashMultimap;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3545;
import net.minecraft.class_3773;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3790;
import org.apache.commons.lang3.tuple.Triple;

public class StructureHandler {
    private static final HashMultimap<class_2960, class_3545<class_2960, Setter>> STRUCTURE_PIECE_TO_TILE_MAP = HashMultimap.create();
    private static final Map<String, class_3545<class_2960, Setter>> JIGSAW_TO_TILE_MAP = new HashMap<String, class_3545<class_2960, Setter>>();
    private static final Map<class_2960, class_3545<class_2960, class_2561>> STRUCTURE_PIECE_TO_MARKER_MAP = new HashMap<class_2960, class_3545<class_2960, class_2561>>();
    private static final Map<class_2960, Integer> STRUCTURE_PIECE_TILE_PRIORITY = new HashMap<class_2960, Integer>();
    private static final Setter ALWAYS = (world, element, box) -> Collections.singleton(new class_1923(MathUtil.getCenter(box).method_10263() >> 4, MathUtil.getCenter(box).method_10260() >> 4));
    private static final Set<Triple<Integer, Integer, class_2960>> VISITED_STRUCTURES = Collections.newSetFromMap(new ConcurrentHashMap());

    public static void registerTile(class_3773 structurePieceType, int priority, class_2960 textureId, Setter setter) {
        class_2960 id = class_2378.field_16645.method_10221((Object)structurePieceType);
        STRUCTURE_PIECE_TO_TILE_MAP.put((Object)id, (Object)new class_3545((Object)textureId, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(textureId, priority);
    }

    public static void registerTile(class_3773 structurePieceType, int priority, class_2960 textureId) {
        StructureHandler.registerTile(structurePieceType, priority, textureId, ALWAYS);
    }

    public static void registerJigsawTile(String jigsawPattern, int priority, class_2960 tileID, Setter setter) {
        JIGSAW_TO_TILE_MAP.put(jigsawPattern, (class_3545<class_2960, Setter>)new class_3545((Object)tileID, (Object)setter));
        STRUCTURE_PIECE_TILE_PRIORITY.put(tileID, priority);
    }

    public static void registerJigsawTile(String jigsawPattern, int priority, class_2960 tileID) {
        StructureHandler.registerJigsawTile(jigsawPattern, priority, tileID, ALWAYS);
    }

    public static void registerMarker(class_3195<?> structureFeature, class_2960 markerType, class_2561 name) {
        STRUCTURE_PIECE_TO_MARKER_MAP.put(class_2378.field_16644.method_10221(structureFeature), (class_3545<class_2960, class_2561>)new class_3545((Object)markerType, (Object)name));
    }

    private static int getPriority(class_2960 structurePieceId) {
        return STRUCTURE_PIECE_TILE_PRIORITY.getOrDefault(structurePieceId, Integer.MAX_VALUE);
    }

    private static void put(class_1937 world, int chunkX, int chunkZ, class_2960 textureId) {
        class_2960 existingTile = AtlasAPI.getTileAPI().getGlobalTile(world, chunkX, chunkZ);
        if (StructureHandler.getPriority(textureId) < StructureHandler.getPriority(existingTile)) {
            AtlasAPI.getTileAPI().putGlobalTile(world, textureId, chunkX, chunkZ);
        }
    }

    private static void resolveJigsaw(class_3443 jigsawPiece, class_3218 world) {
        class_3790 pool;
        if (jigsawPiece instanceof class_3790 && (pool = (class_3790)jigsawPiece).method_16644() instanceof class_3781) {
            class_3781 singlePoolElement = (class_3781)pool.method_16644();
            Optional left = singlePoolElement.field_24015.left();
            if (left.isPresent()) {
                String path = ((class_2960)left.get()).method_12832();
                for (Map.Entry<String, class_3545<class_2960, Setter>> entry : JIGSAW_TO_TILE_MAP.entrySet()) {
                    class_2960 tile = (class_2960)entry.getValue().method_15442();
                    Setter setter = (Setter)entry.getValue().method_15441();
                    if (!path.contains(entry.getKey())) continue;
                    for (class_1923 pos : setter.matches((class_1937)world, (class_3784)singlePoolElement, pool.method_14935())) {
                        StructureHandler.put((class_1937)world, pos.field_9181, pos.field_9180, tile);
                    }
                }
            }
        }
    }

    public static void resolve(class_3443 structurePiece, class_3218 world) {
        if (structurePiece.method_16653() == class_3773.field_25840) {
            StructureHandler.resolveJigsaw(structurePiece, world);
            return;
        }
        class_2960 structurePieceId = class_2378.field_16645.method_10221((Object)structurePiece.method_16653());
        if (STRUCTURE_PIECE_TO_TILE_MAP.containsKey((Object)structurePieceId)) {
            for (class_3545 entry : STRUCTURE_PIECE_TO_TILE_MAP.get((Object)structurePieceId)) {
                Collection<class_1923> matches;
                if (structurePiece instanceof class_3790) {
                    class_3790 pool = (class_3790)structurePiece;
                    matches = ((Setter)entry.method_15441()).matches((class_1937)world, pool.method_16644(), pool.method_14935());
                } else {
                    matches = ((Setter)entry.method_15441()).matches((class_1937)world, null, structurePiece.method_14935());
                }
                for (class_1923 pos : matches) {
                    StructureHandler.put((class_1937)world, pos.field_9181, pos.field_9180, (class_2960)entry.method_15442());
                }
            }
        }
    }

    public static void resolve(class_3449<?> structureStart, class_3218 world) {
        class_2960 structureId = class_2378.field_16644.method_10221((Object)structureStart.method_16656());
        if (STRUCTURE_PIECE_TO_MARKER_MAP.containsKey(structureId)) {
            Triple key = Triple.of((Object)structureStart.method_14969().method_22874().method_10263(), (Object)structureStart.method_14969().method_22874().method_10264(), (Object)structureId);
            if (VISITED_STRUCTURES.contains(key)) {
                return;
            }
            VISITED_STRUCTURES.add((Triple<Integer, Integer, class_2960>)key);
            AtlasAPI.getMarkerAPI().putGlobalMarker((class_1937)world, false, (class_2960)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).method_15442(), (class_2561)STRUCTURE_PIECE_TO_MARKER_MAP.get(structureId).method_15441(), structureStart.method_14969().method_22874().method_10263(), structureStart.method_14969().method_22874().method_10260());
        }
    }

    static interface Setter {
        public Collection<class_1923> matches(class_1937 var1, class_3784 var2, class_3341 var3);
    }
}

