/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.IResourceReloadListener;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.client.texture.TileTexture;
import hunternif.mc.impl.atlas.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

@Environment(value=EnvType.CLIENT)
public class TextureConfig
implements IResourceReloadListener<Map<class_2960, ITexture>> {
    private final Map<class_2960, ITexture> texture_map;

    public TextureConfig(Map<class_2960, ITexture> texture_map) {
        this.texture_map = texture_map;
    }

    @Override
    public CompletableFuture<Map<class_2960, ITexture>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, TileTexture> textures = new HashMap<class_2960, TileTexture>();
            try {
                for (class_2960 id : manager.method_14488("textures/gui/tiles", s -> s.endsWith(".png"))) {
                    class_2960 texture_id = new class_2960(id.method_12836(), id.method_12832().replace("textures/gui/tiles/", "").replace(".png", ""));
                    AntiqueAtlasMod.LOG.info("Found new Texture: " + texture_id);
                    textures.put(texture_id, new TileTexture(id));
                }
            }
            catch (Throwable e) {
                AntiqueAtlasMod.LOG.warn("Failed to read textures!", e);
            }
            return textures;
        });
    }

    @Override
    public CompletableFuture<Void> apply(Map<class_2960, ITexture> textures, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            this.texture_map.clear();
            for (Map.Entry entry : textures.entrySet()) {
                this.texture_map.put((class_2960)entry.getKey(), (ITexture)entry.getValue());
                Log.info("Loaded texture %s with path %s", entry.getKey(), ((ITexture)entry.getValue()).getTexture());
            }
        });
    }

    public String method_22322() {
        return "antiqueatlas:textures";
    }
}

