/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.AntiqueAtlasModClient;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.AntiqueAtlasNetworking;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.Collection;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class MarkersS2CPacket
extends S2CPacket {
    public static final class_2960 ID = AntiqueAtlasMod.id("packet", "s2c", "marker", "info");
    private static final int GLOBAL = -1;
    int atlasID;
    class_5321<class_1937> world;
    Collection<Marker> markers;
    ListMultimap<class_2960, Marker.Precursor> markersByType;

    public MarkersS2CPacket(int atlasID, class_5321<class_1937> world, Collection<Marker> markers) {
        this.atlasID = atlasID;
        this.world = world;
        this.markers = markers;
    }

    public MarkersS2CPacket(class_2540 buf) {
        this.atlasID = buf.method_10816();
        this.world = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)buf.method_10810());
        int typesLength = buf.method_10816();
        this.markersByType = ArrayListMultimap.create();
        for (int i = 0; i < typesLength; ++i) {
            class_2960 type = buf.method_10810();
            int markersLength = buf.method_10816();
            for (int j = 0; j < markersLength; ++j) {
                this.markersByType.put((Object)type, (Object)new Marker.Precursor(buf));
            }
        }
    }

    public MessageType getType() {
        return AntiqueAtlasNetworking.MARKERS;
    }

    public void write(class_2540 buf) {
        ArrayListMultimap markersByType = ArrayListMultimap.create();
        for (Marker marker : this.markers) {
            markersByType.put((Object)marker.getType(), (Object)marker);
        }
        buf.method_10804(this.atlasID);
        buf.method_10812(this.world.method_29177());
        buf.method_10804(markersByType.keySet().size());
        for (class_2960 type : markersByType.keySet()) {
            buf.method_10812(type);
            List markerList = markersByType.get((Object)type);
            buf.method_10804(markerList.size());
            for (Marker marker : markerList) {
                marker.write(buf);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            GlobalMarkersData markersData = this.atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, context.getPlayer().method_5770());
            for (class_2960 type : this.markersByType.keys()) {
                MarkerType markerType = (MarkerType)MarkerType.REGISTRY.method_10223(type);
                for (Marker.Precursor precursor : this.markersByType.get((Object)type)) {
                    ((MarkersData)markersData).loadMarker(new Marker(MarkerType.REGISTRY.method_10221((Object)markerType), this.world, precursor));
                }
            }
            AntiqueAtlasModClient.getAtlasGUI().updateBookmarkerList();
        });
    }
}

