/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui.core;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class GuiComponent
extends Screen {
    private GuiComponent parent = null;
    private final List<GuiComponent> children = new CopyOnWriteArrayList<GuiComponent>();
    int properWidth;
    int properHeight;
    int contentWidth;
    int contentHeight;
    private boolean sizeIsInvalid = false;
    private boolean isClipped = false;
    protected boolean isMouseOver = false;
    private boolean interceptsMouse = true;
    private boolean interceptsKeyboard = true;
    private boolean blocksScreen = false;
    private int guiX = 0;
    private int guiY = 0;
    private final HoveringTextInfo hoveringTextInfo = new HoveringTextInfo();

    public GuiComponent() {
        super((ITextComponent)new StringTextComponent("component"));
    }

    public void setGuiCoords(int x, int y) {
        int dx = x - this.guiX;
        int dy = y - this.guiY;
        this.guiX = x;
        this.guiY = y;
        for (GuiComponent child : this.children) {
            child.offsetGuiCoords(dx, dy);
        }
        if (this.parent != null && (dx != 0 || dy != 0)) {
            this.parent.invalidateSize();
        }
    }

    public final void setRelativeCoords(int x, int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(x, y);
        }
    }

    public final void setRelativeX(int x) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.guiY);
        } else {
            this.setGuiCoords(x, this.guiY);
        }
    }

    public final void setRelativeY(int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.guiX, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(this.guiX, y);
        }
    }

    public final void offsetGuiCoords(int dx, int dy) {
        this.setGuiCoords(this.guiX + dx, this.guiY + dy);
    }

    protected final void setCentered() {
        this.validateSize();
        if (this.parent == null) {
            this.setGuiCoords((this.field_230708_k_ - this.getWidth()) / 2, (this.field_230709_l_ - this.getHeight()) / 2);
        } else {
            this.setRelativeCoords((this.parent.getWidth() - this.getWidth()) / 2, (this.parent.getHeight() - this.getHeight()) / 2);
        }
    }

    public int getGuiX() {
        return this.guiX;
    }

    public int getGuiY() {
        return this.guiY;
    }

    int getRelativeX() {
        return this.parent == null ? this.guiX : this.guiX - this.parent.guiX;
    }

    int getRelativeY() {
        return this.parent == null ? this.guiY : this.guiY - this.parent.guiY;
    }

    public void setSize(int width, int height) {
        this.properWidth = width;
        this.properHeight = height;
        this.contentWidth = width;
        this.contentHeight = height;
        this.invalidateSize();
    }

    protected GuiComponent addChild(GuiComponent child) {
        this.doAddChild(null, child, null);
        return child;
    }

    public GuiComponent addChildInfrontOf(GuiComponent inFrontOf, GuiComponent child) {
        this.doAddChild(inFrontOf, child, null);
        return child;
    }

    protected GuiComponent addChildBehind(GuiComponent behind, GuiComponent child) {
        this.doAddChild(null, child, behind);
        return child;
    }

    private void doAddChild(GuiComponent inFrontOf, GuiComponent child, GuiComponent behind) {
        if (child == null || this.children.contains((Object)child) || this.parent == child) {
            return;
        }
        int i = this.children.indexOf((Object)inFrontOf);
        if (i == -1) {
            int j = this.children.indexOf((Object)behind);
            if (j == -1) {
                this.children.add(child);
            } else {
                this.children.add(j, child);
            }
        } else {
            this.children.add(i + 1, child);
        }
        child.parent = this;
        child.setGuiCoords(this.guiX, this.guiY);
        if (Minecraft.func_71410_x() != null) {
            child.field_230710_m_.clear();
            child.func_231158_b_(Minecraft.func_71410_x(), this.field_230708_k_, this.field_230709_l_);
        }
        this.invalidateSize();
    }

    protected GuiComponent removeChild(GuiComponent child) {
        if (child != null && this.children.contains((Object)child)) {
            child.parent = null;
            this.children.remove((Object)child);
            this.invalidateSize();
            this.onChildClosed(child);
        }
        return child;
    }

    void removeAllChildren() {
        this.children.clear();
        this.invalidateSize();
    }

    public GuiComponent getParent() {
        return this.parent;
    }

    List<GuiComponent> getChildren() {
        return this.children;
    }

    public void setInterceptMouse(boolean value) {
        this.interceptsMouse = value;
    }

    protected void setInterceptKeyboard(boolean value) {
        this.interceptsKeyboard = value;
    }

    protected void setBlocksScreen(boolean value) {
        this.blocksScreen = value;
    }

    boolean iterateInput(UiCall callMethod) {
        ListIterator<GuiComponent> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            GuiComponent child = iter.previous();
            if (!callMethod.call(child)) continue;
            return true;
        }
        return false;
    }

    boolean iterateMouseInput(UiCall callMethod) {
        this.isMouseOver = this.isMouseInRegion(this.getGuiX(), this.getGuiY(), this.getWidth(), this.getHeight());
        if (!this.iterateInput(c -> {
            c.isMouseOver = c.isMouseInRegion(c.getGuiX(), c.getGuiY(), c.getWidth(), c.getHeight());
            return callMethod.call(c);
        })) {
            return false;
        }
        this.isMouseOver = false;
        return true;
    }

    public boolean func_231044_a_(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.func_231044_a_(mx, my, mb))) {
            return super.func_231044_a_(mx, my, mb);
        }
        return true;
    }

    public boolean func_231048_c_(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.func_231048_c_(mx, my, mb))) {
            return super.func_231048_c_(mx, my, mb);
        }
        return true;
    }

    public boolean func_231045_a_(double mx, double my, int mb, double mx2, double my2) {
        if (!this.iterateMouseInput(c -> c.func_231045_a_(mx, my, mb, mx2, my2))) {
            return super.func_231044_a_(mx, my, mb);
        }
        return true;
    }

    public boolean func_231043_a_(double mx, double my, double dy) {
        if (!this.iterateMouseInput(c -> c.func_231043_a_(mx, my, dy))) {
            return super.func_231043_a_(mx, my, dy);
        }
        return true;
    }

    public void func_212927_b(double mx, double my) {
        if (!this.iterateMouseInput(c -> {
            c.func_212927_b(mx, my);
            return false;
        })) {
            super.func_212927_b(mx, my);
        }
    }

    public boolean func_231046_a_(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.func_231046_a_(a, b, c))) {
            return super.func_231046_a_(a, b, c);
        }
        return true;
    }

    public boolean func_231042_a_(char aa, int bb) {
        if (!this.iterateInput(cpt -> cpt.func_231042_a_(aa, bb))) {
            return super.func_231042_a_(aa, bb);
        }
        return true;
    }

    public boolean func_223281_a_(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.func_223281_a_(a, b, c))) {
            return super.func_223281_a_(a, b, c);
        }
        return true;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float partialTick) {
        super.func_230430_a_(matrices, mouseX, mouseY, partialTick);
        for (GuiComponent child : this.children) {
            if (child.isClipped) continue;
            child.func_230430_a_(matrices, mouseX, mouseY, partialTick);
        }
        if (this.hoveringTextInfo.shouldDraw) {
            this.drawHoveringText2(matrices, this.hoveringTextInfo.lines, this.hoveringTextInfo.x, this.hoveringTextInfo.y, this.hoveringTextInfo.font);
            this.hoveringTextInfo.shouldDraw = false;
        }
    }

    public void func_231175_as__() {
        for (GuiComponent child : this.children) {
            child.func_231175_as__();
        }
        super.func_231175_as__();
    }

    public void func_231023_e_() {
        for (GuiComponent child : this.children) {
            child.func_231023_e_();
        }
        super.func_231023_e_();
        if (this.sizeIsInvalid) {
            this.validateSize();
        }
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        super.func_231158_b_(mc, width, height);
        for (GuiComponent child : this.children) {
            child.func_231158_b_(mc, width, height);
        }
    }

    protected int getWidth() {
        return this.contentWidth;
    }

    protected int getHeight() {
        return this.contentHeight;
    }

    void setClipped(boolean value) {
        this.isClipped = value;
    }

    private void invalidateSize() {
        this.sizeIsInvalid = true;
        if (this.parent != null) {
            this.parent.invalidateSize();
        }
    }

    void validateSize() {
        int leftmost = Integer.MAX_VALUE;
        int rightmost = Integer.MIN_VALUE;
        int topmost = Integer.MAX_VALUE;
        int bottommost = Integer.MIN_VALUE;
        for (GuiComponent child : this.children) {
            int childHeight;
            int y;
            int childWidth;
            int x = child.getGuiX();
            if (x < leftmost) {
                leftmost = x;
            }
            if (x + (childWidth = child.getWidth()) > rightmost) {
                rightmost = x + childWidth;
            }
            if ((y = child.getGuiY()) < topmost) {
                topmost = y;
            }
            if (y + (childHeight = child.getHeight()) <= bottommost) continue;
            bottommost = y + childHeight;
        }
        this.contentWidth = Math.max(this.properWidth, rightmost - leftmost);
        this.contentHeight = Math.max(this.properHeight, bottommost - topmost);
        this.sizeIsInvalid = false;
    }

    boolean isMouseInRegion(int left, int top, int width, int height) {
        double mouseX = this.getMouseX();
        double mouseY = this.getMouseY();
        return mouseX >= (double)left && mouseX < (double)(left + width) && mouseY >= (double)top && mouseY < (double)(top + height);
    }

    protected boolean isMouseInRadius(int x, int y, int radius) {
        double mouseX = this.getMouseX();
        double mouseY = this.getMouseY();
        return mouseX >= (double)(x - radius) && mouseX < (double)(x + radius) && mouseY >= (double)(y - radius) && mouseY < (double)(y + radius);
    }

    private void drawHoveringText2(MatrixStack matrices, List<ITextComponent> lines, double x, double y, FontRenderer font) {
        boolean stencilEnabled = GL11.glIsEnabled((int)2960);
        if (stencilEnabled) {
            GL11.glDisable((int)2960);
        }
        FontRenderer old = this.field_230712_o_;
        this.field_230712_o_ = font;
        this.func_243308_b(matrices, lines, (int)x, (int)y);
        this.field_230712_o_ = old;
        if (stencilEnabled) {
            GL11.glEnable((int)2960);
        }
    }

    private GuiComponent getTopLevelParent() {
        GuiComponent component = this;
        while (component.parent != null) {
            component = component.parent;
        }
        return component;
    }

    protected void drawTooltip(List<ITextComponent> lines, FontRenderer font) {
        GuiComponent topLevel = this.getTopLevelParent();
        topLevel.hoveringTextInfo.lines = lines;
        topLevel.hoveringTextInfo.x = this.getMouseX();
        topLevel.hoveringTextInfo.y = this.getMouseY();
        topLevel.hoveringTextInfo.font = font;
        topLevel.hoveringTextInfo.shouldDraw = true;
    }

    public void close() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    protected void onChildClosed(GuiComponent child) {
    }

    protected void drawCentered(MatrixStack matrices, ITextComponent text, int y, int color, boolean dropShadow) {
        int length = this.field_230712_o_.func_238414_a_((ITextProperties)text);
        if (dropShadow) {
            this.field_230712_o_.func_243246_a(matrices, text, (float)(this.field_230708_k_ - length) / 2.0f, (float)y, color);
        } else {
            this.field_230712_o_.func_243248_b(matrices, text, (float)(this.field_230708_k_ - length) / 2.0f, (float)y, color);
        }
    }

    protected double getMouseX() {
        return Minecraft.func_71410_x().field_71417_B.func_198024_e() * (double)this.field_230708_k_ / (double)Minecraft.func_71410_x().func_228018_at_().func_198105_m();
    }

    protected double getMouseY() {
        return Minecraft.func_71410_x().field_71417_B.func_198026_f() * (double)this.field_230709_l_ / (double)Minecraft.func_71410_x().func_228018_at_().func_198083_n();
    }

    private static class HoveringTextInfo {
        List<ITextComponent> lines;
        double x;
        double y;
        FontRenderer font;
        boolean shouldDraw = false;

        private HoveringTextInfo() {
        }
    }

    @FunctionalInterface
    static interface UiCall {
        public boolean call(GuiComponent var1);
    }
}

