/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.network.packet.s2c.play.MapDataS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class AtlasData
extends WorldSavedData {
    public static final int VERSION = 4;
    public static final String TAG_VERSION = "aaVersion";
    public static final String TAG_WORLD_MAP_LIST = "qWorldMap";
    public static final String TAG_WORLD_ID = "qWorldID";
    public static final String TAG_VISITED_CHUNKS = "qVisitedChunks";
    public static final String TAG_BROWSING_X = "qBrowseX";
    public static final String TAG_BROWSING_Y = "qBrowseY";
    public static final String TAG_BROWSING_ZOOM = "qBrowseZoom";
    private final Map<RegistryKey<World>, WorldData> worldMap = new ConcurrentHashMap<RegistryKey<World>, WorldData>(2, 0.75f, 2);
    private final Set<PlayerEntity> playersSentTo = new HashSet<PlayerEntity>();

    public AtlasData(String key) {
        super(key);
    }

    public void func_76184_a(CompoundNBT compound) {
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 4) {
            Log.warn("Outdated atlas data format! Was %d but current is %d.", version, 4);
            return;
        }
        ListNBT worldMapList = compound.func_150295_c(TAG_WORLD_MAP_LIST, 10);
        for (int d = 0; d < worldMapList.size(); ++d) {
            CompoundNBT worldTag = worldMapList.func_150305_b(d);
            RegistryKey worldID = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(worldTag.func_74779_i(TAG_WORLD_ID)));
            ListNBT dimensionTag = (ListNBT)worldTag.func_74781_a(TAG_VISITED_CHUNKS);
            WorldData dimData = this.getWorldData((RegistryKey<World>)worldID);
            dimData.readFromNBT(dimensionTag);
            double zoom = worldTag.func_74769_h(TAG_BROWSING_ZOOM);
            if (zoom == 0.0) {
                zoom = 0.5;
            }
            dimData.setBrowsingPosition(worldTag.func_74762_e(TAG_BROWSING_X), worldTag.func_74762_e(TAG_BROWSING_Y), zoom);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        return this.writeToNBT(compound, true);
    }

    public CompoundNBT writeToNBT(CompoundNBT compound, boolean includeTileData) {
        ListNBT dimensionMapList = new ListNBT();
        compound.func_74768_a(TAG_VERSION, 4);
        for (Map.Entry<RegistryKey<World>, WorldData> dimensionEntry : this.worldMap.entrySet()) {
            CompoundNBT dimTag = new CompoundNBT();
            dimTag.func_74778_a(TAG_WORLD_ID, dimensionEntry.getKey().func_240901_a_().toString());
            WorldData dimData = dimensionEntry.getValue();
            if (includeTileData) {
                dimTag.func_218657_a(TAG_VISITED_CHUNKS, (INBT)dimData.writeToNBT());
            }
            dimTag.func_74768_a(TAG_BROWSING_X, dimData.getBrowsingX());
            dimTag.func_74768_a(TAG_BROWSING_Y, dimData.getBrowsingY());
            dimTag.func_74780_a(TAG_BROWSING_ZOOM, dimData.getBrowsingZoom());
            dimensionMapList.add((Object)dimTag);
        }
        compound.func_218657_a(TAG_WORLD_MAP_LIST, (INBT)dimensionMapList);
        return compound;
    }

    public void setTile(RegistryKey<World> world, int x, int y, ResourceLocation tile) {
        WorldData worldData = this.getWorldData(world);
        worldData.setTile(x, y, tile);
    }

    public ResourceLocation removeTile(RegistryKey<World> world, int x, int y) {
        WorldData dimData = this.getWorldData(world);
        return dimData.removeTile(x, y);
    }

    public Set<RegistryKey<World>> getVisitedWorlds() {
        return this.worldMap.keySet();
    }

    public WorldData getWorldData(RegistryKey<World> world) {
        return this.worldMap.computeIfAbsent(world, k -> new WorldData(this, world));
    }

    public Map<ChunkPos, ResourceLocation> getSeenChunksInDimension(RegistryKey<World> world) {
        return this.getWorldData(world).getSeenChunks();
    }

    public Collection<PlayerEntity> getSyncedPlayers() {
        return Collections.unmodifiableCollection(this.playersSentTo);
    }

    public boolean isSyncedOnPlayer(PlayerEntity player) {
        return this.playersSentTo.contains(player);
    }

    public void syncOnPlayer(int atlasID, PlayerEntity player) {
        CompoundNBT data = new CompoundNBT();
        this.writeToNBT(data, false);
        new MapDataS2CPacket(atlasID, data).send((ServerPlayerEntity)player);
        for (RegistryKey<World> world : this.worldMap.keySet()) {
            this.worldMap.get(world).syncOnPlayer(atlasID, player);
        }
        Log.info("Sent Atlas #%d data to player %s", atlasID, player.func_195051_bN().func_197037_c());
        this.playersSentTo.add(player);
    }

    public boolean isEmpty() {
        return this.worldMap.isEmpty();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AtlasData)) {
            return false;
        }
        AtlasData other = (AtlasData)((Object)obj);
        if (other.worldMap.size() != this.worldMap.size()) {
            return false;
        }
        for (RegistryKey<World> key : this.worldMap.keySet()) {
            if (this.worldMap.get(key).equals(other.worldMap.get(key))) continue;
            return false;
        }
        return true;
    }
}

