/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.network.packet.s2c.play.CustomTileInfoS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.Streams;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class TileDataStorage
extends WorldSavedData {
    private static final int VERSION = 3;
    private static final String TAG_VERSION = "aaVersion";
    private static final String TAG_TILE_LIST = "tiles";
    private static final int CHUNK_SIZE = 10000;
    private final Map<ChunkPos, ResourceLocation> tiles = new ConcurrentHashMap<ChunkPos, ResourceLocation>(2, 0.75f, 2);

    public TileDataStorage(String key) {
        super(key);
    }

    public void func_76184_a(CompoundNBT compound) {
        int version = compound.func_74762_e(TAG_VERSION);
        if (version < 3) {
            Log.warn("Outdated atlas data format! Was %d but current is %d", version, 3);
            this.func_76185_a();
        }
        ListNBT tileList = compound.func_150295_c(TAG_TILE_LIST, 10);
        tileList.forEach(tag1 -> {
            CompoundNBT tile = (CompoundNBT)tag1;
            ChunkPos coords = new ChunkPos(tile.func_74762_e("x"), tile.func_74762_e("y"));
            this.tiles.put(coords, ResourceLocation.func_208304_a((String)tile.func_74779_i("id")));
        });
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a(TAG_VERSION, 3);
        ListNBT tileList = new ListNBT();
        for (Map.Entry<ChunkPos, ResourceLocation> entry : this.tiles.entrySet()) {
            CompoundNBT tile = new CompoundNBT();
            tile.func_74768_a("x", entry.getKey().field_77276_a);
            tile.func_74768_a("y", entry.getKey().field_77275_b);
            tile.func_74778_a("id", entry.getValue().toString());
            tileList.add((Object)tile);
        }
        compound.func_218657_a(TAG_TILE_LIST, (INBT)tileList);
        return compound;
    }

    public ResourceLocation getTile(int x, int z) {
        return this.tiles.get(new ChunkPos(x, z));
    }

    public void setTile(int x, int z, ResourceLocation tile) {
        this.tiles.put(new ChunkPos(x, z), tile);
        this.func_76185_a();
    }

    public void removeTile(int x, int z) {
        this.tiles.remove(new ChunkPos(x, z));
        this.func_76185_a();
    }

    public void syncToPlayer(PlayerEntity player, RegistryKey<World> world) {
        Streams.chunked(this.tiles.entrySet().stream(), 10000).forEach(chunk -> new CustomTileInfoS2CPacket(world, (List<Map.Entry<ChunkPos, ResourceLocation>>)chunk).send((ServerPlayerEntity)player));
        Log.info("Sent custom biome data to player %s", player.func_195051_bN().func_197037_c());
    }
}

