/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.MarkersData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;

public class MarkersDataHandler {
    private static final String MARKERS_DATA_PREFIX = "aaMarkers_";
    private final Map<String, MarkersData> markersDataClientCache = new ConcurrentHashMap<String, MarkersData>();

    public MarkersData getMarkersData(ItemStack stack, World world) {
        if (stack.func_77973_b() instanceof AtlasItem) {
            return this.getMarkersData(AtlasItem.getAtlasID(stack), world);
        }
        return null;
    }

    public MarkersData getMarkersData(int atlasID, World world) {
        String key = this.getMarkersDataKey(atlasID);
        if (world.field_72995_K) {
            return this.markersDataClientCache.computeIfAbsent(key, MarkersData::new);
        }
        DimensionSavedDataManager manager = ((ServerWorld)world).func_217481_x();
        return (MarkersData)manager.func_215752_a(() -> new MarkersData(key), key);
    }

    private String getMarkersDataKey(int atlasID) {
        return MARKERS_DATA_PREFIX + atlasID;
    }

    public void onClientConnectedToServer(boolean isRemote) {
        this.markersDataClientCache.clear();
    }
}

