/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.marker;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.mixinhooks.EntityHooksAA;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class NetherPortalWatcher {
    private final Map<Integer, DimensionType> teleportingPlayersOrigin = new ConcurrentHashMap<Integer, DimensionType>();

    private void addPortalMarkerIfNone(PlayerEntity player) {
        if (!AntiqueAtlasMod.CONFIG.autoNetherPortalMarkers || player.func_130014_f_().field_72995_K) {
            return;
        }
        World world = player.func_130014_f_();
        if (!AntiqueAtlasMod.CONFIG.itemNeeded) {
            this.addPortalMarkerIfNone(player, world, player.func_110124_au().hashCode());
            return;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof AtlasItem)) continue;
            this.addPortalMarkerIfNone(player, world, AtlasItem.getAtlasID(stack));
        }
    }

    private void addPortalMarkerIfNone(PlayerEntity player, World world, int atlasID) {
        int z;
        int x;
        MarkerType netherPortalType = (MarkerType)MarkerType.REGISTRY.func_82594_a(AntiqueAtlasMod.id("nether_portal"));
        if (netherPortalType == null) {
            return;
        }
        DimensionMarkersData data = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world).getMarkersDataInWorld((RegistryKey<World>)world.func_234923_W_());
        List<Marker> markers = data.getMarkersAtChunk(((x = (int)player.func_226277_ct_()) >> 4) / 8, ((z = (int)player.func_226281_cx_()) >> 4) / 8);
        if (markers != null) {
            for (Marker marker : markers) {
                if (!marker.getType().equals((Object)"antiqueatlas:nether_portal")) continue;
                return;
            }
        }
        AtlasAPI.getMarkerAPI().putMarker(world, false, atlasID, MarkerType.REGISTRY.func_177774_c((Object)netherPortalType), (ITextComponent)new TranslationTextComponent("gui.antiqueatlas.marker.netherPortal"), x, z);
    }

    private static boolean isEntityInPortal(Entity entity) {
        return ((EntityHooksAA)entity).antiqueAtlas_isInPortal();
    }
}

