/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.network.AntiqueAtlasNetworking;
import hunternif.mc.impl.atlas.network.packet.c2s.C2SPacket;
import hunternif.mc.impl.atlas.util.Log;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.simple.MessageType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class BrowsingPositionC2SPacket
extends C2SPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "c2s", "browsing_position");
    int atlasID;
    RegistryKey<World> world;
    int x;
    int y;
    double zoom;

    public BrowsingPositionC2SPacket(int atlasID, RegistryKey<World> world, int x, int y, double zoom) {
        this.atlasID = atlasID;
        this.world = world;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
    }

    public BrowsingPositionC2SPacket(PacketBuffer buf) {
        this.atlasID = buf.func_150792_a();
        this.world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        this.x = buf.func_150792_a();
        this.y = buf.func_150792_a();
        this.zoom = buf.readDouble();
    }

    public MessageType getType() {
        return AntiqueAtlasNetworking.BROWSING_POSITION;
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.atlasID);
        buf.func_192572_a(this.world.func_240901_a_());
        buf.func_150787_b(this.x);
        buf.func_150787_b(this.y);
        buf.writeDouble(this.zoom);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            if (AntiqueAtlasMod.CONFIG.itemNeeded && !AtlasAPI.getPlayerAtlases(context.getPlayer()).contains(this.atlasID)) {
                Log.warn("Player %s attempted to put position marker into someone else's Atlas #%d", context.getPlayer().func_195051_bN().func_197037_c(), this.atlasID);
                return;
            }
            AntiqueAtlasMod.tileData.getData(this.atlasID, context.getPlayer().func_130014_f_()).getWorldData(this.world).setBrowsingPosition(this.x, this.y, this.zoom);
        });
    }
}

